/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.util.HostUtil;
import org.apache.hadoop.util.Progressable;

public class Hadoop23Shims
extends HadoopShimsSecure {
    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return HostUtil.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContextImpl(conf, new TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }
}

