/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="split", value="_FUNC_(str, regex) - Splits str around occurances that match regex", extended="Example:\n  > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]') FROM src LIMIT 1;\n  [\"one\", \"two\", \"three\"]")
public class GenericUDFSplit
extends GenericUDF {
    private ObjectInspectorConverters.Converter[] converters;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function SPLIT(s, regexp) takes exactly 2 arguments.");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter(arguments[i], PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        Text s = (Text)this.converters[0].convert(arguments[0].get());
        Text regex = (Text)this.converters[1].convert(arguments[1].get());
        ArrayList<Text> result = new ArrayList<Text>();
        for (String str : s.toString().split(regex.toString(), -1)) {
            result.add(new Text(str));
        }
        return result;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return "split(" + children[0] + ", " + children[1] + ")";
    }
}

