/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinMetaData;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinObjectValue
implements Externalizable {
    protected transient int metadataTag;
    protected transient MapJoinRowContainer<Object[]> obj;

    public MapJoinObjectValue() {
    }

    public MapJoinObjectValue(int metadataTag, MapJoinRowContainer<Object[]> obj) {
        this.metadataTag = metadataTag;
        this.obj = obj;
    }

    public boolean equals(Object o) {
        MapJoinObjectValue mObj;
        if (o instanceof MapJoinObjectValue && (mObj = (MapJoinObjectValue)o).getMetadataTag() == this.metadataTag) {
            if (this.obj == null && mObj.getObj() == null) {
                return true;
            }
            if (this.obj != null && mObj.getObj() != null && mObj.getObj().equals(this.obj)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.obj == null ? 0 : this.obj.hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.metadataTag = in.readInt();
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = MapJoinMetaData.get(this.metadataTag);
            int sz = in.readInt();
            MapJoinRowContainer<Object[]> res = new MapJoinRowContainer<Object[]>();
            if (sz > 0) {
                int numCols = in.readInt();
                if (numCols > 0) {
                    for (int pos = 0; pos < sz; ++pos) {
                        Writable val = ctx.getSerDe().getSerializedClass().newInstance();
                        val.readFields((DataInput)in);
                        ArrayList memObj = (ArrayList)ObjectInspectorUtils.copyToStandardObject(ctx.getSerDe().deserialize(val), ctx.getSerDe().getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                        if (memObj == null) {
                            res.add(new ArrayList(0).toArray());
                            continue;
                        }
                        res.add(memObj.toArray());
                    }
                } else {
                    for (int i = 0; i < sz; ++i) {
                        res.add(new ArrayList(0).toArray());
                    }
                }
            }
            this.obj = res;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeInt(this.metadataTag);
            HashTableSinkOperator.HashTableSinkObjectCtx ctx = MapJoinMetaData.get(this.metadataTag);
            MapJoinRowContainer<Object[]> v = this.obj;
            out.writeInt((int)v.size());
            if (v.size() > 0L) {
                Object[] row = v.first();
                out.writeInt(row.length);
                if (row.length > 0) {
                    while (row != null) {
                        Writable outVal = ctx.getSerDe().serialize(row, ctx.getStandardOI());
                        outVal.write((DataOutput)out);
                        row = v.next();
                    }
                }
            }
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
    }

    public int getMetadataTag() {
        return this.metadataTag;
    }

    public void setMetadataTag(int metadataTag) {
        this.metadataTag = metadataTag;
    }

    public MapJoinRowContainer<Object[]> getObj() {
        return this.obj;
    }

    public void setObj(MapJoinRowContainer<Object[]> obj) {
        this.obj = obj;
    }
}

