/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.errors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.ErrorHeuristic;
import org.apache.hadoop.mapred.JobConf;

public abstract class RegexErrorHeuristic
implements ErrorHeuristic {
    private String query = null;
    private JobConf conf = null;
    private String queryRegex = null;
    private boolean queryMatches = false;
    private final Set<String> logRegexes = new HashSet<String>();
    private final Map<String, List<String>> regexToLogLines = new HashMap<String, List<String>>();
    private final Map<String, Pattern> regexToPattern = new HashMap<String, Pattern>();

    protected void setQueryRegex(String queryRegex) {
        this.queryRegex = queryRegex;
    }

    protected String getQueryRegex() {
        return this.queryRegex;
    }

    protected boolean getQueryMatches() {
        return this.queryMatches;
    }

    protected Set<String> getLogRegexes() {
        return this.logRegexes;
    }

    protected Map<String, List<String>> getRegexToLogLines() {
        return this.regexToLogLines;
    }

    protected JobConf getConf() {
        return this.conf;
    }

    @Override
    public void init(String query, JobConf conf) {
        this.query = query;
        this.conf = conf;
        assert (this.logRegexes != null && this.queryRegex != null);
        Pattern queryPattern = Pattern.compile(this.queryRegex, 2);
        this.queryMatches = queryPattern.matcher(query).find();
        for (String regex : this.logRegexes) {
            this.regexToPattern.put(regex, Pattern.compile(regex, 2));
            this.regexToLogLines.put(regex, new ArrayList());
        }
    }

    @Override
    public abstract ErrorAndSolution getErrorAndSolution();

    @Override
    public void processLogLine(String line) {
        if (this.queryMatches) {
            for (Map.Entry<String, Pattern> e : this.regexToPattern.entrySet()) {
                String regex = e.getKey();
                Pattern p = e.getValue();
                boolean lineMatches = p.matcher(line).find();
                if (!lineMatches) continue;
                this.regexToLogLines.get(regex).add(line);
            }
        }
    }

    protected void reset() {
        for (List<String> lst : this.regexToLogLines.values()) {
            lst.clear();
        }
    }
}

