/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.udaf.example;

import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;

public final class UDAFExampleAvg
extends UDAF {
    private UDAFExampleAvg() {
    }

    public static class UDAFExampleAvgEvaluator
    implements UDAFEvaluator {
        UDAFAvgState state = new UDAFAvgState();

        public UDAFExampleAvgEvaluator() {
            this.init();
        }

        public void init() {
            this.state.mSum = 0.0;
            this.state.mCount = 0L;
        }

        public boolean iterate(Double o) {
            if (o != null) {
                this.state.mSum += o;
                this.state.mCount++;
            }
            return true;
        }

        public UDAFAvgState terminatePartial() {
            return this.state.mCount == 0L ? null : this.state;
        }

        public boolean merge(UDAFAvgState o) {
            if (o != null) {
                this.state.mSum += o.mSum;
                this.state.mCount += o.mCount;
            }
            return true;
        }

        public Double terminate() {
            return this.state.mCount == 0L ? null : Double.valueOf(this.state.mSum / (double)this.state.mCount);
        }
    }

    public static class UDAFAvgState {
        private long mCount;
        private double mSum;
    }
}

