/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.serde2.s3;

import java.nio.charset.CharacterCodingException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.contrib.serde2.s3.S3LogStruct;
import org.apache.hadoop.hive.serde2.AbstractDeserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ReflectionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class S3LogDeserializer
extends AbstractDeserializer {
    public static final Log LOG = LogFactory.getLog((String)S3LogDeserializer.class.getName());
    private ObjectInspector cachedObjectInspector;
    static Pattern regexpat;
    S3LogStruct deserializeCache = new S3LogStruct();

    public String toString() {
        return "S3ZemantaDeserializer[]";
    }

    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        this.cachedObjectInspector = ObjectInspectorFactory.getReflectionObjectInspector(S3LogStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        LOG.debug((Object)(((Object)((Object)this)).getClass().getName() + ": initialized"));
    }

    public static Integer toInt(String s) {
        if (s.compareTo("-") == 0) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public static Object deserialize(S3LogStruct c, String row) throws Exception {
        Matcher match = regexpat.matcher(row);
        int t = 1;
        try {
            match.matches();
            c.bucketowner = match.group(t++);
            c.bucketname = match.group(t++);
        }
        catch (Exception e) {
            throw new SerDeException("S3 Log Regex did not match:" + row, (Throwable)e);
        }
        c.rdatetime = match.group(t++);
        c.rip = match.group(t++);
        c.requester = match.group(t++);
        c.requestid = match.group(t++);
        c.operation = match.group(t++);
        c.rkey = match.group(t++);
        c.requesturi = match.group(t++);
        c.httpstatus = S3LogDeserializer.toInt(match.group(t++));
        c.errorcode = match.group(t++);
        c.bytessent = S3LogDeserializer.toInt(match.group(t++));
        c.objsize = S3LogDeserializer.toInt(match.group(t++));
        c.totaltime = S3LogDeserializer.toInt(match.group(t++));
        c.turnaroundtime = S3LogDeserializer.toInt(match.group(t++));
        c.referer = match.group(t++);
        c.useragent = match.group(t++);
        return c;
    }

    public Object deserialize(Writable field) throws SerDeException {
        String row = null;
        if (field instanceof BytesWritable) {
            BytesWritable b = (BytesWritable)field;
            try {
                row = Text.decode((byte[])b.getBytes(), (int)0, (int)b.getLength());
            }
            catch (CharacterCodingException e) {
                throw new SerDeException((Throwable)e);
            }
        } else if (field instanceof Text) {
            row = field.toString();
        }
        try {
            S3LogDeserializer.deserialize(this.deserializeCache, row);
            return this.deserializeCache;
        }
        catch (ClassCastException e) {
            throw new SerDeException(((Object)((Object)this)).getClass().getName() + " expects Text or BytesWritable", (Throwable)e);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public static void main(String[] args) {
        System.err.println("This is only a test run");
        try {
            S3LogDeserializer serDe = new S3LogDeserializer();
            Configuration conf = new Configuration();
            Properties tbl = new Properties();
            Text sample = new Text("04ff331638adc13885d6c42059584deabbdeabcd55bf0bee491172a79a87b196 img.zemanta.com [10/Apr/2009:05:34:01 +0000] 70.32.81.92 65a011a29cdf8ec533ec3d1ccaae921c F939A7D698D27C63 REST.GET.OBJECT reblog_b.png \"GET /reblog_b.png?x-id=79ca9376-6326-41b7-9257-eea43d112eb2 HTTP/1.0\" 200 - 1250 1250 160 159 \"-\" \"Firefox 0.8 (Linux)\" useragent=\"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.6) Gecko/20040614 Firefox/0.8\"");
            serDe.initialize(conf, tbl);
            Object row = serDe.deserialize((Writable)sample);
            System.err.println(serDe.getObjectInspector().getClass().toString());
            ReflectionStructObjectInspector oi = (ReflectionStructObjectInspector)serDe.getObjectInspector();
            List fieldRefs = oi.getAllStructFieldRefs();
            for (int i = 0; i < fieldRefs.size(); ++i) {
                System.err.println(((StructField)fieldRefs.get(i)).toString());
                Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
                if (fieldData == null) {
                    System.err.println("null");
                    continue;
                }
                System.err.println(fieldData.toString());
            }
        }
        catch (Exception e) {
            System.err.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    static {
        StackTraceElement[] sTrace = new Exception().getStackTrace();
        sTrace[0].getClassName();
        regexpat = Pattern.compile("(\\S+) (\\S+) \\[(.*?)\\] (\\S+) (\\S+) (\\S+) (\\S+) (\\S+) \"(.+)\" (\\S+) (\\S+) (\\S+) (\\S+) (\\S+) (\\S+) \"(.*)\" \"(.*)\"");
    }
}

