/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.udtf.example;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="explode2", value="_FUNC_(a) - like explode, but outputs two identical columns (for testing purposes)")
public class GenericUDTFExplode2
extends GenericUDTF {
    ListObjectInspector listOI = null;
    Object[] forwardObj = new Object[2];

    public void close() throws HiveException {
    }

    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 1) {
            throw new UDFArgumentException("explode() takes only one argument");
        }
        if (args[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("explode() takes an array as a parameter");
        }
        this.listOI = (ListObjectInspector)args[0];
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        fieldNames.add("col1");
        fieldNames.add("col2");
        fieldOIs.add(this.listOI.getListElementObjectInspector());
        fieldOIs.add(this.listOI.getListElementObjectInspector());
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] o) throws HiveException {
        List list = this.listOI.getList(o[0]);
        for (Object r : list) {
            this.forwardObj[0] = r;
            this.forwardObj[1] = r;
            this.forward(this.forwardObj);
        }
    }

    public String toString() {
        return "explode";
    }
}

