/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Shell;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveConf {
    @Test
    public void testHiveSitePath() throws Exception {
        String expectedPath = HiveTestUtils.getFileFromClasspath((String)"hive-site.xml");
        String hiveSiteLocation = HiveConf.getHiveSiteLocation().getPath();
        if (Shell.WINDOWS) {
            expectedPath = expectedPath.toLowerCase();
            hiveSiteLocation = hiveSiteLocation.toLowerCase();
        }
        Assert.assertEquals((Object)expectedPath, (Object)hiveSiteLocation);
    }

    private void checkHadoopConf(String name, String expectedHadoopVal) throws Exception {
        Assert.assertEquals((Object)expectedHadoopVal, (Object)new JobConf(HiveConf.class).get(name));
    }

    private void checkConfVar(HiveConf.ConfVars var, String expectedConfVarVal) throws Exception {
        Assert.assertEquals((Object)expectedConfVarVal, (Object)var.getDefaultValue());
    }

    private void checkHiveConf(String name, String expectedHiveVal) throws Exception {
        Assert.assertEquals((Object)expectedHiveVal, (Object)new HiveConf().get(name));
    }

    @Test
    public void testConfProperties() throws Exception {
        this.checkHadoopConf(HiveConf.ConfVars.HADOOPNUMREDUCERS.varname, "1");
        this.checkConfVar(HiveConf.ConfVars.HADOOPNUMREDUCERS, "-1");
        this.checkHiveConf(HiveConf.ConfVars.HADOOPNUMREDUCERS.varname, "-1");
        this.checkHadoopConf(HiveConf.ConfVars.HIVESKEWJOINKEY.varname, null);
        this.checkConfVar(HiveConf.ConfVars.HIVESKEWJOINKEY, "100000");
        this.checkHiveConf(HiveConf.ConfVars.HIVESKEWJOINKEY.varname, "100000");
        this.checkHadoopConf(HiveConf.ConfVars.HIVETESTMODEDUMMYSTATAGGR.varname, null);
        this.checkConfVar(HiveConf.ConfVars.HIVETESTMODEDUMMYSTATAGGR, "");
        this.checkHiveConf(HiveConf.ConfVars.HIVETESTMODEDUMMYSTATAGGR.varname, "value2");
        this.checkHadoopConf("test.property1", null);
        this.checkHiveConf("test.property1", "value1");
        this.checkHiveConf("test.var.hiveconf.property", HiveConf.ConfVars.DEFAULTPARTITIONNAME.getDefaultValue());
    }

    @Test
    public void testColumnNameMapping() throws Exception {
        for (int i = 0; i < 20; ++i) {
            Assert.assertTrue((i == HiveConf.getPositionFromInternalName((String)HiveConf.getColumnInternalName((int)i)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUnitFor() throws Exception {
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)HiveConf.unitFor((String)"L", (TimeUnit)TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)HiveConf.unitFor((String)"", (TimeUnit)TimeUnit.MICROSECONDS)));
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)HiveConf.unitFor((String)"d", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)HiveConf.unitFor((String)"days", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)HiveConf.unitFor((String)"h", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)HiveConf.unitFor((String)"hours", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)HiveConf.unitFor((String)"m", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)HiveConf.unitFor((String)"minutes", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)HiveConf.unitFor((String)"s", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)HiveConf.unitFor((String)"seconds", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)HiveConf.unitFor((String)"ms", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)HiveConf.unitFor((String)"msecs", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)HiveConf.unitFor((String)"us", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)HiveConf.unitFor((String)"useconds", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.NANOSECONDS), (Object)((Object)HiveConf.unitFor((String)"ns", null)));
        Assert.assertEquals((Object)((Object)TimeUnit.NANOSECONDS), (Object)((Object)HiveConf.unitFor((String)"nsecs", null)));
    }

    @Test
    public void testHiddenConfig() throws Exception {
        HiveConf conf = new HiveConf();
        Assert.assertTrue((boolean)conf.isHiddenConfig(HiveConf.ConfVars.METASTOREPWD.varname));
        Assert.assertTrue((boolean)conf.isHiddenConfig(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname));
        try {
            String name = HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST.varname;
            conf.verifyAndSet(name, "");
            Assert.fail((String)("Setting config property " + name + " should fail"));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Configuration conf2 = new Configuration((Configuration)conf);
        conf2.set(HiveConf.ConfVars.METASTOREPWD.varname, "password");
        conf2.set(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname, "password");
        conf.stripHiddenConfigurations(conf2);
        Assert.assertEquals((Object)"", (Object)conf2.get(HiveConf.ConfVars.METASTOREPWD.varname));
        Assert.assertEquals((Object)"", (Object)conf2.get(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname));
    }
}

