/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.LoopingByteArrayInputStream;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hive.common.HiveCompat;

public class HiveConf
extends Configuration {
    protected String hiveJar;
    protected Properties origProp;
    protected String auxJars;
    private static final Log l4j = LogFactory.getLog(HiveConf.class);
    private static URL hiveDefaultURL = null;
    private static URL hiveSiteURL = null;
    private static byte[] confVarByteArray = null;
    private static final Map<String, ConfVars> vars = new HashMap<String, ConfVars>();
    private final List<String> restrictList = new ArrayList<String>();
    private boolean isWhiteListRestrictionEnabled = false;
    private final List<String> modWhiteList = new ArrayList<String>();
    public static final ConfVars[] metaVars;
    public static final ConfVars[] dbVars;

    private static synchronized InputStream getConfVarInputStream() {
        if (confVarByteArray == null) {
            try {
                Configuration conf = new Configuration(false);
                HiveConf.applyDefaultNonNullConfVars(conf);
                ByteArrayOutputStream confVarBaos = new ByteArrayOutputStream();
                conf.writeXml((OutputStream)confVarBaos);
                confVarByteArray = confVarBaos.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize default Hive configuration variables!", e);
            }
        }
        return new LoopingByteArrayInputStream(confVarByteArray);
    }

    public void verifyAndSet(String name, String value) throws IllegalArgumentException {
        if (this.isWhiteListRestrictionEnabled && !this.modWhiteList.contains(name)) {
            throw new IllegalArgumentException("Cannot modify " + name + " at runtime. " + "It is not in list of params that are allowed to be modified at runtime");
        }
        if (this.restrictList.contains(name)) {
            throw new IllegalArgumentException("Cannot modify " + name + " at runtime. It is in the list" + "of parameters that can't be modified at runtime");
        }
        this.set(name, value);
    }

    public static int getIntVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Integer.class) : var.varname;
        return conf.getInt(var.varname, var.defaultIntVal);
    }

    public static void setIntVar(Configuration conf, ConfVars var, int val) {
        assert (var.valClass == Integer.class) : var.varname;
        conf.setInt(var.varname, val);
    }

    public int getIntVar(ConfVars var) {
        return HiveConf.getIntVar(this, var);
    }

    public void setIntVar(ConfVars var, int val) {
        HiveConf.setIntVar(this, var, val);
    }

    public static long getLongVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Long.class) : var.varname;
        return conf.getLong(var.varname, var.defaultLongVal);
    }

    public static long getLongVar(Configuration conf, ConfVars var, long defaultVal) {
        return conf.getLong(var.varname, defaultVal);
    }

    public static void setLongVar(Configuration conf, ConfVars var, long val) {
        assert (var.valClass == Long.class) : var.varname;
        conf.setLong(var.varname, val);
    }

    public long getLongVar(ConfVars var) {
        return HiveConf.getLongVar(this, var);
    }

    public void setLongVar(ConfVars var, long val) {
        HiveConf.setLongVar(this, var, val);
    }

    public static float getFloatVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Float.class) : var.varname;
        return conf.getFloat(var.varname, var.defaultFloatVal);
    }

    public static float getFloatVar(Configuration conf, ConfVars var, float defaultVal) {
        return conf.getFloat(var.varname, defaultVal);
    }

    public static void setFloatVar(Configuration conf, ConfVars var, float val) {
        assert (var.valClass == Float.class) : var.varname;
        conf.setFloat(var.varname, val);
    }

    public float getFloatVar(ConfVars var) {
        return HiveConf.getFloatVar(this, var);
    }

    public void setFloatVar(ConfVars var, float val) {
        HiveConf.setFloatVar(this, var, val);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Boolean.class) : var.varname;
        return conf.getBoolean(var.varname, var.defaultBoolVal);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var, boolean defaultVal) {
        return conf.getBoolean(var.varname, defaultVal);
    }

    public static void setBoolVar(Configuration conf, ConfVars var, boolean val) {
        assert (var.valClass == Boolean.class) : var.varname;
        conf.setBoolean(var.varname, val);
    }

    public boolean getBoolVar(ConfVars var) {
        return HiveConf.getBoolVar(this, var);
    }

    public void setBoolVar(ConfVars var, boolean val) {
        HiveConf.setBoolVar(this, var, val);
    }

    public static String getVar(Configuration conf, ConfVars var) {
        assert (var.valClass == String.class) : var.varname;
        return conf.get(var.varname, var.defaultVal);
    }

    public static String getVar(Configuration conf, ConfVars var, String defaultVal) {
        return conf.get(var.varname, defaultVal);
    }

    public static void setVar(Configuration conf, ConfVars var, String val) {
        assert (var.valClass == String.class) : var.varname;
        conf.set(var.varname, val);
    }

    public static ConfVars getConfVars(String name) {
        return vars.get(name);
    }

    public String getVar(ConfVars var) {
        return HiveConf.getVar(this, var);
    }

    public void setVar(ConfVars var, String val) {
        HiveConf.setVar(this, var, val);
    }

    public void logVars(PrintStream ps) {
        for (ConfVars one : ConfVars.values()) {
            ps.println(one.varname + "=" + (this.get(one.varname) != null ? this.get(one.varname) : ""));
        }
    }

    public HiveConf() {
        this.initialize(((Object)((Object)this)).getClass());
    }

    public HiveConf(Class<?> cls) {
        this.initialize(cls);
    }

    public HiveConf(Configuration other, Class<?> cls) {
        super(other);
        this.initialize(cls);
    }

    public HiveConf(HiveConf other) {
        super((Configuration)other);
        this.hiveJar = other.hiveJar;
        this.auxJars = other.auxJars;
        this.origProp = (Properties)other.origProp.clone();
        this.restrictList.addAll(other.restrictList);
    }

    public Properties getAllProperties() {
        return HiveConf.getProperties(this);
    }

    private static Properties getProperties(Configuration conf) {
        Iterator iter = conf.iterator();
        Properties p = new Properties();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            p.setProperty((String)e.getKey(), (String)e.getValue());
        }
        return p;
    }

    private void initialize(Class<?> cls) {
        this.hiveJar = new JobConf(cls).getJar();
        this.origProp = this.getAllProperties();
        this.addResource(HiveConf.getConfVarInputStream());
        if (hiveSiteURL != null) {
            this.addResource(hiveSiteURL);
        }
        this.applySystemProperties();
        if (this.get("hive.metastore.local", null) != null) {
            l4j.warn((Object)"DEPRECATED: Configuration property hive.metastore.local no longer has any effect. Make sure to provide a valid value for hive.metastore.uris if you are connecting to a remote metastore.");
        }
        if (this.get("hive.metastore.ds.retry.attempts") != null || this.get("hive.metastore.ds.retry.interval") != null) {
            l4j.warn((Object)"DEPRECATED: hive.metastore.ds.retry.* no longer has any effect.  Use hive.hmshandler.retry.* instead");
        }
        if (this.hiveJar == null) {
            this.hiveJar = this.get(ConfVars.HIVEJAR.varname);
        }
        if (this.auxJars == null) {
            this.auxJars = this.get(ConfVars.HIVEAUXJARS.varname);
        }
        if (this.getBoolVar(ConfVars.METASTORE_SCHEMA_VERIFICATION)) {
            this.setBoolVar(ConfVars.METASTORE_AUTO_CREATE_SCHEMA, false);
            this.setBoolVar(ConfVars.METASTORE_FIXED_DATASTORE, true);
        }
        this.setupRestrictList();
    }

    private void applySystemProperties() {
        Map<String, String> systemProperties = HiveConf.getConfSystemProperties();
        for (Map.Entry<String, String> systemProperty : systemProperties.entrySet()) {
            this.set(systemProperty.getKey(), systemProperty.getValue());
        }
    }

    public static Map<String, String> getConfSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (ConfVars oneVar : ConfVars.values()) {
            if (System.getProperty(oneVar.varname) == null || System.getProperty(oneVar.varname).length() <= 0) continue;
            systemProperties.put(oneVar.varname, System.getProperty(oneVar.varname));
        }
        return systemProperties;
    }

    private static void applyDefaultNonNullConfVars(Configuration conf) {
        for (ConfVars var : ConfVars.values()) {
            if (var.defaultVal == null) continue;
            conf.set(var.varname, var.defaultVal);
        }
    }

    public Properties getChangedProperties() {
        Properties ret = new Properties();
        Properties newProp = this.getAllProperties();
        for (Object one : newProp.keySet()) {
            String oneProp = (String)one;
            String oldValue = this.origProp.getProperty(oneProp);
            if (StringUtils.equals((String)oldValue, (String)newProp.getProperty(oneProp))) continue;
            ret.setProperty(oneProp, newProp.getProperty(oneProp));
        }
        return ret;
    }

    public String getJar() {
        return this.hiveJar;
    }

    public String getAuxJars() {
        return this.auxJars;
    }

    public void setAuxJars(String auxJars) {
        this.auxJars = auxJars;
        HiveConf.setVar(this, ConfVars.HIVEAUXJARS, auxJars);
    }

    public URL getHiveDefaultLocation() {
        return hiveDefaultURL;
    }

    public static void setHiveSiteLocation(URL location) {
        hiveSiteURL = location;
    }

    public static URL getHiveSiteLocation() {
        return hiveSiteURL;
    }

    public String getUser() throws IOException {
        try {
            UserGroupInformation ugi = ShimLoader.getHadoopShims().getUGIForConf((Configuration)this);
            return ugi.getUserName();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }

    public static String getColumnInternalName(int pos) {
        return "_col" + pos;
    }

    public static int getPositionFromInternalName(String internalName) {
        Pattern internalPattern = Pattern.compile("_col([0-9]+)");
        Matcher m = internalPattern.matcher(internalName);
        if (!m.matches()) {
            return -1;
        }
        return Integer.parseInt(m.group(1));
    }

    public void addToRestrictList(String restrictListStr) {
        if (restrictListStr == null) {
            return;
        }
        String oldList = this.getVar(ConfVars.HIVE_CONF_RESTRICTED_LIST);
        if (oldList == null || oldList.isEmpty()) {
            this.setVar(ConfVars.HIVE_CONF_RESTRICTED_LIST, restrictListStr);
        } else {
            this.setVar(ConfVars.HIVE_CONF_RESTRICTED_LIST, oldList + "," + restrictListStr);
        }
        this.setupRestrictList();
    }

    @InterfaceAudience.LimitedPrivate(value={"Currently only for use by HiveAuthorizer"})
    public void setIsModWhiteListEnabled(boolean isEnabled) {
        this.isWhiteListRestrictionEnabled = isEnabled;
    }

    @InterfaceAudience.LimitedPrivate(value={"Currently only for use by HiveAuthorizer"})
    public void addToModifiableWhiteList(String paramname) {
        if (paramname == null) {
            return;
        }
        this.modWhiteList.add(paramname);
    }

    private void setupRestrictList() {
        String restrictListStr = this.getVar(ConfVars.HIVE_CONF_RESTRICTED_LIST);
        this.restrictList.clear();
        if (restrictListStr != null) {
            for (String entry : restrictListStr.split(",")) {
                this.restrictList.add(entry.trim());
            }
        }
        this.restrictList.add(ConfVars.HIVE_IN_TEST.varname);
        this.restrictList.add(ConfVars.HIVE_CONF_RESTRICTED_LIST.varname);
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = HiveConf.class.getClassLoader();
        }
        hiveDefaultURL = classLoader.getResource("hive-default.xml");
        hiveSiteURL = classLoader.getResource("hive-site.xml");
        for (ConfVars confVar : ConfVars.values()) {
            vars.put(confVar.varname, confVar);
        }
        metaVars = new ConfVars[]{ConfVars.METASTOREDIRECTORY, ConfVars.METASTOREWAREHOUSE, ConfVars.METASTOREURIS, ConfVars.METASTORETHRIFTCONNECTIONRETRIES, ConfVars.METASTORETHRIFTFAILURERETRIES, ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, ConfVars.METASTOREPWD, ConfVars.METASTORECONNECTURLHOOK, ConfVars.METASTORECONNECTURLKEY, ConfVars.METASTOREFORCERELOADCONF, ConfVars.METASTORESERVERMINTHREADS, ConfVars.METASTORESERVERMAXTHREADS, ConfVars.METASTORE_TCP_KEEP_ALIVE, ConfVars.METASTORE_INT_ORIGINAL, ConfVars.METASTORE_INT_ARCHIVED, ConfVars.METASTORE_INT_EXTRACTED, ConfVars.METASTORE_KERBEROS_KEYTAB_FILE, ConfVars.METASTORE_KERBEROS_PRINCIPAL, ConfVars.METASTORE_USE_THRIFT_SASL, ConfVars.METASTORE_CACHE_PINOBJTYPES, ConfVars.METASTORE_CONNECTION_POOLING_TYPE, ConfVars.METASTORE_VALIDATE_TABLES, ConfVars.METASTORE_VALIDATE_COLUMNS, ConfVars.METASTORE_VALIDATE_CONSTRAINTS, ConfVars.METASTORE_STORE_MANAGER_TYPE, ConfVars.METASTORE_AUTO_CREATE_SCHEMA, ConfVars.METASTORE_AUTO_START_MECHANISM_MODE, ConfVars.METASTORE_TRANSACTION_ISOLATION, ConfVars.METASTORE_CACHE_LEVEL2, ConfVars.METASTORE_CACHE_LEVEL2_TYPE, ConfVars.METASTORE_IDENTIFIER_FACTORY, ConfVars.METASTORE_PLUGIN_REGISTRY_BUNDLE_CHECK, ConfVars.METASTORE_AUTHORIZATION_STORAGE_AUTH_CHECKS, ConfVars.METASTORE_BATCH_RETRIEVE_MAX, ConfVars.METASTORE_EVENT_LISTENERS, ConfVars.METASTORE_EVENT_CLEAN_FREQ, ConfVars.METASTORE_EVENT_EXPIRY_DURATION, ConfVars.METASTORE_RAW_STORE_IMPL, ConfVars.METASTORE_END_FUNCTION_LISTENERS, ConfVars.METASTORE_PART_INHERIT_TBL_PROPS, ConfVars.METASTORE_BATCH_RETRIEVE_TABLE_PARTITION_MAX, ConfVars.METASTORE_INIT_HOOKS, ConfVars.METASTORE_PRE_EVENT_LISTENERS, ConfVars.HMSHANDLERATTEMPTS, ConfVars.HMSHANDLERINTERVAL, ConfVars.HMSHANDLERFORCERELOADCONF, ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN, ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES, ConfVars.USERS_IN_ADMIN_ROLE, ConfVars.HIVE_AUTHORIZATION_MANAGER, ConfVars.HIVE_TXN_MANAGER, ConfVars.HIVE_TXN_TIMEOUT, ConfVars.HIVE_TXN_MAX_OPEN_BATCH};
        dbVars = new ConfVars[]{ConfVars.HADOOPBIN, ConfVars.METASTOREWAREHOUSE, ConfVars.SCRATCHDIR};
    }

    public static class RatioValidator
    implements Validator {
        @Override
        public String validate(String value) {
            try {
                float fvalue = Float.valueOf(value).floatValue();
                if (fvalue <= 0.0f || fvalue >= 1.0f) {
                    return "Invalid ratio " + value + ", which should be in between 0 to 1";
                }
            }
            catch (NumberFormatException e) {
                return e.toString();
            }
            return null;
        }
    }

    public static class PatternValidator
    implements Validator {
        private final List<Pattern> expected = new ArrayList<Pattern>();

        private PatternValidator(String ... values) {
            for (String value : values) {
                this.expected.add(Pattern.compile(value));
            }
        }

        @Override
        public String validate(String value) {
            if (value == null) {
                return "Invalid value.. expects one of patterns " + this.expected;
            }
            for (Pattern pattern : this.expected) {
                if (!pattern.matcher(value).matches()) continue;
                return null;
            }
            return "Invalid value.. expects one of patterns " + this.expected;
        }
    }

    public static class LongRangeValidator
    implements Validator {
        private final long lower;
        private final long upper;

        public LongRangeValidator(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public String validate(String value) {
            try {
                if (value == null) {
                    return "Value cannot be null";
                }
                long lvalue = Long.parseLong(value = value.trim());
                if (lvalue < this.lower || lvalue > this.upper) {
                    return "Invalid value  " + value + ", which should be in between " + this.lower + " and " + this.upper;
                }
            }
            catch (NumberFormatException e) {
                return e.toString();
            }
            return null;
        }
    }

    public static class StringsValidator
    implements Validator {
        private final Set<String> expected = new LinkedHashSet<String>();

        private StringsValidator(String ... values) {
            for (String value : values) {
                this.expected.add(value.toLowerCase());
            }
        }

        @Override
        public String validate(String value) {
            if (value == null || !this.expected.contains(value.toLowerCase())) {
                return "Invalid value.. expects one of " + this.expected;
            }
            return null;
        }
    }

    public static interface Validator {
        public String validate(String var1);
    }

    public static enum ConfVars {
        SCRIPTWRAPPER("hive.exec.script.wrapper", null),
        PLAN("hive.exec.plan", ""),
        PLAN_SERIALIZATION("hive.plan.serialization.format", "kryo"),
        SCRATCHDIR("hive.exec.scratchdir", "/user/" + System.getProperty("user.name") + "/tmp/hive/"),
        LOCALSCRATCHDIR("hive.exec.local.scratchdir", System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name")),
        SCRATCHDIRPERMISSION("hive.scratch.dir.permission", "700"),
        SUBMITVIACHILD("hive.exec.submitviachild", false),
        SUBMITLOCALTASKVIACHILD("hive.exec.submit.local.task.via.child", true),
        SCRIPTERRORLIMIT("hive.exec.script.maxerrsize", 100000),
        ALLOWPARTIALCONSUMP("hive.exec.script.allow.partial.consumption", false),
        STREAMREPORTERPERFIX("stream.stderr.reporter.prefix", "reporter:"),
        STREAMREPORTERENABLED("stream.stderr.reporter.enabled", true),
        COMPRESSRESULT("hive.exec.compress.output", false),
        COMPRESSINTERMEDIATE("hive.exec.compress.intermediate", false),
        COMPRESSINTERMEDIATECODEC("hive.intermediate.compression.codec", ""),
        COMPRESSINTERMEDIATETYPE("hive.intermediate.compression.type", ""),
        BYTESPERREDUCER("hive.exec.reducers.bytes.per.reducer", 1000000000L),
        MAXREDUCERS("hive.exec.reducers.max", 999),
        PREEXECHOOKS("hive.exec.pre.hooks", ""),
        POSTEXECHOOKS("hive.exec.post.hooks", ""),
        ONFAILUREHOOKS("hive.exec.failure.hooks", ""),
        CLIENTSTATSPUBLISHERS("hive.client.stats.publishers", ""),
        EXECPARALLEL("hive.exec.parallel", false),
        EXECPARALLETHREADNUMBER("hive.exec.parallel.thread.number", 8),
        HIVESPECULATIVEEXECREDUCERS("hive.mapred.reduce.tasks.speculative.execution", true),
        HIVECOUNTERSPULLINTERVAL("hive.exec.counters.pull.interval", 1000L),
        DYNAMICPARTITIONING("hive.exec.dynamic.partition", true),
        DYNAMICPARTITIONINGMODE("hive.exec.dynamic.partition.mode", "strict"),
        DYNAMICPARTITIONMAXPARTS("hive.exec.max.dynamic.partitions", 1000),
        DYNAMICPARTITIONMAXPARTSPERNODE("hive.exec.max.dynamic.partitions.pernode", 100),
        MAXCREATEDFILES("hive.exec.max.created.files", 100000L),
        DOWNLOADED_RESOURCES_DIR("hive.downloaded.resources.dir", System.getProperty("java.io.tmpdir") + File.separator + "${hive.session.id}_resources"),
        DEFAULTPARTITIONNAME("hive.exec.default.partition.name", "__HIVE_DEFAULT_PARTITION__"),
        DEFAULT_ZOOKEEPER_PARTITION_NAME("hive.lockmgr.zookeeper.default.partition.name", "__HIVE_DEFAULT_ZOOKEEPER_PARTITION__"),
        SHOW_JOB_FAIL_DEBUG_INFO("hive.exec.show.job.failure.debug.info", true),
        JOB_DEBUG_CAPTURE_STACKTRACES("hive.exec.job.debug.capture.stacktraces", true),
        JOB_DEBUG_TIMEOUT("hive.exec.job.debug.timeout", 30000),
        TASKLOG_DEBUG_TIMEOUT("hive.exec.tasklog.debug.timeout", 20000),
        OUTPUT_FILE_EXTENSION("hive.output.file.extension", null),
        TMP_MAPRFS_VOLUME("hive.exec.tmp.maprfsvolume", true),
        HIVE_IN_TEST("hive.in.test", false),
        LOCALMODEAUTO("hive.exec.mode.local.auto", false),
        LOCALMODEMAXBYTES("hive.exec.mode.local.auto.inputbytes.max", 0x8000000L),
        LOCALMODEMAXINPUTFILES("hive.exec.mode.local.auto.input.files.max", 4),
        DROPIGNORESNONEXISTENT("hive.exec.drop.ignorenonexistent", true),
        HIVEIGNOREMAPJOINHINT("hive.ignore.mapjoin.hint", true),
        HIVE_FILE_MAX_FOOTER("hive.file.max.footer", 100),
        HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES("hive.resultset.use.unique.column.names", true),
        HADOOPBIN("hadoop.bin.path", ConfVars.findHadoopBinary()),
        HIVE_FS_HAR_IMPL("fs.har.impl", "org.apache.hadoop.hive.shims.HiveHarFileSystem"),
        HADOOPFS((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPFS"), null),
        HADOOPMAPFILENAME((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPMAPFILENAME"), null),
        HADOOPMAPREDINPUTDIR((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPMAPREDINPUTDIR"), null),
        HADOOPMAPREDINPUTDIRRECURSIVE((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPMAPREDINPUTDIRRECURSIVE"), false),
        MAPREDMAXSPLITSIZE((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMAXSPLITSIZE"), 256000000L),
        MAPREDMINSPLITSIZE((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZE"), 1L),
        MAPREDMINSPLITSIZEPERNODE((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZEPERNODE"), 1L),
        MAPREDMINSPLITSIZEPERRACK((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZEPERRACK"), 1L),
        HADOOPNUMREDUCERS((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPNUMREDUCERS"), -1),
        HADOOPJOBNAME((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPJOBNAME"), null),
        HADOOPSPECULATIVEEXECREDUCERS((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("HADOOPSPECULATIVEEXECREDUCERS"), true),
        MAPREDSETUPCLEANUPNEEDED((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDSETUPCLEANUPNEEDED"), false),
        MAPREDTASKCLEANUPNEEDED((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDTASKCLEANUPNEEDED"), false),
        METASTOREDIRECTORY("hive.metastore.metadb.dir", ""),
        METASTOREWAREHOUSE("hive.metastore.warehouse.dir", "/user/hive/warehouse"),
        METASTOREURIS("hive.metastore.uris", ""),
        METASTORETHRIFTCONNECTIONRETRIES("hive.metastore.connect.retries", 3),
        METASTORETHRIFTFAILURERETRIES("hive.metastore.failure.retries", 1),
        METASTORE_CLIENT_CONNECT_RETRY_DELAY("hive.metastore.client.connect.retry.delay", 1),
        METASTORE_CLIENT_SOCKET_TIMEOUT("hive.metastore.client.socket.timeout", 20),
        METASTOREPWD("javax.jdo.option.ConnectionPassword", "mine"),
        METASTORECONNECTURLHOOK("hive.metastore.ds.connection.url.hook", ""),
        METASTOREMULTITHREADED("javax.jdo.option.Multithreaded", true),
        METASTORECONNECTURLKEY("javax.jdo.option.ConnectionURL", "jdbc:derby:;databaseName=metastore_db;create=true"),
        METASTOREFORCERELOADCONF("hive.metastore.force.reload.conf", false),
        HMSHANDLERATTEMPTS("hive.hmshandler.retry.attempts", 1),
        HMSHANDLERINTERVAL("hive.hmshandler.retry.interval", 1000),
        HMSHANDLERFORCERELOADCONF("hive.hmshandler.force.reload.conf", false),
        METASTORESERVERMINTHREADS("hive.metastore.server.min.threads", 200),
        METASTORESERVERMAXTHREADS("hive.metastore.server.max.threads", 100000),
        METASTORE_TCP_KEEP_ALIVE("hive.metastore.server.tcp.keepalive", true),
        METASTORE_INT_ORIGINAL("hive.metastore.archive.intermediate.original", "_INTERMEDIATE_ORIGINAL"),
        METASTORE_INT_ARCHIVED("hive.metastore.archive.intermediate.archived", "_INTERMEDIATE_ARCHIVED"),
        METASTORE_INT_EXTRACTED("hive.metastore.archive.intermediate.extracted", "_INTERMEDIATE_EXTRACTED"),
        METASTORE_KERBEROS_KEYTAB_FILE("hive.metastore.kerberos.keytab.file", ""),
        METASTORE_KERBEROS_PRINCIPAL("hive.metastore.kerberos.principal", "hive-metastore/_HOST@EXAMPLE.COM"),
        METASTORE_USE_THRIFT_SASL("hive.metastore.sasl.enabled", false),
        METASTORE_USE_THRIFT_FRAMED_TRANSPORT("hive.metastore.thrift.framed.transport.enabled", false),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_CLS("hive.cluster.delegation.token.store.class", "org.apache.hadoop.hive.thrift.MemoryTokenStore"),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_ZK_CONNECTSTR("hive.cluster.delegation.token.store.zookeeper.connectString", ""),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_ZK_ZNODE("hive.cluster.delegation.token.store.zookeeper.znode", "/hive/cluster/delegation"),
        METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_ZK_ACL("hive.cluster.delegation.token.store.zookeeper.acl", ""),
        METASTORE_CACHE_PINOBJTYPES("hive.metastore.cache.pinobjtypes", "Table,StorageDescriptor,SerDeInfo,Partition,Database,Type,FieldSchema,Order"),
        METASTORE_CONNECTION_POOLING_TYPE("datanucleus.connectionPoolingType", "BONECP"),
        METASTORE_VALIDATE_TABLES("datanucleus.validateTables", false),
        METASTORE_VALIDATE_COLUMNS("datanucleus.validateColumns", false),
        METASTORE_VALIDATE_CONSTRAINTS("datanucleus.validateConstraints", false),
        METASTORE_STORE_MANAGER_TYPE("datanucleus.storeManagerType", "rdbms"),
        METASTORE_AUTO_CREATE_SCHEMA("datanucleus.autoCreateSchema", true),
        METASTORE_FIXED_DATASTORE("datanucleus.fixedDatastore", false),
        METASTORE_SCHEMA_VERIFICATION("hive.metastore.schema.verification", false),
        METASTORE_AUTO_START_MECHANISM_MODE("datanucleus.autoStartMechanismMode", "checked"),
        METASTORE_TRANSACTION_ISOLATION("datanucleus.transactionIsolation", "read-committed"),
        METASTORE_CACHE_LEVEL2("datanucleus.cache.level2", false),
        METASTORE_CACHE_LEVEL2_TYPE("datanucleus.cache.level2.type", "none"),
        METASTORE_IDENTIFIER_FACTORY("datanucleus.identifierFactory", "datanucleus1"),
        METASTORE_USE_LEGACY_VALUE_STRATEGY("datanucleus.rdbms.useLegacyNativeValueStrategy", true),
        METASTORE_PLUGIN_REGISTRY_BUNDLE_CHECK("datanucleus.plugin.pluginRegistryBundleCheck", "LOG"),
        METASTORE_BATCH_RETRIEVE_MAX("hive.metastore.batch.retrieve.max", 300),
        METASTORE_BATCH_RETRIEVE_TABLE_PARTITION_MAX("hive.metastore.batch.retrieve.table.partition.max", 1000),
        METASTORE_INIT_HOOKS("hive.metastore.init.hooks", ""),
        METASTORE_PRE_EVENT_LISTENERS("hive.metastore.pre.event.listeners", ""),
        METASTORE_EVENT_LISTENERS("hive.metastore.event.listeners", ""),
        METASTORE_AUTHORIZATION_STORAGE_AUTH_CHECKS("hive.metastore.authorization.storage.checks", false),
        METASTORE_EVENT_CLEAN_FREQ("hive.metastore.event.clean.freq", 0L),
        METASTORE_EVENT_EXPIRY_DURATION("hive.metastore.event.expiry.duration", 0L),
        METASTORE_EXECUTE_SET_UGI("hive.metastore.execute.setugi", false),
        METASTORE_PARTITION_NAME_WHITELIST_PATTERN("hive.metastore.partition.name.whitelist.pattern", ""),
        METASTORE_INTEGER_JDO_PUSHDOWN("hive.metastore.integral.jdo.pushdown", false),
        METASTORE_TRY_DIRECT_SQL("hive.metastore.try.direct.sql", true),
        METASTORE_TRY_DIRECT_SQL_DDL("hive.metastore.try.direct.sql.ddl", true),
        METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES("hive.metastore.disallow.incompatible.col.type.changes", false),
        NEWTABLEDEFAULTPARA("hive.table.parameters.default", ""),
        DDL_CTL_PARAMETERS_WHITELIST("hive.ddl.createtablelike.properties.whitelist", ""),
        METASTORE_RAW_STORE_IMPL("hive.metastore.rawstore.impl", "org.apache.hadoop.hive.metastore.ObjectStore"),
        METASTORE_CONNECTION_DRIVER("javax.jdo.option.ConnectionDriverName", "org.apache.derby.jdbc.EmbeddedDriver"),
        METASTORE_MANAGER_FACTORY_CLASS("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.api.jdo.JDOPersistenceManagerFactory"),
        METASTORE_EXPRESSION_PROXY_CLASS("hive.metastore.expression.proxy", "org.apache.hadoop.hive.ql.optimizer.ppr.PartitionExpressionForMetastore"),
        METASTORE_DETACH_ALL_ON_COMMIT("javax.jdo.option.DetachAllOnCommit", true),
        METASTORE_NON_TRANSACTIONAL_READ("javax.jdo.option.NonTransactionalRead", true),
        METASTORE_CONNECTION_USER_NAME("javax.jdo.option.ConnectionUserName", "APP"),
        METASTORE_END_FUNCTION_LISTENERS("hive.metastore.end.function.listeners", ""),
        METASTORE_PART_INHERIT_TBL_PROPS("hive.metastore.partition.inherit.table.properties", ""),
        METADATA_EXPORT_LOCATION("hive.metadata.export.location", ""),
        MOVE_EXPORTED_METADATA_TO_TRASH("hive.metadata.move.exported.metadata.to.trash", true),
        CLIIGNOREERRORS("hive.cli.errors.ignore", false),
        CLIPRINTCURRENTDB("hive.cli.print.current.db", false),
        CLIPROMPT("hive.cli.prompt", "hive"),
        CLIPRETTYOUTPUTNUMCOLS("hive.cli.pretty.output.num.cols", -1),
        HIVE_METASTORE_FS_HANDLER_CLS("hive.metastore.fs.handler.class", "org.apache.hadoop.hive.metastore.HiveMetaStoreFsImpl"),
        HIVESESSIONID("hive.session.id", ""),
        HIVESESSIONSILENT("hive.session.silent", false),
        HIVE_SESSION_HISTORY_ENABLED("hive.session.history.enabled", false),
        HIVEQUERYSTRING("hive.query.string", ""),
        HIVEQUERYID("hive.query.id", ""),
        HIVEPLANID("hive.query.planid", ""),
        HIVEJOBNAMELENGTH("hive.jobname.length", 50),
        HIVEJAR("hive.jar.path", ""),
        HIVEAUXJARS("hive.aux.jars.path", ""),
        HIVEADDEDFILES("hive.added.files.path", ""),
        HIVEADDEDJARS("hive.added.jars.path", ""),
        HIVEADDEDARCHIVES("hive.added.archives.path", ""),
        HIVE_CURRENT_DATABASE("hive.current.database", ""),
        HIVES_AUTO_PROGRESS_TIMEOUT("hive.auto.progress.timeout", 0),
        HIVETABLENAME("hive.table.name", ""),
        HIVEPARTITIONNAME("hive.partition.name", ""),
        HIVESCRIPTAUTOPROGRESS("hive.script.auto.progress", false),
        HIVESCRIPTIDENVVAR("hive.script.operator.id.env.var", "HIVE_SCRIPT_OPERATOR_ID"),
        HIVESCRIPTTRUNCATEENV("hive.script.operator.truncate.env", false),
        HIVEMAPREDMODE("hive.mapred.mode", "nonstrict"),
        HIVEALIAS("hive.alias", ""),
        HIVEMAPSIDEAGGREGATE("hive.map.aggr", true),
        HIVEGROUPBYSKEW("hive.groupby.skewindata", false),
        HIVE_OPTIMIZE_MULTI_GROUPBY_COMMON_DISTINCTS("hive.optimize.multigroupby.common.distincts", true),
        HIVEJOINEMITINTERVAL("hive.join.emit.interval", 1000),
        HIVEJOINCACHESIZE("hive.join.cache.size", 25000),
        HIVEMAPJOINBUCKETCACHESIZE("hive.mapjoin.bucket.cache.size", 100),
        HIVEMAPJOINUSEOPTIMIZEDKEYS("hive.mapjoin.optimized.keys", true),
        HIVEMAPJOINLAZYHASHTABLE("hive.mapjoin.lazy.hashtable", true),
        HIVESMBJOINCACHEROWS("hive.smbjoin.cache.rows", 10000),
        HIVEGROUPBYMAPINTERVAL("hive.groupby.mapaggr.checkinterval", 100000),
        HIVEMAPAGGRHASHMEMORY("hive.map.aggr.hash.percentmemory", 0.5f),
        HIVEMAPJOINFOLLOWEDBYMAPAGGRHASHMEMORY("hive.mapjoin.followby.map.aggr.hash.percentmemory", 0.3f),
        HIVEMAPAGGRMEMORYTHRESHOLD("hive.map.aggr.hash.force.flush.memory.threshold", 0.9f),
        HIVEMAPAGGRHASHMINREDUCTION("hive.map.aggr.hash.min.reduction", 0.5f),
        HIVEMULTIGROUPBYSINGLEREDUCER("hive.multigroupby.singlereducer", true),
        HIVE_MAP_GROUPBY_SORT("hive.map.groupby.sorted", false),
        HIVE_MAP_GROUPBY_SORT_TESTMODE("hive.map.groupby.sorted.testmode", false),
        HIVE_GROUPBY_ORDERBY_POSITION_ALIAS("hive.groupby.orderby.position.alias", false),
        HIVE_NEW_JOB_GROUPING_SET_CARDINALITY("hive.new.job.grouping.set.cardinality", 30),
        HIVEUDTFAUTOPROGRESS("hive.udtf.auto.progress", false),
        HIVEDEFAULTFILEFORMAT("hive.default.fileformat", "TextFile", (Validator)new StringsValidator(new String[]{"TextFile", "SequenceFile", "RCfile", "ORC"})),
        HIVEQUERYRESULTFILEFORMAT("hive.query.result.fileformat", "TextFile", (Validator)new StringsValidator(new String[]{"TextFile", "SequenceFile", "RCfile"})),
        HIVECHECKFILEFORMAT("hive.fileformat.check", true),
        HIVEDEFAULTRCFILESERDE("hive.default.rcfile.serde", "org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe"),
        SERDESUSINGMETASTOREFORSCHEMA("hive.serdes.using.metastore.for.schema", "org.apache.hadoop.hive.ql.io.orc.OrcSerde,org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe,org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe,org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe,org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe,org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe,org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe,org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe"),
        HIVEHISTORYFILELOC("hive.querylog.location", System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name")),
        HIVE_LOG_INCREMENTAL_PLAN_PROGRESS("hive.querylog.enable.plan.progress", true),
        HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL("hive.querylog.plan.progress.interval", 60000L),
        HIVESCRIPTSERDE("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"),
        HIVESCRIPTRECORDREADER("hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader"),
        HIVESCRIPTRECORDWRITER("hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter"),
        HIVESCRIPTESCAPE("hive.transform.escape.input", false),
        HIVEBINARYRECORDMAX("hive.binary.record.max.length", 1000),
        HIVEHWILISTENHOST("hive.hwi.listen.host", "0.0.0.0"),
        HIVEHWILISTENPORT("hive.hwi.listen.port", "9999"),
        HIVEHWIWARFILE("hive.hwi.war.file", System.getenv("HWI_WAR_FILE")),
        HIVEHADOOPMAXMEM("hive.mapred.local.mem", 0),
        HIVESMALLTABLESFILESIZE("hive.mapjoin.smalltable.filesize", 25000000L),
        HIVESAMPLERANDOMNUM("hive.sample.seednumber", 0),
        HIVETESTMODE("hive.test.mode", false),
        HIVETESTMODEPREFIX("hive.test.mode.prefix", "test_"),
        HIVETESTMODESAMPLEFREQ("hive.test.mode.samplefreq", 32),
        HIVETESTMODENOSAMPLE("hive.test.mode.nosamplelist", ""),
        HIVEMERGEMAPFILES("hive.merge.mapfiles", true),
        HIVEMERGEMAPREDFILES("hive.merge.mapredfiles", false),
        HIVEMERGETEZFILES("hive.merge.tezfiles", false),
        HIVEMERGEMAPFILESSIZE("hive.merge.size.per.task", 256000000L),
        HIVEMERGEMAPFILESAVGSIZE("hive.merge.smallfiles.avgsize", 16000000L),
        HIVEMERGERCFILEBLOCKLEVEL("hive.merge.rcfile.block.level", true),
        HIVEMERGEINPUTFORMATBLOCKLEVEL("hive.merge.input.format.block.level", "org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat"),
        HIVEMERGECURRENTJOBHASDYNAMICPARTITIONS("hive.merge.current.job.has.dynamic.partitions", false),
        HIVEUSEEXPLICITRCFILEHEADER("hive.exec.rcfile.use.explicit.header", true),
        HIVEUSERCFILESYNCCACHE("hive.exec.rcfile.use.sync.cache", true),
        HIVE_ORC_FILE_MEMORY_POOL("hive.exec.orc.memory.pool", 0.5f),
        HIVE_ORC_WRITE_FORMAT("hive.exec.orc.write.format", null),
        HIVE_ORC_DEFAULT_STRIPE_SIZE("hive.exec.orc.default.stripe.size", 0x10000000L),
        HIVE_ORC_DICTIONARY_KEY_SIZE_THRESHOLD("hive.exec.orc.dictionary.key.size.threshold", 0.8f),
        HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE("hive.exec.orc.default.row.index.stride", 10000),
        HIVE_ORC_DEFAULT_BUFFER_SIZE("hive.exec.orc.default.buffer.size", 262144),
        HIVE_ORC_DEFAULT_BLOCK_PADDING("hive.exec.orc.default.block.padding", true),
        HIVE_ORC_DEFAULT_COMPRESS("hive.exec.orc.default.compress", "ZLIB"),
        HIVE_ORC_INCLUDE_FILE_FOOTER_IN_SPLITS("hive.orc.splits.include.file.footer", false),
        HIVE_ORC_CACHE_STRIPE_DETAILS_SIZE("hive.orc.cache.stripe.details.size", 10000),
        HIVE_ORC_COMPUTE_SPLITS_NUM_THREADS("hive.orc.compute.splits.num.threads", 10),
        HIVE_ORC_SKIP_CORRUPT_DATA("hive.exec.orc.skip.corrupt.data", false),
        HIVE_ORC_ZEROCOPY("hive.exec.orc.zerocopy", false),
        HIVESKEWJOIN("hive.optimize.skewjoin", false),
        HIVECONVERTJOIN("hive.auto.convert.join", true),
        HIVECONVERTJOINNOCONDITIONALTASK("hive.auto.convert.join.noconditionaltask", true),
        HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD("hive.auto.convert.join.noconditionaltask.size", 10000000L),
        HIVECONVERTJOINUSENONSTAGED("hive.auto.convert.join.use.nonstaged", false),
        HIVESKEWJOINKEY("hive.skewjoin.key", 100000),
        HIVESKEWJOINMAPJOINNUMMAPTASK("hive.skewjoin.mapjoin.map.tasks", 10000),
        HIVESKEWJOINMAPJOINMINSPLIT("hive.skewjoin.mapjoin.min.split", 0x2000000L),
        HIVESENDHEARTBEAT("hive.heartbeat.interval", 1000),
        HIVELIMITMAXROWSIZE("hive.limit.row.max.size", 100000L),
        HIVELIMITOPTLIMITFILE("hive.limit.optimize.limit.file", 10),
        HIVELIMITOPTENABLE("hive.limit.optimize.enable", false),
        HIVELIMITOPTMAXFETCH("hive.limit.optimize.fetch.max", 50000),
        HIVELIMITPUSHDOWNMEMORYUSAGE("hive.limit.pushdown.memory.usage", -1.0f),
        HIVELIMITTABLESCANPARTITION("hive.limit.query.max.table.partition", -1),
        HIVEHASHTABLETHRESHOLD("hive.hashtable.initialCapacity", 100000),
        HIVEHASHTABLELOADFACTOR("hive.hashtable.loadfactor", 0.75f),
        HIVEHASHTABLEFOLLOWBYGBYMAXMEMORYUSAGE("hive.mapjoin.followby.gby.localtask.max.memory.usage", 0.55f),
        HIVEHASHTABLEMAXMEMORYUSAGE("hive.mapjoin.localtask.max.memory.usage", 0.9f),
        HIVEHASHTABLESCALE("hive.mapjoin.check.memory.rows", 100000L),
        HIVEDEBUGLOCALTASK("hive.debug.localtask", false),
        HIVEINPUTFORMAT("hive.input.format", "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat"),
        HIVETEZINPUTFORMAT("hive.tez.input.format", "org.apache.hadoop.hive.ql.io.HiveInputFormat"),
        HIVETEZCONTAINERSIZE("hive.tez.container.size", -1),
        HIVETEZJAVAOPTS("hive.tez.java.opts", null),
        HIVETEZLOGLEVEL("hive.tez.log.level", "INFO"),
        HIVEENFORCEBUCKETING("hive.enforce.bucketing", false),
        HIVEENFORCESORTING("hive.enforce.sorting", false),
        HIVEOPTIMIZEBUCKETINGSORTING("hive.optimize.bucketingsorting", true),
        HIVEPARTITIONER("hive.mapred.partitioner", "org.apache.hadoop.hive.ql.io.DefaultHivePartitioner"),
        HIVEENFORCESORTMERGEBUCKETMAPJOIN("hive.enforce.sortmergebucketmapjoin", false),
        HIVEENFORCEBUCKETMAPJOIN("hive.enforce.bucketmapjoin", false),
        HIVE_AUTO_SORTMERGE_JOIN("hive.auto.convert.sortmerge.join", false),
        HIVE_AUTO_SORTMERGE_JOIN_BIGTABLE_SELECTOR("hive.auto.convert.sortmerge.join.bigtable.selection.policy", "org.apache.hadoop.hive.ql.optimizer.AvgPartitionSizeBasedBigTableSelectorForAutoSMJ"),
        HIVE_AUTO_SORTMERGE_JOIN_TOMAPJOIN("hive.auto.convert.sortmerge.join.to.mapjoin", false),
        HIVESCRIPTOPERATORTRUST("hive.exec.script.trust", false),
        HIVEROWOFFSET("hive.exec.rowoffset", false),
        HIVE_COMBINE_INPUT_FORMAT_SUPPORTS_SPLITTABLE("hive.hadoop.supports.splittable.combineinputformat", false),
        HIVEOPTINDEXFILTER("hive.optimize.index.filter", false),
        HIVEINDEXAUTOUPDATE("hive.optimize.index.autoupdate", false),
        HIVEOPTPPD("hive.optimize.ppd", true),
        HIVEPPDRECOGNIZETRANSITIVITY("hive.ppd.recognizetransivity", true),
        HIVEPPDREMOVEDUPLICATEFILTERS("hive.ppd.remove.duplicatefilters", true),
        HIVEMETADATAONLYQUERIES("hive.optimize.metadataonly", true),
        HIVEOPTPPD_STORAGE("hive.optimize.ppd.storage", true),
        HIVEOPTGROUPBY("hive.optimize.groupby", true),
        HIVEOPTBUCKETMAPJOIN("hive.optimize.bucketmapjoin", false),
        HIVEOPTSORTMERGEBUCKETMAPJOIN("hive.optimize.bucketmapjoin.sortedmerge", false),
        HIVEOPTREDUCEDEDUPLICATION("hive.optimize.reducededuplication", true),
        HIVEOPTREDUCEDEDUPLICATIONMINREDUCER("hive.optimize.reducededuplication.min.reducer", 4),
        HIVEOPTSORTDYNAMICPARTITION("hive.optimize.sort.dynamic.partition", true),
        HIVESAMPLINGFORORDERBY("hive.optimize.sampling.orderby", false),
        HIVESAMPLINGNUMBERFORORDERBY("hive.optimize.sampling.orderby.number", 1000),
        HIVESAMPLINGPERCENTFORORDERBY("hive.optimize.sampling.orderby.percent", 0.1f),
        HIVE_OPTIMIZE_UNION_REMOVE("hive.optimize.union.remove", false),
        HIVEOPTCORRELATION("hive.optimize.correlation", false),
        HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES("hive.mapred.supports.subdirectories", false),
        HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME("hive.optimize.skewjoin.compiletime", false),
        HIVEOPTINDEXFILTER_COMPACT_MINSIZE("hive.optimize.index.filter.compact.minsize", 0x140000000L),
        HIVEOPTINDEXFILTER_COMPACT_MAXSIZE("hive.optimize.index.filter.compact.maxsize", -1L),
        HIVE_INDEX_COMPACT_QUERY_MAX_ENTRIES("hive.index.compact.query.max.entries", 10000000L),
        HIVE_INDEX_COMPACT_QUERY_MAX_SIZE("hive.index.compact.query.max.size", 0x280000000L),
        HIVE_INDEX_COMPACT_BINARY_SEARCH("hive.index.compact.binary.search", true),
        HIVESTATSAUTOGATHER("hive.stats.autogather", true),
        HIVESTATSDBCLASS("hive.stats.dbclass", "fs", (Validator)new PatternValidator(new String[]{"jdbc(:.*)", "hbase", "counter", "custom", "fs"})),
        HIVESTATSJDBCDRIVER("hive.stats.jdbcdriver", "org.apache.derby.jdbc.EmbeddedDriver"),
        HIVESTATSDBCONNECTIONSTRING("hive.stats.dbconnectionstring", "jdbc:derby:;databaseName=TempStatsStore;create=true"),
        HIVE_STATS_DEFAULT_PUBLISHER("hive.stats.default.publisher", ""),
        HIVE_STATS_DEFAULT_AGGREGATOR("hive.stats.default.aggregator", ""),
        HIVE_STATS_JDBC_TIMEOUT("hive.stats.jdbc.timeout", 30),
        HIVE_STATS_ATOMIC("hive.stats.atomic", false),
        HIVE_STATS_RETRIES_MAX("hive.stats.retries.max", 0),
        HIVE_STATS_RETRIES_WAIT("hive.stats.retries.wait", 3000),
        HIVE_STATS_COLLECT_RAWDATASIZE("hive.stats.collect.rawdatasize", true),
        CLIENT_STATS_COUNTERS("hive.client.stats.counters", ""),
        HIVE_STATS_RELIABLE("hive.stats.reliable", false),
        HIVE_STATS_GATHER_NUM_THREADS("hive.stats.gather.num.threads", 10),
        HIVE_STATS_COLLECT_TABLEKEYS("hive.stats.collect.tablekeys", false),
        HIVE_STATS_COLLECT_SCANCOLS("hive.stats.collect.scancols", false),
        HIVE_STATS_NDV_ERROR("hive.stats.ndv.error", 20.0f),
        HIVE_STATS_KEY_PREFIX_MAX_LENGTH("hive.stats.key.prefix.max.length", 150),
        HIVE_STATS_KEY_PREFIX_RESERVE_LENGTH("hive.stats.key.prefix.reserve.length", 24),
        HIVE_STATS_KEY_PREFIX("hive.stats.key.prefix", ""),
        HIVE_STATS_MAX_VARIABLE_LENGTH("hive.stats.max.variable.length", 100),
        HIVE_STATS_LIST_NUM_ENTRIES("hive.stats.list.num.entries", 10),
        HIVE_STATS_MAP_NUM_ENTRIES("hive.stats.map.num.entries", 10),
        HIVE_STATS_MAP_SIDE_PARALLELISM("hive.stats.map.parallelism", 1),
        HIVE_STATS_FETCH_PARTITION_STATS("hive.stats.fetch.partition.stats", true),
        HIVE_STATS_FETCH_COLUMN_STATS("hive.stats.fetch.column.stats", false),
        HIVE_STATS_JOIN_FACTOR("hive.stats.join.factor", 1.1f),
        HIVE_STATS_DESERIALIZATION_FACTOR("hive.stats.deserialization.factor", 1.0f),
        HIVE_SUPPORT_CONCURRENCY("hive.support.concurrency", false),
        HIVE_LOCK_MANAGER("hive.lock.manager", "org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLockManager"),
        HIVE_LOCK_NUMRETRIES("hive.lock.numretries", 100),
        HIVE_UNLOCK_NUMRETRIES("hive.unlock.numretries", 10),
        HIVE_LOCK_SLEEP_BETWEEN_RETRIES("hive.lock.sleep.between.retries", 60),
        HIVE_LOCK_MAPRED_ONLY("hive.lock.mapred.only.operation", false),
        HIVE_ZOOKEEPER_QUORUM("hive.zookeeper.quorum", ""),
        HIVE_ZOOKEEPER_CLIENT_PORT("hive.zookeeper.client.port", "2181"),
        HIVE_ZOOKEEPER_SESSION_TIMEOUT("hive.zookeeper.session.timeout", 600000),
        HIVE_ZOOKEEPER_NAMESPACE("hive.zookeeper.namespace", "hive_zookeeper_namespace"),
        HIVE_ZOOKEEPER_CLEAN_EXTRA_NODES("hive.zookeeper.clean.extra.nodes", false),
        HIVE_TXN_MANAGER("hive.txn.manager", "org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager"),
        HIVE_TXN_TIMEOUT("hive.txn.timeout", 300),
        HIVE_TXN_MAX_OPEN_BATCH("hive.txn.max.open.batch", 1000),
        HIVE_COMPACTOR_INITIATOR_ON("hive.compactor.initiator.on", false),
        HIVE_COMPACTOR_WORKER_THREADS("hive.compactor.worker.threads", 0),
        HIVE_COMPACTOR_WORKER_TIMEOUT("hive.compactor.worker.timeout", 86400L),
        HIVE_COMPACTOR_CHECK_INTERVAL("hive.compactor.check.interval", 300L),
        HIVE_COMPACTOR_DELTA_NUM_THRESHOLD("hive.compactor.delta.num.threshold", 10),
        HIVE_COMPACTOR_DELTA_PCT_THRESHOLD("hive.compactor.delta.pct.threshold", 0.1f),
        HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD("hive.compactor.abortedtxn.threshold", 1000),
        HIVE_HBASE_WAL_ENABLED("hive.hbase.wal.enabled", true),
        HIVEARCHIVEENABLED("hive.archive.enabled", false),
        HIVEOPTGBYUSINGINDEX("hive.optimize.index.groupby", false),
        HIVEOUTERJOINSUPPORTSFILTERS("hive.outerjoin.supports.filters", true),
        HIVEFETCHTASKCONVERSION("hive.fetch.task.conversion", "minimal", (Validator)new StringsValidator(new String[]{"minimal", "more"})),
        HIVEFETCHTASKCONVERSIONTHRESHOLD("hive.fetch.task.conversion.threshold", -1L),
        HIVEFETCHTASKAGGR("hive.fetch.task.aggr", false),
        HIVEOPTIMIZEMETADATAQUERIES("hive.compute.query.using.stats", false),
        HIVEFETCHOUTPUTSERDE("hive.fetch.output.serde", "org.apache.hadoop.hive.serde2.DelimitedJSONSerDe"),
        HIVEEXPREVALUATIONCACHE("hive.cache.expr.evaluation", true),
        HIVEVARIABLESUBSTITUTE("hive.variable.substitute", true),
        HIVEVARIABLESUBSTITUTEDEPTH("hive.variable.substitute.depth", 40),
        HIVECONFVALIDATION("hive.conf.validation", true),
        SEMANTIC_ANALYZER_HOOK("hive.semantic.analyzer.hook", ""),
        HIVE_EXEC_FILTER_HOOK("hive.exec.filter.hook", ""),
        HIVE_AUTHORIZATION_ENABLED("hive.security.authorization.enabled", false),
        HIVE_AUTHORIZATION_TASK_FACTORY("hive.security.authorization.task.factory", "org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactoryImpl"),
        HIVE_AUTHORIZATION_MANAGER("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider"),
        HIVE_AUTHENTICATOR_MANAGER("hive.security.authenticator.manager", "org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator"),
        HIVE_METASTORE_AUTHORIZATION_MANAGER("hive.security.metastore.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.DefaultHiveMetastoreAuthorizationProvider"),
        HIVE_METASTORE_AUTHENTICATOR_MANAGER("hive.security.metastore.authenticator.manager", "org.apache.hadoop.hive.ql.security.HadoopDefaultMetastoreAuthenticator"),
        HIVE_AUTHORIZATION_TABLE_USER_GRANTS("hive.security.authorization.createtable.user.grants", ""),
        HIVE_AUTHORIZATION_TABLE_GROUP_GRANTS("hive.security.authorization.createtable.group.grants", ""),
        HIVE_AUTHORIZATION_TABLE_ROLE_GRANTS("hive.security.authorization.createtable.role.grants", ""),
        HIVE_AUTHORIZATION_TABLE_OWNER_GRANTS("hive.security.authorization.createtable.owner.grants", ""),
        HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST("hive.security.authorization.sqlstd.confwhitelist", ""),
        HIVE_CLI_PRINT_HEADER("hive.cli.print.header", false),
        HIVE_ERROR_ON_EMPTY_PARTITION("hive.error.on.empty.partition", false),
        HIVE_INDEX_IGNORE_HDFS_LOC("hive.index.compact.file.ignore.hdfs", false),
        HIVE_EXIM_URI_SCHEME_WL("hive.exim.uri.scheme.whitelist", "hdfs,pfile,maprfs"),
        HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS("hive.mapper.cannot.span.multiple.partitions", false),
        HIVE_REWORK_MAPREDWORK("hive.rework.mapredwork", false),
        HIVE_CONCATENATE_CHECK_INDEX("hive.exec.concatenate.check.index", true),
        HIVE_IO_EXCEPTION_HANDLERS("hive.io.exception.handlers", ""),
        HIVE_LOG4J_FILE("hive.log4j.file", ""),
        HIVE_EXEC_LOG4J_FILE("hive.exec.log4j.file", ""),
        HIVE_AUTOGEN_COLUMNALIAS_PREFIX_LABEL("hive.autogen.columnalias.prefix.label", "_c"),
        HIVE_AUTOGEN_COLUMNALIAS_PREFIX_INCLUDEFUNCNAME("hive.autogen.columnalias.prefix.includefuncname", false),
        HIVE_PERF_LOGGER("hive.exec.perf.logger", "org.apache.hadoop.hive.ql.log.PerfLogger"),
        HIVE_START_CLEANUP_SCRATCHDIR("hive.start.cleanup.scratchdir", false),
        HIVE_INSERT_INTO_MULTILEVEL_DIRS("hive.insert.into.multilevel.dirs", false),
        HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS("hive.warehouse.subdir.inherit.perms", false),
        HIVE_INSERT_INTO_EXTERNAL_TABLES("hive.insert.into.external.tables", true),
        HIVE_OPTIMIZE_INSERT_DEST_VOLUME("hive.optimize.insert.dest.volume", false),
        HIVE_SCRATCH_DIR_IN_DEST("hive.scratchdir.in.dest", "_scratchdir"),
        HIVE_DRIVER_RUN_HOOKS("hive.exec.driver.run.hooks", ""),
        HIVE_DDL_OUTPUT_FORMAT("hive.ddl.output.format", null),
        HIVE_ENTITY_SEPARATOR("hive.entity.separator", "@"),
        HIVE_EXTENDED_ENITITY_CAPTURE("hive.entity.capture.input.URI", false),
        HIVE_DISPLAY_PARTITION_COLUMNS_SEPARATELY("hive.display.partition.cols.separately", true),
        HIVE_SERVER2_MAX_START_ATTEMPTS("hive.server2.max.start.attempts", 30L, (Validator)new LongRangeValidator(0L, Long.MAX_VALUE)),
        HIVE_SERVER2_TRANSPORT_MODE("hive.server2.transport.mode", "binary", (Validator)new StringsValidator(new String[]{"binary", "http"})),
        HIVE_SERVER2_THRIFT_HTTP_PORT("hive.server2.thrift.http.port", 10001),
        HIVE_SERVER2_THRIFT_HTTP_PATH("hive.server2.thrift.http.path", "cliservice"),
        HIVE_SERVER2_THRIFT_HTTP_MIN_WORKER_THREADS("hive.server2.thrift.http.min.worker.threads", 5),
        HIVE_SERVER2_THRIFT_HTTP_MAX_WORKER_THREADS("hive.server2.thrift.http.max.worker.threads", 500),
        HIVE_SERVER2_THRIFT_PORT("hive.server2.thrift.port", 10000),
        HIVE_SERVER2_THRIFT_BIND_HOST("hive.server2.thrift.bind.host", ""),
        HIVE_SERVER2_THRIFT_SASL_QOP("hive.server2.thrift.sasl.qop", "auth-conf", (Validator)new StringsValidator(new String[]{"auth", "auth-int", "auth-conf"})),
        HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS("hive.server2.thrift.min.worker.threads", 5),
        HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS("hive.server2.thrift.max.worker.threads", 500),
        HIVE_SERVER2_ASYNC_EXEC_THREADS("hive.server2.async.exec.threads", 100),
        HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT("hive.server2.async.exec.shutdown.timeout", 10),
        HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE("hive.server2.async.exec.wait.queue.size", 100),
        HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME("hive.server2.async.exec.keepalive.time", 10),
        HIVE_SERVER2_LONG_POLLING_TIMEOUT("hive.server2.long.polling.timeout", 5000L),
        HIVE_SERVER2_AUTHENTICATION("hive.server2.authentication", System.getProperty("hiveserver2.auth") == null ? "NONE" : System.getProperty("hiveserver2.auth"), (Validator)new StringsValidator(new String[]{"NOSASL", "NONE", "LDAP", "KERBEROS", "PAM", "CUSTOM"})),
        HIVE_SERVER2_ALLOW_USER_SUBSTITUTION("hive.server2.allow.user.substitution", true),
        HIVE_SERVER2_KERBEROS_KEYTAB("hive.server2.authentication.kerberos.keytab", ""),
        HIVE_SERVER2_KERBEROS_PRINCIPAL("hive.server2.authentication.kerberos.principal", ""),
        HIVE_SERVER2_SPNEGO_KEYTAB("hive.server2.authentication.spnego.keytab", ""),
        HIVE_SERVER2_SPNEGO_PRINCIPAL("hive.server2.authentication.spnego.principal", ""),
        HIVE_SERVER2_PLAIN_LDAP_URL("hive.server2.authentication.ldap.url", null),
        HIVE_SERVER2_PLAIN_LDAP_BASEDN("hive.server2.authentication.ldap.baseDN", null),
        HIVE_SERVER2_PLAIN_LDAP_DOMAIN("hive.server2.authentication.ldap.Domain", null),
        HIVE_SERVER2_CUSTOM_AUTHENTICATION_CLASS("hive.server2.custom.authentication.class", null),
        HIVE_SERVER2_PAM_SERVICES("hive.server2.authentication.pam.services", System.getProperty("hiveserver2.authentication.pam.services")),
        HIVE_SERVER2_ENABLE_DOAS("hive.server2.enable.doAs", true),
        HIVE_SERVER2_TABLE_TYPE_MAPPING("hive.server2.table.type.mapping", "CLASSIC", (Validator)new StringsValidator(new String[]{"CLASSIC", "HIVE"})),
        HIVE_SERVER2_SESSION_HOOK("hive.server2.session.hook", ""),
        HIVE_SERVER2_IN_MEM_LOGGING("hive.server2.in.mem.logging", true),
        HIVE_SERVER2_IN_MEM_LOG_SIZE("hive.server2.in.mem.log.size", 131072),
        HIVE_SERVER2_USE_SSL("hive.server2.use.SSL", false),
        HIVE_SERVER2_SSL_KEYSTORE_PATH("hive.server2.keystore.path", ""),
        HIVE_SERVER2_SSL_KEYSTORE_PASSWORD("hive.server2.keystore.password", ""),
        HIVE_SECURITY_COMMAND_WHITELIST("hive.security.command.whitelist", "set,reset,dfs,add,delete,compile"),
        HIVE_CONF_RESTRICTED_LIST("hive.conf.restricted.list", "hive.security.authenticator.manager,hive.security.authorization.manager"),
        HIVE_MULTI_INSERT_MOVE_TASKS_SHARE_DEPENDENCIES("hive.multi.insert.move.tasks.share.dependencies", false),
        HIVE_INFER_BUCKET_SORT("hive.exec.infer.bucket.sort", false),
        HIVE_INFER_BUCKET_SORT_NUM_BUCKETS_POWER_TWO("hive.exec.infer.bucket.sort.num.buckets.power.two", false),
        HIVEMERGECURRENTJOBCONCATENATELISTBUCKETING("hive.merge.current.job.concatenate.list.bucketing", true),
        HIVEMERGECURRENTJOBCONCATENATELISTBUCKETINGDEPTH("hive.merge.current.job.concatenate.list.bucketing.depth", 0),
        HIVEOPTLISTBUCKETING("hive.optimize.listbucketing", false),
        SERVER_READ_SOCKET_TIMEOUT("hive.server.read.socket.timeout", 10),
        SERVER_TCP_KEEP_ALIVE("hive.server.tcp.keepalive", true),
        HIVE_DECODE_PARTITION_NAME("hive.decode.partition.name", false),
        HIVE_EXECUTION_ENGINE("hive.execution.engine", "mr", (Validator)new StringsValidator(new String[]{"mr", "tez"})),
        HIVE_JAR_DIRECTORY("hive.jar.directory", null),
        HIVE_USER_INSTALL_DIR("hive.user.install.directory", "hdfs:///user/"),
        HIVE_VECTORIZATION_ENABLED("hive.vectorized.execution.enabled", false),
        HIVE_VECTORIZATION_GROUPBY_CHECKINTERVAL("hive.vectorized.groupby.checkinterval", 100000),
        HIVE_VECTORIZATION_GROUPBY_MAXENTRIES("hive.vectorized.groupby.maxentries", 1000000),
        HIVE_VECTORIZATION_GROUPBY_FLUSH_PERCENT("hive.vectorized.groupby.flush.percent", 0.1f),
        HIVE_TYPE_CHECK_ON_INSERT("hive.typecheck.on.insert", true),
        HIVE_RPC_QUERY_PLAN("hive.rpc.query.plan", false),
        HIVE_AM_SPLIT_GENERATION("hive.compute.splits.in.am", true),
        HIVE_PREWARM_ENABLED("hive.prewarm.enabled", false),
        HIVE_PREWARM_NUM_CONTAINERS("hive.prewarm.numcontainers", 10),
        HIVESTAGEIDREARRANGE("hive.stageid.rearrange", "none"),
        HIVEEXPLAINDEPENDENCYAPPENDTASKTYPES("hive.explain.dependency.append.tasktype", false),
        HIVECOUNTERGROUP("hive.counters.group.name", "HIVE"),
        HIVE_SERVER2_TEZ_DEFAULT_QUEUES("hive.server2.tez.default.queues", ""),
        HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE("hive.server2.tez.sessions.per.default.queue", 1),
        HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS("hive.server2.tez.initialize.default.sessions", false),
        HIVE_QUOTEDID_SUPPORT("hive.support.quoted.identifiers", "column", (Validator)new PatternValidator(new String[]{"none", "column"})),
        USERS_IN_ADMIN_ROLE("hive.users.in.admin.role", ""),
        HIVE_COMPAT("hive.compat", HiveCompat.DEFAULT_COMPAT_LEVEL),
        HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ("hive.convert.join.bucket.mapjoin.tez", false),
        HIVE_CHECK_CROSS_PRODUCT("hive.exec.check.crossproducts", true),
        HIVE_LOCALIZE_RESOURCE_WAIT_INTERVAL("hive.localize.resource.wait.interval", 5000L),
        HIVE_LOCALIZE_RESOURCE_NUM_WAIT_ATTEMPTS("hive.localize.resource.num.wait.attempts", 5);

        public final String varname;
        public final String defaultVal;
        public final int defaultIntVal;
        public final long defaultLongVal;
        public final float defaultFloatVal;
        public final Class<?> valClass;
        public final boolean defaultBoolVal;
        private final VarType type;
        private final Validator validator;

        private ConfVars(String varname, String defaultVal) {
            this(varname, defaultVal, null);
        }

        private ConfVars(String varname, String defaultVal, Validator validator) {
            this.varname = varname;
            this.valClass = String.class;
            this.defaultVal = defaultVal;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
            this.type = VarType.STRING;
            this.validator = validator;
        }

        private ConfVars(String varname, int defaultVal) {
            this(varname, defaultVal, (Validator)null);
        }

        private ConfVars(String varname, int defaultIntVal, Validator validator) {
            this.varname = varname;
            this.valClass = Integer.class;
            this.defaultVal = Integer.toString(defaultIntVal);
            this.defaultIntVal = defaultIntVal;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
            this.type = VarType.INT;
            this.validator = validator;
        }

        private ConfVars(String varname, long defaultVal) {
            this(varname, defaultVal, (Validator)null);
        }

        private ConfVars(String varname, long defaultLongVal, Validator validator) {
            this.varname = varname;
            this.valClass = Long.class;
            this.defaultVal = Long.toString(defaultLongVal);
            this.defaultIntVal = -1;
            this.defaultLongVal = defaultLongVal;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
            this.type = VarType.LONG;
            this.validator = validator;
        }

        private ConfVars(String varname, float defaultVal) {
            this(varname, defaultVal, null);
        }

        private ConfVars(String varname, float defaultFloatVal, Validator validator) {
            this.varname = varname;
            this.valClass = Float.class;
            this.defaultVal = Float.toString(defaultFloatVal);
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = defaultFloatVal;
            this.defaultBoolVal = false;
            this.type = VarType.FLOAT;
            this.validator = validator;
        }

        private ConfVars(String varname, boolean defaultBoolVal) {
            this.varname = varname;
            this.valClass = Boolean.class;
            this.defaultVal = Boolean.toString(defaultBoolVal);
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = defaultBoolVal;
            this.type = VarType.BOOLEAN;
            this.validator = null;
        }

        public boolean isType(String value) {
            return this.type.isType(value);
        }

        public String validate(String value) {
            return this.validator == null ? null : this.validator.validate(value);
        }

        public String typeString() {
            return this.type.typeString();
        }

        public String toString() {
            return this.varname;
        }

        private static String findHadoopBinary() {
            String val = System.getenv("HADOOP_HOME");
            if (val == null) {
                val = System.getenv("HADOOP_PREFIX");
            }
            val = (val == null ? File.separator + "usr" : val) + File.separator + "bin" + File.separator + "hadoop";
            return val + (Shell.WINDOWS ? ".cmd" : "");
        }

        static enum VarType {
            STRING{

                @Override
                void checkType(String value) throws Exception {
                }
            }
            ,
            INT{

                @Override
                void checkType(String value) throws Exception {
                    Integer.valueOf(value);
                }
            }
            ,
            LONG{

                @Override
                void checkType(String value) throws Exception {
                    Long.valueOf(value);
                }
            }
            ,
            FLOAT{

                @Override
                void checkType(String value) throws Exception {
                    Float.valueOf(value);
                }
            }
            ,
            BOOLEAN{

                @Override
                void checkType(String value) throws Exception {
                    Boolean.valueOf(value);
                }
            };


            boolean isType(String value) {
                try {
                    this.checkType(value);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }

            String typeString() {
                return this.name().toUpperCase();
            }

            abstract void checkType(String var1) throws Exception;
        }
    }
}

