/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.cli.beeline;

import org.apache.hive.cli.beeline.BeeLine;
import org.apache.hive.cli.beeline.ColorBuffer;
import org.apache.hive.cli.beeline.OutputFormat;
import org.apache.hive.cli.beeline.Rows;

class TableOutputFormat
implements OutputFormat {
    private final BeeLine beeLine;
    private final StringBuilder sb = new StringBuilder();

    TableOutputFormat(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    @Override
    public int print(Rows rows) {
        int index = 0;
        ColorBuffer header = null;
        ColorBuffer headerCols = null;
        int width = this.beeLine.getOpts().getMaxWidth() - 4;
        rows.normalizeWidths();
        while (rows.hasNext()) {
            Rows.Row row = (Rows.Row)rows.next();
            ColorBuffer cbuf = this.getOutputString(rows, row);
            cbuf = cbuf.truncate(width);
            if (index == 0) {
                this.sb.setLength(0);
                for (int j = 0; j < row.sizes.length; ++j) {
                    for (int k = 0; k < row.sizes[j]; ++k) {
                        this.sb.append('-');
                    }
                    this.sb.append("-+-");
                }
                headerCols = cbuf;
                header = this.beeLine.getColorBuffer().green(this.sb.toString()).truncate(headerCols.getVisibleLength());
            }
            if (index == 0 || this.beeLine.getOpts().getHeaderInterval() > 0 && index % this.beeLine.getOpts().getHeaderInterval() == 0 && this.beeLine.getOpts().getShowHeader()) {
                this.printRow(header, true);
                this.printRow(headerCols, false);
                this.printRow(header, true);
            }
            if (index != 0) {
                this.printRow(cbuf, false);
            }
            ++index;
        }
        if (header != null && this.beeLine.getOpts().getShowHeader()) {
            this.printRow(header, true);
        }
        return index - 1;
    }

    void printRow(ColorBuffer cbuff, boolean header) {
        if (header) {
            this.beeLine.output(this.beeLine.getColorBuffer().green("+-").append(cbuff).green("-+"));
        } else {
            this.beeLine.output(this.beeLine.getColorBuffer().green("| ").append(cbuff).green(" |"));
        }
    }

    public ColorBuffer getOutputString(Rows rows, Rows.Row row) {
        return this.getOutputString(rows, row, " | ");
    }

    ColorBuffer getOutputString(Rows rows, Rows.Row row, String delim) {
        ColorBuffer buf = this.beeLine.getColorBuffer();
        for (int i = 0; i < row.values.length; ++i) {
            ColorBuffer v;
            if (buf.getVisibleLength() > 0) {
                buf.green(delim);
            }
            if (row.isMeta) {
                v = this.beeLine.getColorBuffer().center(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    buf.cyan(v.getMono());
                    continue;
                }
                buf.bold(v.getMono());
                continue;
            }
            v = this.beeLine.getColorBuffer().pad(row.values[i], row.sizes[i]);
            if (rows.isPrimaryKey(i)) {
                buf.cyan(v.getMono());
                continue;
            }
            buf.append(v.getMono());
        }
        if (row.deleted) {
            buf = this.beeLine.getColorBuffer().red(buf.getMono());
        } else if (row.updated) {
            buf = this.beeLine.getColorBuffer().blue(buf.getMono());
        } else if (row.inserted) {
            buf = this.beeLine.getColorBuffer().green(buf.getMono());
        }
        return buf;
    }
}

