/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.cli.beeline;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.hive.cli.beeline.BeeLine;

class Reflector {
    private final BeeLine beeLine;

    public Reflector(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    public Object invoke(Object on, String method, Object[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return this.invoke(on, method, Arrays.asList(args));
    }

    public Object invoke(Object on, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        return this.invoke(on, on == null ? null : on.getClass(), method, args);
    }

    public Object invoke(Object on, Class defClass, String method, List args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = defClass != null ? defClass : on.getClass();
        LinkedList<Method> candidateMethods = new LinkedList<Method>();
        Method[] m = c.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equalsIgnoreCase(method)) continue;
            candidateMethods.add(m[i]);
        }
        if (candidateMethods.size() == 0) {
            throw new IllegalArgumentException(this.beeLine.loc("no-method", new Object[]{method, c.getName()}));
        }
        for (Method meth : candidateMethods) {
            Object[] converted;
            Class[] ptypes = meth.getParameterTypes();
            if (ptypes.length != args.size() || (converted = Reflector.convert(args, ptypes)) == null || !Modifier.isPublic(meth.getModifiers())) continue;
            return meth.invoke(on, converted);
        }
        return null;
    }

    public static Object[] convert(List objects, Class[] toTypes) throws ClassNotFoundException {
        Object[] converted = new Object[objects.size()];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = Reflector.convert(objects.get(i), toTypes[i]);
        }
        return converted;
    }

    public static Object convert(Object ob, Class toType) throws ClassNotFoundException {
        if (ob == null || ob.toString().equals("null")) {
            return null;
        }
        if (toType == String.class) {
            return new String(ob.toString());
        }
        if (toType == Byte.class || toType == Byte.TYPE) {
            return new Byte(ob.toString());
        }
        if (toType == Character.class || toType == Character.TYPE) {
            return new Character(ob.toString().charAt(0));
        }
        if (toType == Short.class || toType == Short.TYPE) {
            return new Short(ob.toString());
        }
        if (toType == Integer.class || toType == Integer.TYPE) {
            return new Integer(ob.toString());
        }
        if (toType == Long.class || toType == Long.TYPE) {
            return new Long(ob.toString());
        }
        if (toType == Double.class || toType == Double.TYPE) {
            return new Double(ob.toString());
        }
        if (toType == Float.class || toType == Float.TYPE) {
            return new Float(ob.toString());
        }
        if (toType == Boolean.class || toType == Boolean.TYPE) {
            return new Boolean(ob.toString().equals("true") || ob.toString().equals("true") || ob.toString().equals("1") || ob.toString().equals("on") || ob.toString().equals("yes"));
        }
        if (toType == Class.class) {
            return Class.forName(ob.toString());
        }
        return null;
    }
}

