/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.cli.beeline;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import org.apache.hive.cli.beeline.BeeLine;

abstract class Rows
implements Iterator {
    private final BeeLine beeLine;
    final ResultSetMetaData rsMeta;
    final Boolean[] primaryKeys;
    final NumberFormat numberFormat;

    Rows(BeeLine beeLine, ResultSet rs) throws SQLException {
        this.beeLine = beeLine;
        this.rsMeta = rs.getMetaData();
        int count = this.rsMeta.getColumnCount();
        this.primaryKeys = new Boolean[count];
        this.numberFormat = beeLine.getOpts().getNumberFormat().equals("default") ? null : new DecimalFormat(beeLine.getOpts().getNumberFormat());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract void normalizeWidths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isPrimaryKey(int col) {
        if (this.primaryKeys[col] != null) {
            return this.primaryKeys[col];
        }
        try {
            String table = this.rsMeta.getTableName(col + 1);
            String column = this.rsMeta.getColumnName(col + 1);
            if (table == null || table.length() == 0 || column == null || column.length() == 0) {
                this.primaryKeys[col] = new Boolean(false);
                return this.primaryKeys[col];
            }
            ResultSet pks = this.beeLine.getDatabaseConnection().getDatabaseMetaData().getPrimaryKeys(this.beeLine.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, table);
            try {
                while (pks.next()) {
                    if (!column.equalsIgnoreCase(pks.getString("COLUMN_NAME"))) continue;
                    this.primaryKeys[col] = new Boolean(true);
                    boolean bl = this.primaryKeys[col];
                    return bl;
                }
            }
            finally {
                pks.close();
            }
            this.primaryKeys[col] = new Boolean(false);
            return this.primaryKeys[col];
        }
        catch (SQLException sqle) {
            this.primaryKeys[col] = new Boolean(false);
            return this.primaryKeys[col];
        }
    }

    class Row {
        final String[] values;
        final boolean isMeta;
        boolean deleted;
        boolean inserted;
        boolean updated;
        int[] sizes;

        Row(int size) throws SQLException {
            this.isMeta = true;
            this.values = new String[size];
            this.sizes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = Rows.this.rsMeta.getColumnLabel(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
            this.deleted = false;
            this.updated = false;
            this.inserted = false;
        }

        Row(int size, ResultSet rs) throws SQLException {
            this.isMeta = false;
            this.values = new String[size];
            this.sizes = new int[size];
            try {
                this.deleted = rs.rowDeleted();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.updated = rs.rowUpdated();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.inserted = rs.rowInserted();
            }
            catch (Throwable t) {
                // empty catch block
            }
            for (int i = 0; i < size; ++i) {
                Object o;
                this.values[i] = Rows.this.numberFormat != null ? ((o = rs.getObject(i + 1)) == null ? null : (o instanceof Number ? Rows.this.numberFormat.format(o) : o.toString())) : rs.getString(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
        }
    }
}

