/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.cli.beeline;

import java.util.Arrays;
import java.util.LinkedList;
import jline.Completor;
import jline.NullCompletor;
import org.apache.hive.cli.beeline.BeeLine;
import org.apache.hive.cli.beeline.CommandHandler;

public abstract class AbstractCommandHandler
implements CommandHandler {
    private final BeeLine beeLine;
    private final String name;
    private final String[] names;
    private final String helpText;
    private Completor[] parameterCompletors = new Completor[0];

    public AbstractCommandHandler(BeeLine beeLine, String[] names, String helpText, Completor[] completors) {
        this.beeLine = beeLine;
        this.name = names[0];
        this.names = names;
        this.helpText = helpText;
        if (completors == null || completors.length == 0) {
            this.parameterCompletors = new Completor[]{new NullCompletor()};
        } else {
            LinkedList<Completor> c = new LinkedList<Completor>(Arrays.asList(completors));
            c.add((Completor)new NullCompletor());
            this.parameterCompletors = c.toArray(new Completor[0]);
        }
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public String matches(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        String[] parts = this.beeLine.split(line);
        if (parts == null || parts.length == 0) {
            return null;
        }
        for (String name2 : this.names) {
            if (!name2.startsWith(parts[0])) continue;
            return name2;
        }
        return null;
    }

    public void setParameterCompletors(Completor[] parameterCompletors) {
        this.parameterCompletors = parameterCompletors;
    }

    @Override
    public Completor[] getParameterCompletors() {
        return this.parameterCompletors;
    }
}

