/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.jdbc.HiveConnection;

public class ProxyAuthTest {
    private static final String driverName = "org.apache.hive.jdbc.HiveDriver";
    private static final String BEELINE_EXIT = "beeline.system.exit";
    private static Connection con = null;
    private static boolean noClose = false;
    private static String tabName = "jdbc_test";
    private static String tabDataFileName;
    private static String scriptFileName;
    private static String[] dmlStmts;
    private static String[] dfsStmts;
    private static String[] selectStmts;
    private static String[] cleanUpStmts;
    private static InputStream inpStream;
    private static int tabCount;
    private static File resultFile;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage ProxyAuthTest <host> <port> <server_principal> <proxy_user> [testTab]");
            System.exit(1);
        }
        File currentResultFile = null;
        String[] beeLineArgs = new String[]{};
        Class.forName(driverName);
        String host = args[0];
        String port = args[1];
        String serverPrincipal = args[2];
        String proxyUser = args[3];
        String url = null;
        if (args.length > 4) {
            tabName = args[4];
        }
        ProxyAuthTest.generateData();
        ProxyAuthTest.generateSQL(null);
        try {
            url = "jdbc:hive2://" + host + ":" + port + "/default;principal=" + serverPrincipal;
            con = DriverManager.getConnection(url);
            System.out.println("Connected successfully to " + url);
            String token = ((HiveConnection)con).getDelegationToken(proxyUser, serverPrincipal);
            if ("true".equals(System.getProperty("proxyAuth.debug", "false"))) {
                System.out.println("Got token: " + token);
            }
            con.close();
            System.setProperty(BEELINE_EXIT, "true");
            url = "jdbc:hive2://" + host + ":" + port + "/default;principal=" + serverPrincipal;
            currentResultFile = ProxyAuthTest.generateSQL(null);
            beeLineArgs = new String[]{"-u", url, "-n", "foo", "-p", "bar"};
            System.out.println("Connection with kerberos, user/password via args, using input rediction");
            BeeLine.mainWithInputRedirection((String[])beeLineArgs, (InputStream)inpStream);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default;principal=" + serverPrincipal;
            currentResultFile = ProxyAuthTest.generateSQL(null);
            beeLineArgs = new String[]{"-u", url, "-n", "foo", "-p", "bar", "-f", scriptFileName};
            System.out.println("Connection with kerberos, user/password via args, using input script");
            BeeLine.main((String[])beeLineArgs);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default;principal=" + serverPrincipal;
            currentResultFile = ProxyAuthTest.generateSQL(url + " foo bar ");
            beeLineArgs = new String[]{"-u", url, "-f", scriptFileName};
            System.out.println("Connection with kerberos, user/password via connect, using input script");
            BeeLine.main((String[])beeLineArgs);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default;principal=" + serverPrincipal;
            currentResultFile = ProxyAuthTest.generateSQL(url + " foo bar ");
            beeLineArgs = new String[]{"-u", url, "-f", scriptFileName};
            System.out.println("Connection with kerberos, user/password via connect, using input redirect");
            BeeLine.mainWithInputRedirection((String[])beeLineArgs, (InputStream)inpStream);
            ProxyAuthTest.compareResults(currentResultFile);
            System.out.println("Store token into ugi and try");
            ProxyAuthTest.storeTokenInJobConf(token);
            url = "jdbc:hive2://" + host + ":" + port + "/default;auth=delegationToken";
            con = DriverManager.getConnection(url);
            System.out.println("Connecting to " + url);
            ProxyAuthTest.runTest();
            con.close();
            url = "jdbc:hive2://" + host + ":" + port + "/default";
            currentResultFile = ProxyAuthTest.generateSQL(null);
            beeLineArgs = new String[]{"-u", url, "-n", "foo", "-p", "bar", "-a", "delegationToken"};
            System.out.println("Connection with token, user/password via args, using input redirection");
            BeeLine.mainWithInputRedirection((String[])beeLineArgs, (InputStream)inpStream);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default";
            currentResultFile = ProxyAuthTest.generateSQL(null);
            beeLineArgs = new String[]{"-u", url, "-n", "foo", "-p", "bar", "-a", "delegationToken", "-f", scriptFileName};
            System.out.println("Connection with token, user/password via args, using input script");
            BeeLine.main((String[])beeLineArgs);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default";
            currentResultFile = ProxyAuthTest.generateSQL(url + " foo bar ");
            beeLineArgs = new String[]{"-a", "delegationToken", "-f", scriptFileName};
            System.out.println("Connection with token, user/password via connect, using input script");
            BeeLine.main((String[])beeLineArgs);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default";
            currentResultFile = ProxyAuthTest.generateSQL(url + " foo bar ");
            System.out.println("Connection with token, user/password via connect, using input script");
            beeLineArgs = new String[]{"-f", scriptFileName, "-a", "delegationToken"};
            BeeLine.main((String[])beeLineArgs);
            ProxyAuthTest.compareResults(currentResultFile);
            url = "jdbc:hive2://" + host + ":" + port + "/default;principal=" + serverPrincipal + ";hive.server2.proxy.user=" + proxyUser;
            con = DriverManager.getConnection(url);
            System.out.println("Connected successfully to " + url);
            ProxyAuthTest.runTest();
            ((HiveConnection)con).cancelDelegationToken(token);
            con.close();
        }
        catch (SQLException e) {
            System.out.println("*** SQLException: " + e.getMessage() + " : " + e.getSQLState());
            e.printStackTrace();
        }
        try {
            url = "jdbc:hive2://" + host + ":" + port + "/default;auth=delegationToken";
            con = DriverManager.getConnection(url);
            throw new Exception("connection should have failed after token cancelation");
        }
        catch (SQLException e) {
            return;
        }
    }

    private static void storeTokenInJobConf(String tokenStr) throws Exception {
        Utils.setTokenStr((UserGroupInformation)Utils.getUGI(), (String)tokenStr, (String)"hiveserver2ClientToken");
        System.out.println("Stored token " + tokenStr);
    }

    private static void runTest() throws Exception {
        ProxyAuthTest.runDMLs();
        for (String stmt : dfsStmts) {
            ProxyAuthTest.runQuery(stmt);
        }
        for (String stmt : selectStmts) {
            ProxyAuthTest.runQuery(stmt);
        }
        ProxyAuthTest.cleanUp();
    }

    private static void runDMLs() throws Exception {
        for (String stmt : dmlStmts) {
            ProxyAuthTest.exStatement(stmt);
        }
    }

    private static void cleanUp() throws Exception {
        for (String stmt : cleanUpStmts) {
            ProxyAuthTest.exStatement(stmt);
        }
    }

    private static void runQuery(String sqlStmt) throws Exception {
        int i;
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sqlStmt);
        ResultSetMetaData meta = res.getMetaData();
        System.out.println("Resultset has " + meta.getColumnCount() + " columns");
        for (i = 1; i <= meta.getColumnCount(); ++i) {
            System.out.println("Column #" + i + " Name: " + meta.getColumnName(i) + " Type: " + meta.getColumnType(i));
        }
        while (res.next()) {
            for (i = 1; i <= meta.getColumnCount(); ++i) {
                System.out.println("Column #" + i + ": " + res.getString(i));
            }
        }
        res.close();
        stmt.close();
    }

    private static void exStatement(String query) throws Exception {
        Statement stmt = con.createStatement();
        stmt.execute(query);
        if (!noClose) {
            stmt.close();
        }
    }

    private static File generateSQL(String url) throws Exception {
        String current = new File(".").getCanonicalPath();
        String currentDir = System.getProperty("user.dir");
        String queryTab = tabName + "_" + tabCount++;
        dmlStmts = new String[]{"USE default", "drop table if exists  " + queryTab, "create table " + queryTab + "(id int, name string) " + "ROW FORMAT DELIMITED FIELDS TERMINATED BY '|'", "load data local inpath '" + tabDataFileName + "' into table " + queryTab};
        selectStmts = new String[]{"select * from " + queryTab + " limit 5", "select name, id from " + queryTab + " where id < 3"};
        dfsStmts = new String[0];
        cleanUpStmts = new String[]{"drop table if exists  " + queryTab};
        return ProxyAuthTest.writeArrayToByteStream(url);
    }

    private static void generateData() throws Exception {
        String[] fileData = new String[]{"1|aaa", "2|bbb", "3|ccc", "4|ddd", "5|eee"};
        File tmpFile = File.createTempFile(tabName, ".data");
        tmpFile.deleteOnExit();
        tabDataFileName = tmpFile.getPath();
        FileWriter fstream = new FileWriter(tabDataFileName);
        BufferedWriter out = new BufferedWriter(fstream);
        for (String line : fileData) {
            out.write(line);
            out.newLine();
        }
        out.close();
        tmpFile.setWritable(true, true);
    }

    private static File writeArrayToByteStream(String url) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (url != null) {
            ProxyAuthTest.writeCmdLine("!connect " + url, out);
        }
        ProxyAuthTest.writeCmdLine("!brief", out);
        ProxyAuthTest.writeCmdLine("!set silent true", out);
        resultFile = File.createTempFile(tabName, ".out");
        if (!"true".equals(System.getProperty("proxyAuth.debug", "false"))) {
            resultFile.deleteOnExit();
        }
        ProxyAuthTest.writeCmdLine("!record " + resultFile.getPath(), out);
        for (String stmt : dmlStmts) {
            ProxyAuthTest.writeSqlLine(stmt, out);
        }
        for (String stmt : selectStmts) {
            ProxyAuthTest.writeSqlLine(stmt, out);
        }
        for (String stmt : cleanUpStmts) {
            ProxyAuthTest.writeSqlLine(stmt, out);
        }
        ProxyAuthTest.writeCmdLine("!record", out);
        ProxyAuthTest.writeCmdLine("!quit", out);
        File tmpFile = File.createTempFile(tabName, ".q");
        tmpFile.deleteOnExit();
        scriptFileName = tmpFile.getPath();
        FileOutputStream fstream = new FileOutputStream(scriptFileName);
        out.writeTo(fstream);
        inpStream = new ByteArrayInputStream(out.toByteArray());
        return resultFile;
    }

    private static void writeSqlLine(String stmt, OutputStream out) throws Exception {
        out.write(stmt.getBytes());
        out.write(";".getBytes());
        out.write(System.getProperty("line.separator").getBytes());
    }

    private static void writeCmdLine(String cmdLine, OutputStream out) throws Exception {
        out.write(cmdLine.getBytes());
        out.write(System.getProperty("line.separator").getBytes());
    }

    private static void compareResults(File file2) throws IOException {
        File baseResultFile = new File(System.getProperty("proxyAuth.res.file"), "data/files/ProxyAuth.res");
        if (!FileUtils.contentEquals((File)baseResultFile, (File)file2)) {
            throw new IOException("File compare failed: " + file2.getPath() + " differs");
        }
    }

    static {
        inpStream = null;
        tabCount = 1;
        resultFile = null;
    }
}

