/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBeelineArgParsing {
    private static final Log LOG = LogFactory.getLog((String)TestBeelineArgParsing.class.getName());
    private static final String dummyDriverClazzName = "DummyDriver";
    private String connectionString;
    private String driverClazzName;
    private String driverJarFileName;
    private boolean defaultSupported;

    public TestBeelineArgParsing(String connectionString, String driverClazzName, String driverJarFileName, boolean defaultSupported) {
        this.connectionString = connectionString;
        this.driverClazzName = driverClazzName;
        this.driverJarFileName = driverJarFileName;
        this.defaultSupported = defaultSupported;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException, InterruptedException {
        String u = HiveTestUtils.getFileFromClasspath((String)"DummyDriver.txt");
        File jarFile = HiveTestUtils.genLocalJarForTest((String)u, (String)dummyDriverClazzName);
        String pathToDummyDriver = jarFile.getAbsolutePath();
        return Arrays.asList({"jdbc:postgresql://host:5432/testdb", "org.postgresql.Driver", System.getProperty("maven.local.repository") + File.separator + "postgresql" + File.separator + "postgresql" + File.separator + "9.1-901.jdbc4" + File.separator + "postgresql-9.1-901.jdbc4.jar", true}, {"jdbc:dummy://host:5432/testdb", dummyDriverClazzName, pathToDummyDriver, false});
    }

    @Test
    public void testSimpleArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-a", "authType"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAuthType().equals("authType"));
    }

    @Test
    public void testPasswordFileArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        File passFile = new File("file.password");
        passFile.deleteOnExit();
        FileOutputStream passFileOut = new FileOutputStream(passFile);
        passFileOut.write("mypass\n".getBytes());
        passFileOut.close();
        String[] args = new String[]{"-u", "url", "-n", "name", "-w", "file.password", "-p", "not-taken-if-w-is-present", "-d", "driver", "-a", "authType"};
        bl.initArgs(args);
        System.out.println(bl.connectArgs);
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name mypass driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAuthType().equals("authType"));
        passFile.delete();
    }

    @Test
    public void testDuplicateArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-u", "url2", "-n", "name", "-p", "password", "-d", "driver"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
    }

    @Test
    public void testQueryScripts() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-e", "select1", "-e", "select2"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.queries.contains("select1"));
        Assert.assertTrue((boolean)bl.queries.contains("select2"));
    }

    @Test
    public void testHiveConfAndVars() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--hiveconf", "a=avalue", "--hiveconf", "b=bvalue", "--hivevar", "c=cvalue", "--hivevar", "d=dvalue"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveConfVariables().get("a")).equals("avalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveConfVariables().get("b")).equals("bvalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveVariables().get("c")).equals("cvalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveVariables().get("d")).equals("dvalue"));
    }

    @Test
    public void testBeelineOpts() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--autoCommit=true", "--verbose", "--truncateTable"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAutoCommit());
        Assert.assertTrue((boolean)bl.getOpts().getVerbose());
        Assert.assertTrue((boolean)bl.getOpts().getTruncateTable());
    }

    @Test
    public void testScriptFile() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-f", "myscript"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getScriptFile().equals("myscript"));
    }

    @Test
    public void testHelp() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"--help"};
        Assert.assertEquals((long)0L, (long)bl.initArgs(args));
    }

    @Test
    public void testUnmatchedArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n"};
        Assert.assertEquals((long)-1L, (long)bl.initArgs(args));
    }

    @Test
    public void testAddLocalJar() throws Exception {
        TestBeeline bl = new TestBeeline();
        Assert.assertNull((Object)bl.findLocalDriver(this.connectionString));
        LOG.info((Object)("Add " + this.driverJarFileName + " for the driver class " + this.driverClazzName));
        bl.addLocalJar(this.driverJarFileName);
        bl.addlocaldrivername(this.driverClazzName);
        Assert.assertEquals((Object)bl.findLocalDriver(this.connectionString).getClass().getName(), (Object)this.driverClazzName);
    }

    @Test
    public void testAddLocalJarWithoutAddDriverClazz() throws Exception {
        TestBeeline bl = new TestBeeline();
        LOG.info((Object)("Add " + this.driverJarFileName + " for the driver class " + this.driverClazzName));
        bl.addLocalJar(this.driverJarFileName);
        if (!this.defaultSupported) {
            Assert.assertNull((Object)bl.findLocalDriver(this.connectionString));
        } else {
            Assert.assertEquals((Object)bl.findLocalDriver(this.connectionString).getClass().getName(), (Object)this.driverClazzName);
        }
    }

    public class TestBeeline
    extends BeeLine {
        String connectArgs = null;
        List<String> properties = new ArrayList<String>();
        List<String> queries = new ArrayList<String>();

        boolean dispatch(String command) {
            String connectCommand = "!connect";
            String propertyCommand = "!property";
            if (command.startsWith(connectCommand)) {
                this.connectArgs = command.substring(connectCommand.length() + 1, command.length());
            } else if (command.startsWith(propertyCommand)) {
                this.properties.add(command.substring(propertyCommand.length() + 1, command.length()));
            } else {
                this.queries.add(command);
            }
            return true;
        }

        public boolean addlocaldrivername(String driverName) {
            String line = "addlocaldrivername " + driverName;
            return this.getCommands().addlocaldrivername(line);
        }

        public boolean addLocalJar(String url) {
            String line = "addlocaldriverjar " + url;
            return this.getCommands().addlocaldriverjar(line);
        }
    }
}

