/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hive.beeline.BeeLine;
import org.junit.Test;

public class TestBeelineArgParsing {
    @Test
    public void testSimpleArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-a", "authType"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAuthType().equals("authType"));
    }

    @Test
    public void testDuplicateArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-u", "url2", "-n", "name", "-p", "password", "-d", "driver"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
    }

    @Test
    public void testQueryScripts() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-e", "select1", "-e", "select2"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.queries.contains("select1"));
        Assert.assertTrue((boolean)bl.queries.contains("select2"));
    }

    @Test
    public void testHiveConfAndVars() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--hiveconf", "a=avalue", "--hiveconf", "b=bvalue", "--hivevar", "c=cvalue", "--hivevar", "d=dvalue"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveConfVariables().get("a")).equals("avalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveConfVariables().get("b")).equals("bvalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveVariables().get("c")).equals("cvalue"));
        Assert.assertTrue((boolean)((String)bl.getOpts().getHiveVariables().get("d")).equals("dvalue"));
    }

    @Test
    public void testBeelineOpts() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "--autoCommit=true", "--verbose", "--truncateTable"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getAutoCommit());
        Assert.assertTrue((boolean)bl.getOpts().getVerbose());
        Assert.assertTrue((boolean)bl.getOpts().getTruncateTable());
    }

    @Test
    public void testScriptFile() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n", "name", "-p", "password", "-d", "driver", "-f", "myscript"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
        Assert.assertTrue((boolean)bl.connectArgs.equals("url name password driver"));
        Assert.assertTrue((boolean)bl.getOpts().getScriptFile().equals("myscript"));
    }

    @Test
    public void testHelp() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"--help"};
        Assert.assertEquals((int)0, (int)bl.initArgs(args));
    }

    @Test
    public void testUnmatchedArgs() throws Exception {
        TestBeeline bl = new TestBeeline();
        String[] args = new String[]{"-u", "url", "-n"};
        Assert.assertEquals((int)-1, (int)bl.initArgs(args));
    }

    public class TestBeeline
    extends BeeLine {
        String connectArgs = null;
        List<String> properties = new ArrayList<String>();
        List<String> queries = new ArrayList<String>();

        boolean dispatch(String command) {
            String connectCommand = "!connect";
            String propertyCommand = "!property";
            if (command.startsWith(connectCommand)) {
                this.connectArgs = command.substring(connectCommand.length() + 1, command.length());
            } else if (command.startsWith(propertyCommand)) {
                this.properties.add(command.substring(propertyCommand.length() + 1, command.length()));
            } else {
                this.queries.add(command);
            }
            return true;
        }
    }
}

