/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jline.SimpleCompletor;
import org.apache.hive.beeline.BeeLine;

class SQLCompletor
extends SimpleCompletor {
    private final BeeLine beeLine;

    public SQLCompletor(BeeLine beeLine, boolean skipmeta) throws IOException, SQLException {
        super(new String[0]);
        this.beeLine = beeLine;
        TreeSet<String> completions = new TreeSet<String>();
        String keywords = new BufferedReader(new InputStreamReader(SQLCompletor.class.getResourceAsStream("sql-keywords.properties"))).readLine();
        try {
            keywords = keywords + "," + beeLine.getDatabaseConnection().getDatabaseMetaData().getSQLKeywords();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + beeLine.getDatabaseConnection().getDatabaseMetaData().getStringFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + beeLine.getDatabaseConnection().getDatabaseMetaData().getNumericFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + beeLine.getDatabaseConnection().getDatabaseMetaData().getSystemFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            keywords = keywords + "," + beeLine.getDatabaseConnection().getDatabaseMetaData().getTimeDateFunctions();
        }
        catch (Throwable t) {
            // empty catch block
        }
        keywords = keywords + "," + keywords.toLowerCase();
        StringTokenizer tok = new StringTokenizer(keywords, ", ");
        while (tok.hasMoreTokens()) {
            completions.add(tok.nextToken());
        }
        if (!skipmeta) {
            String[] columns = beeLine.getColumnNames(beeLine.getDatabaseConnection().getDatabaseMetaData());
            for (int i = 0; columns != null && i < columns.length; ++i) {
                completions.add(columns[i++]);
            }
        }
        this.setCandidateStrings(completions.toArray(new String[0]));
    }
}

