/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.ColorBuffer;
import org.apache.hive.beeline.DatabaseConnection;
import org.apache.hive.beeline.OutputFile;

public class Commands {
    private final BeeLine beeLine;

    Commands(BeeLine beeLine) {
        this.beeLine = beeLine;
    }

    public boolean metadata(String line) {
        this.beeLine.debug(line);
        String[] parts = this.beeLine.split(line);
        LinkedList<String> params = new LinkedList<String>(Arrays.asList(parts));
        if (parts == null || parts.length == 0) {
            return this.dbinfo("");
        }
        params.remove(0);
        params.remove(0);
        this.beeLine.debug(((Object)params).toString());
        return this.metadata(parts[1], params.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean metadata(String cmd, String[] args) {
        block10: {
            try {
                Method[] m = this.beeLine.getDatabaseConnection().getDatabaseMetaData().getClass().getMethods();
                TreeSet<String> methodNames = new TreeSet<String>();
                TreeSet<String> methodNamesUpper = new TreeSet<String>();
                for (int i = 0; i < m.length; ++i) {
                    methodNames.add(m[i].getName());
                    methodNamesUpper.add(m[i].getName().toUpperCase());
                }
                if (!methodNamesUpper.contains(cmd.toUpperCase())) {
                    this.beeLine.error(this.beeLine.loc("no-such-method", cmd));
                    this.beeLine.error(this.beeLine.loc("possible-methods"));
                    Iterator i = methodNames.iterator();
                    while (i.hasNext()) {
                        this.beeLine.error("   " + (String)i.next());
                    }
                    return false;
                }
                Object res = this.beeLine.getReflector().invoke(this.beeLine.getDatabaseConnection().getDatabaseMetaData(), DatabaseMetaData.class, cmd, Arrays.asList(args));
                if (res instanceof ResultSet) {
                    ResultSet rs = (ResultSet)res;
                    if (rs == null) break block10;
                    try {
                        this.beeLine.print(rs);
                        break block10;
                    }
                    finally {
                        rs.close();
                    }
                }
                if (res != null) {
                    this.beeLine.output(res.toString());
                }
            }
            catch (Exception e) {
                return this.beeLine.error(e);
            }
        }
        return true;
    }

    public boolean history(String line) {
        List hist = this.beeLine.getConsoleReader().getHistory().getHistoryList();
        int index = 1;
        Iterator i = hist.iterator();
        while (i.hasNext()) {
            this.beeLine.output(this.beeLine.getColorBuffer().pad(index + ".", 6).append(i.next().toString()));
            ++index;
        }
        return true;
    }

    String arg1(String line, String paramname) {
        return this.arg1(line, paramname, null);
    }

    String arg1(String line, String paramname, String def) {
        String[] ret = this.beeLine.split(line);
        if (ret == null || ret.length != 2) {
            if (def != null) {
                return def;
            }
            throw new IllegalArgumentException(this.beeLine.loc("arg-usage", new Object[]{ret.length == 0 ? "" : ret[0], paramname}));
        }
        return ret[1];
    }

    public boolean indexes(String line) throws Exception {
        return this.metadata("getIndexInfo", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name"), "false", "true"});
    }

    public boolean primarykeys(String line) throws Exception {
        return this.metadata("getPrimaryKeys", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name")});
    }

    public boolean exportedkeys(String line) throws Exception {
        return this.metadata("getExportedKeys", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name")});
    }

    public boolean importedkeys(String line) throws Exception {
        return this.metadata("getImportedKeys", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name")});
    }

    public boolean procedures(String line) throws Exception {
        return this.metadata("getProcedures", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "procedure name pattern", "%")});
    }

    public boolean tables(String line) throws Exception {
        return this.metadata("getTables", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name", "%"), null});
    }

    public boolean typeinfo(String line) throws Exception {
        return this.metadata("getTypeInfo", new String[0]);
    }

    public boolean nativesql(String sql) throws Exception {
        if (sql.startsWith("!")) {
            sql = sql.substring(1);
        }
        if (sql.startsWith("native")) {
            sql = sql.substring("native".length() + 1);
        }
        String nat = this.beeLine.getDatabaseConnection().getConnection().nativeSQL(sql);
        this.beeLine.output(nat);
        return true;
    }

    public boolean columns(String line) throws Exception {
        return this.metadata("getColumns", new String[]{this.beeLine.getConnection().getCatalog(), null, this.arg1(line, "table name"), "%"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropall(String line) {
        if (this.beeLine.getDatabaseConnection() == null || this.beeLine.getDatabaseConnection().getUrl() == null) {
            return this.beeLine.error(this.beeLine.loc("no-current-connection"));
        }
        try {
            if (!this.beeLine.getConsoleReader().readLine(this.beeLine.loc("really-drop-all")).equals("y")) {
                return this.beeLine.error("abort-drop-all");
            }
            LinkedList<String> cmds = new LinkedList<String>();
            ResultSet rs = this.beeLine.getTables();
            try {
                while (rs.next()) {
                    cmds.add("DROP TABLE " + rs.getString("TABLE_NAME") + ";");
                }
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            return this.beeLine.runCommands(cmds) == cmds.size();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean reconnect(String line) {
        if (this.beeLine.getDatabaseConnection() == null || this.beeLine.getDatabaseConnection().getUrl() == null) {
            return this.beeLine.error(this.beeLine.loc("no-current-connection"));
        }
        this.beeLine.info(this.beeLine.loc("reconnecting", this.beeLine.getDatabaseConnection().getUrl()));
        try {
            this.beeLine.getDatabaseConnection().reconnect();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        return true;
    }

    public boolean scan(String line) throws IOException {
        TreeSet<String> names = new TreeSet<String>();
        if (this.beeLine.getDrivers() == null) {
            this.beeLine.setDrivers(Arrays.asList(this.beeLine.scanDrivers(line)));
        }
        this.beeLine.info(this.beeLine.loc("drivers-found-count", this.beeLine.getDrivers().size()));
        Iterator<Driver> i = this.beeLine.getDrivers().iterator();
        while (i.hasNext()) {
            names.add(i.next().getClass().getName());
        }
        this.beeLine.output(this.beeLine.getColorBuffer().bold(this.beeLine.getColorBuffer().pad(this.beeLine.loc("compliant"), 10).getMono()).bold(this.beeLine.getColorBuffer().pad(this.beeLine.loc("jdbc-version"), 8).getMono()).bold(this.beeLine.getColorBuffer(this.beeLine.loc("driver-class")).getMono()));
        i = names.iterator();
        while (i.hasNext()) {
            String name = ((String)((Object)i.next())).toString();
            try {
                Driver driver = (Driver)Class.forName(name).newInstance();
                ColorBuffer msg = this.beeLine.getColorBuffer().pad(driver.jdbcCompliant() ? "yes" : "no", 10).pad(driver.getMajorVersion() + "." + driver.getMinorVersion(), 8).append(name);
                if (driver.jdbcCompliant()) {
                    this.beeLine.output(msg);
                    continue;
                }
                this.beeLine.output(this.beeLine.getColorBuffer().red(msg.getMono()));
            }
            catch (Throwable t) {
                this.beeLine.output(this.beeLine.getColorBuffer().red(name));
            }
        }
        return true;
    }

    public boolean save(String line) throws IOException {
        this.beeLine.info(this.beeLine.loc("saving-options", this.beeLine.getOpts().getPropertiesFile()));
        this.beeLine.getOpts().save();
        return true;
    }

    public boolean load(String line) throws IOException {
        this.beeLine.getOpts().load();
        this.beeLine.info(this.beeLine.loc("loaded-options", this.beeLine.getOpts().getPropertiesFile()));
        return true;
    }

    public boolean config(String line) {
        try {
            Properties props = this.beeLine.getOpts().toProperties();
            TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
            for (String string : keys) {
                ColorBuffer colorBuffer = this.beeLine.getColorBuffer();
                ColorBuffer colorBuffer2 = this.beeLine.getColorBuffer();
                this.beeLine.getOpts();
                this.beeLine.output(colorBuffer.green(colorBuffer2.pad(string.substring("beeline.".length()), 20).getMono()).append(props.getProperty(string)));
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        return true;
    }

    public boolean set(String line) {
        if (line == null || line.trim().equals("set") || line.length() == 0) {
            return this.config(null);
        }
        String[] parts = this.beeLine.split(line, 3, "Usage: set <key> <value>");
        if (parts == null) {
            return false;
        }
        String key = parts[1];
        String value = parts[2];
        boolean success = this.beeLine.getOpts().set(key, value, false);
        if (success && this.beeLine.getOpts().getAutosave()) {
            try {
                this.beeLine.getOpts().save();
            }
            catch (Exception saveException) {
                // empty catch block
            }
        }
        return success;
    }

    public boolean commit(String line) throws SQLException {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (!this.beeLine.assertAutoCommit()) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            this.beeLine.getDatabaseConnection().getConnection().commit();
            long end = System.currentTimeMillis();
            this.beeLine.showWarnings();
            this.beeLine.info(this.beeLine.loc("commit-complete") + " " + this.beeLine.locElapsedTime(end - start));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean rollback(String line) throws SQLException {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (!this.beeLine.assertAutoCommit()) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            this.beeLine.getDatabaseConnection().getConnection().rollback();
            long end = System.currentTimeMillis();
            this.beeLine.showWarnings();
            this.beeLine.info(this.beeLine.loc("rollback-complete") + " " + this.beeLine.locElapsedTime(end - start));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean autocommit(String line) throws SQLException {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (line.endsWith("on")) {
            this.beeLine.getDatabaseConnection().getConnection().setAutoCommit(true);
        } else if (line.endsWith("off")) {
            this.beeLine.getDatabaseConnection().getConnection().setAutoCommit(false);
        }
        this.beeLine.showWarnings();
        this.beeLine.autocommitStatus(this.beeLine.getDatabaseConnection().getConnection());
        return true;
    }

    public boolean dbinfo(String line) {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        this.beeLine.showWarnings();
        int padlen = 50;
        String[] m = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "getCatalogSeparator", "getCatalogTerm", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
        for (int i = 0; i < m.length; ++i) {
            try {
                this.beeLine.output(this.beeLine.getColorBuffer().pad(m[i], padlen).append("" + this.beeLine.getReflector().invoke((Object)this.beeLine.getDatabaseConnection().getDatabaseMetaData(), m[i], new Object[0])));
                continue;
            }
            catch (Exception e) {
                this.beeLine.handleException(e);
            }
        }
        return true;
    }

    public boolean verbose(String line) {
        this.beeLine.info("verbose: on");
        return this.set("set verbose true");
    }

    public boolean outputformat(String line) {
        return this.set("set " + line);
    }

    public boolean brief(String line) {
        this.beeLine.info("verbose: off");
        return this.set("set verbose false");
    }

    public boolean isolation(String line) throws SQLException {
        String isoldesc;
        int i;
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (line.endsWith("TRANSACTION_NONE")) {
            i = 0;
        } else if (line.endsWith("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        } else if (line.endsWith("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        } else if (line.endsWith("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        } else if (line.endsWith("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        } else {
            return this.beeLine.error("Usage: isolation <TRANSACTION_NONE | TRANSACTION_READ_COMMITTED | TRANSACTION_READ_UNCOMMITTED | TRANSACTION_REPEATABLE_READ | TRANSACTION_SERIALIZABLE>");
        }
        this.beeLine.getDatabaseConnection().getConnection().setTransactionIsolation(i);
        int isol = this.beeLine.getDatabaseConnection().getConnection().getTransactionIsolation();
        switch (i) {
            case 0: {
                isoldesc = "TRANSACTION_NONE";
                break;
            }
            case 2: {
                isoldesc = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 1: {
                isoldesc = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 4: {
                isoldesc = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                isoldesc = "TRANSACTION_SERIALIZABLE";
                break;
            }
            default: {
                isoldesc = "UNKNOWN";
            }
        }
        this.beeLine.info(this.beeLine.loc("isolation-status", isoldesc));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batch(String line) {
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        if (this.beeLine.getBatch() == null) {
            this.beeLine.setBatch(new LinkedList<String>());
            this.beeLine.info(this.beeLine.loc("batch-start"));
            return true;
        }
        this.beeLine.info(this.beeLine.loc("running-batch"));
        try {
            this.beeLine.runBatch(this.beeLine.getBatch());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = this.beeLine.error(e);
            return bl;
        }
        finally {
            this.beeLine.setBatch(null);
        }
    }

    public boolean sql(String line) {
        return this.execute(line, false);
    }

    public boolean call(String line) {
        return this.execute(line, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(String line, boolean call) {
        String prefix;
        if (line == null || line.length() == 0) {
            return false;
        }
        try {
            while (!line.trim().endsWith(";")) {
                StringBuilder prompt = new StringBuilder(this.beeLine.getPrompt());
                for (int i = 0; i < prompt.length() - 1; ++i) {
                    if (prompt.charAt(i) == '>') continue;
                    prompt.setCharAt(i, i % 2 == 0 ? (char)'.' : ' ');
                }
                String extra = this.beeLine.getConsoleReader().readLine(prompt.toString());
                if (this.beeLine.isComment(extra)) continue;
                line = line + " " + extra;
            }
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        if (line.endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        if (!this.beeLine.assertConnection()) {
            return false;
        }
        String sql = line;
        if (sql.startsWith("!")) {
            sql = sql.substring(1);
        }
        String string = prefix = call ? "call" : "sql";
        if (sql.startsWith(prefix)) {
            sql = sql.substring(prefix.length());
        }
        if (this.beeLine.getBatch() != null) {
            this.beeLine.getBatch().add(sql);
            return true;
        }
        try {
            Statement stmnt = null;
            try {
                boolean hasResults;
                long start = System.currentTimeMillis();
                if (call) {
                    stmnt = this.beeLine.getDatabaseConnection().getConnection().prepareCall(sql);
                    hasResults = ((CallableStatement)stmnt).execute();
                } else {
                    stmnt = this.beeLine.createStatement();
                    hasResults = stmnt.execute(sql);
                }
                this.beeLine.showWarnings();
                if (hasResults) {
                    do {
                        ResultSet rs = stmnt.getResultSet();
                        try {
                            int count = this.beeLine.print(rs);
                            long end = System.currentTimeMillis();
                            this.beeLine.info(this.beeLine.loc("rows-selected", count) + " " + this.beeLine.locElapsedTime(end - start));
                        }
                        finally {
                            rs.close();
                        }
                    } while (BeeLine.getMoreResults(stmnt));
                } else {
                    int count = stmnt.getUpdateCount();
                    long end = System.currentTimeMillis();
                    this.beeLine.info(this.beeLine.loc("rows-affected", count) + " " + this.beeLine.locElapsedTime(end - start));
                }
            }
            catch (Exception e) {
                this.beeLine.error(e);
                throw e;
            }
            finally {
                if (stmnt != null) {
                    stmnt.close();
                }
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        this.beeLine.showWarnings();
        return true;
    }

    public boolean quit(String line) {
        this.beeLine.setExit(true);
        this.close(null);
        return true;
    }

    public boolean closeall(String line) {
        if (this.close(null)) {
            while (this.close(null)) {
            }
            return true;
        }
        return false;
    }

    public boolean close(String line) {
        if (this.beeLine.getDatabaseConnection() == null) {
            return false;
        }
        try {
            if (this.beeLine.getDatabaseConnection().getConnection() != null && !this.beeLine.getDatabaseConnection().getConnection().isClosed()) {
                this.beeLine.info(this.beeLine.loc("closing", this.beeLine.getDatabaseConnection().getConnection().getClass().getName()));
                this.beeLine.getDatabaseConnection().getConnection().close();
            } else {
                this.beeLine.info(this.beeLine.loc("already-closed"));
            }
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        this.beeLine.getDatabaseConnections().remove();
        return true;
    }

    public boolean properties(String line) throws Exception {
        String example = "";
        example = example + "Usage: properties <properties file>" + BeeLine.getSeparator();
        String[] parts = this.beeLine.split(line);
        if (parts.length < 2) {
            return this.beeLine.error(example);
        }
        int successes = 0;
        for (int i = 1; i < parts.length; ++i) {
            Properties props = new Properties();
            props.load(new FileInputStream(parts[i]));
            if (!this.connect(props)) continue;
            ++successes;
        }
        return successes == parts.length - 1;
    }

    public boolean connect(String line) throws Exception {
        String example = "Usage: connect <url> <username> <password> [driver]" + BeeLine.getSeparator();
        String[] parts = this.beeLine.split(line);
        if (parts == null) {
            return false;
        }
        if (parts.length < 2) {
            return this.beeLine.error(example);
        }
        String url = parts.length < 2 ? null : parts[1];
        String user = parts.length < 3 ? null : parts[2];
        String pass = parts.length < 4 ? null : parts[3];
        String driver = parts.length < 5 ? null : parts[4];
        Properties props = new Properties();
        if (url != null) {
            props.setProperty("url", url);
        }
        if (driver != null) {
            props.setProperty("driver", driver);
        }
        if (user != null) {
            props.setProperty("user", user);
        }
        if (pass != null) {
            props.setProperty("password", pass);
        }
        return this.connect(props);
    }

    private String getProperty(Properties props, String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String string = props.getProperty(keys[i]);
            if (string == null) continue;
            return string;
        }
        for (String string : props.keySet()) {
            for (int j = 0; j < keys.length; ++j) {
                if (!string.endsWith(keys[j])) continue;
                return props.getProperty(string);
            }
        }
        return null;
    }

    public boolean connect(Properties props) throws IOException {
        String url = this.getProperty(props, new String[]{"url", "javax.jdo.option.ConnectionURL", "ConnectionURL"});
        String driver = this.getProperty(props, new String[]{"driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName"});
        String username = this.getProperty(props, new String[]{"user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName"});
        String password = this.getProperty(props, new String[]{"password", "javax.jdo.option.ConnectionPassword", "ConnectionPassword"});
        if (url == null || url.length() == 0) {
            return this.beeLine.error("Property \"url\" is required");
        }
        if (!(driver != null && driver.length() != 0 || this.beeLine.scanForDriver(url))) {
            return this.beeLine.error(this.beeLine.loc("no-driver", url));
        }
        this.beeLine.info("Connecting to " + url);
        if (username == null) {
            username = this.beeLine.getConsoleReader().readLine("Enter username for " + url + ": ");
        }
        if (password == null) {
            password = this.beeLine.getConsoleReader().readLine("Enter password for " + url + ": ", new Character('*'));
        }
        try {
            this.beeLine.getDatabaseConnections().setConnection(new DatabaseConnection(this.beeLine, driver, url, username, password));
            this.beeLine.getDatabaseConnection().getConnection();
            this.beeLine.setCompletions();
            return true;
        }
        catch (SQLException sqle) {
            return this.beeLine.error(sqle);
        }
        catch (IOException ioe) {
            return this.beeLine.error(ioe);
        }
    }

    public boolean rehash(String line) {
        try {
            if (!this.beeLine.assertConnection()) {
                return false;
            }
            if (this.beeLine.getDatabaseConnection() != null) {
                this.beeLine.getDatabaseConnection().setCompletions(false);
            }
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean list(String line) {
        int index = 0;
        this.beeLine.info(this.beeLine.loc("active-connections", this.beeLine.getDatabaseConnections().size()));
        Iterator<DatabaseConnection> i = this.beeLine.getDatabaseConnections().iterator();
        while (i.hasNext()) {
            DatabaseConnection c = i.next();
            boolean closed = false;
            try {
                closed = c.getConnection().isClosed();
            }
            catch (Exception e) {
                closed = true;
            }
            this.beeLine.output(this.beeLine.getColorBuffer().pad(" #" + index + "", 5).pad(closed ? this.beeLine.loc("closed") : this.beeLine.loc("open"), 9).append(c.getUrl()));
            ++index;
        }
        return true;
    }

    public boolean all(String line) {
        int index = this.beeLine.getDatabaseConnections().getIndex();
        boolean success = true;
        for (int i = 0; i < this.beeLine.getDatabaseConnections().size(); ++i) {
            this.beeLine.getDatabaseConnections().setIndex(i);
            this.beeLine.output(this.beeLine.loc("executing-con", this.beeLine.getDatabaseConnection()));
            success = this.sql(line.substring("all ".length())) && success;
        }
        this.beeLine.getDatabaseConnections().setIndex(index);
        return success;
    }

    public boolean go(String line) {
        String[] parts = this.beeLine.split(line, 2, "Usage: go <connection index>");
        if (parts == null) {
            return false;
        }
        int index = Integer.parseInt(parts[1]);
        if (!this.beeLine.getDatabaseConnections().setIndex(index)) {
            this.beeLine.error(this.beeLine.loc("invalid-connection", "" + index));
            this.list("");
            return false;
        }
        return true;
    }

    public boolean script(String line) {
        if (this.beeLine.getScriptOutputFile() == null) {
            return this.startScript(line);
        }
        return this.stopScript(line);
    }

    private boolean stopScript(String line) {
        try {
            this.beeLine.getScriptOutputFile().close();
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        this.beeLine.output(this.beeLine.loc("script-closed", this.beeLine.getScriptOutputFile()));
        this.beeLine.setScriptOutputFile(null);
        return true;
    }

    private boolean startScript(String line) {
        if (this.beeLine.getScriptOutputFile() != null) {
            return this.beeLine.error(this.beeLine.loc("script-already-running", this.beeLine.getScriptOutputFile()));
        }
        String[] parts = this.beeLine.split(line, 2, "Usage: script <filename>");
        if (parts == null) {
            return false;
        }
        try {
            this.beeLine.setScriptOutputFile(new OutputFile(parts[1]));
            this.beeLine.output(this.beeLine.loc("script-started", this.beeLine.getScriptOutputFile()));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String line) {
        String[] parts = this.beeLine.split(line, 2, "Usage: run <scriptfile>");
        if (parts == null) {
            return false;
        }
        LinkedList<String> cmds = new LinkedList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(parts[1]));
            try {
                String scriptLine;
                StringBuilder cmd = null;
                while ((scriptLine = reader.readLine()) != null) {
                    String trimmedLine = scriptLine.trim();
                    if (this.beeLine.getOpts().getTrimScripts()) {
                        scriptLine = trimmedLine;
                    }
                    if (cmd != null) {
                        cmd.append(" \n");
                        cmd.append(scriptLine);
                        if (!trimmedLine.endsWith(";")) continue;
                        cmds.add(cmd.toString());
                        cmd = null;
                        continue;
                    }
                    if (this.beeLine.needsContinuation(scriptLine)) {
                        cmd = new StringBuilder(scriptLine);
                        continue;
                    }
                    cmds.add(scriptLine);
                }
                if (cmd != null) {
                    cmd.append(";");
                    cmds.add(cmd.toString());
                }
            }
            finally {
                reader.close();
            }
            return this.beeLine.runCommands(cmds) == cmds.size();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean record(String line) {
        if (this.beeLine.getRecordOutputFile() == null) {
            return this.startRecording(line);
        }
        return this.stopRecording(line);
    }

    private boolean stopRecording(String line) {
        try {
            this.beeLine.getRecordOutputFile().close();
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
        this.beeLine.output(this.beeLine.loc("record-closed", this.beeLine.getRecordOutputFile()));
        this.beeLine.setRecordOutputFile(null);
        return true;
    }

    private boolean startRecording(String line) {
        if (this.beeLine.getRecordOutputFile() != null) {
            return this.beeLine.error(this.beeLine.loc("record-already-running", this.beeLine.getRecordOutputFile()));
        }
        String[] parts = this.beeLine.split(line, 2, "Usage: record <filename>");
        if (parts == null) {
            return false;
        }
        try {
            this.beeLine.setRecordOutputFile(new OutputFile(parts[1]));
            this.beeLine.output(this.beeLine.loc("record-started", this.beeLine.getRecordOutputFile()));
            return true;
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
    }

    public boolean describe(String line) throws SQLException {
        String[] table = this.beeLine.split(line, 2, "Usage: describe <table name>");
        if (table == null) {
            return false;
        }
        ResultSet rs = table[1].equals("tables") ? this.beeLine.getTables() : this.beeLine.getColumns(table[1]);
        if (rs == null) {
            return false;
        }
        this.beeLine.print(rs);
        rs.close();
        return true;
    }

    public boolean help(String line) {
        String[] parts = this.beeLine.split(line);
        String cmd = parts.length > 1 ? parts[1] : "";
        boolean count = false;
        TreeSet<ColorBuffer> clist = new TreeSet<ColorBuffer>();
        for (int i = 0; i < this.beeLine.commandHandlers.length; ++i) {
            if (cmd.length() != 0 && !Arrays.asList(this.beeLine.commandHandlers[i].getNames()).contains(cmd)) continue;
            clist.add(this.beeLine.getColorBuffer().pad("!" + this.beeLine.commandHandlers[i].getName(), 20).append(this.beeLine.wrap(this.beeLine.commandHandlers[i].getHelpText(), 60, 20)));
        }
        Iterator i = clist.iterator();
        while (i.hasNext()) {
            this.beeLine.output((ColorBuffer)i.next());
        }
        if (cmd.length() == 0) {
            this.beeLine.output("");
            this.beeLine.output(this.beeLine.loc("comments", this.beeLine.getApplicationContactInformation()));
        }
        return true;
    }

    public boolean manual(String line) throws IOException {
        String man;
        InputStream in = BeeLine.class.getResourceAsStream("manual.txt");
        if (in == null) {
            return this.beeLine.error(this.beeLine.loc("no-manual"));
        }
        BufferedReader breader = new BufferedReader(new InputStreamReader(in));
        int index = 0;
        while ((man = breader.readLine()) != null) {
            String ret;
            this.beeLine.output(man);
            if (++index % (this.beeLine.getOpts().getMaxHeight() - 1) != 0 || (ret = this.beeLine.getConsoleReader().readLine(this.beeLine.loc("enter-for-more"))) == null || !ret.startsWith("q")) continue;
            break;
        }
        breader.close();
        return true;
    }
}

