/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.Rows;

class BufferedRows
extends Rows {
    private final LinkedList<Rows.Row> list = new LinkedList();
    private final Iterator<Rows.Row> iterator;

    BufferedRows(BeeLine beeLine, ResultSet rs) throws SQLException {
        super(beeLine, rs);
        int count = this.rsMeta.getColumnCount();
        this.list.add(new Rows.Row(this, count));
        while (rs.next()) {
            this.list.add(new Rows.Row(this, count, rs));
        }
        this.iterator = this.list.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    @Override
    void normalizeWidths() {
        int[] max = null;
        for (Rows.Row row : this.list) {
            if (max == null) {
                max = new int[row.values.length];
            }
            for (int j = 0; j < max.length; ++j) {
                max[j] = Math.max(max[j], row.sizes[j] + 1);
            }
        }
        for (Rows.Row row : this.list) {
            row.sizes = max;
        }
    }
}

