/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import jline.Completor;
import jline.SimpleCompletor;
import jline.Terminal;
import org.apache.hive.beeline.BeeLine;

class BeeLineOpts
implements Completor {
    public static final int DEFAULT_MAX_WIDTH = 80;
    public static final int DEFAULT_MAX_HEIGHT = 80;
    public static final int DEFAULT_HEADER_INTERVAL = 100;
    public static final String DEFAULT_ISOLATION_LEVEL = "TRANSACTION_REPEATABLE_READ";
    public static final String PROPERTY_PREFIX = "beeline.";
    public static final String PROPERTY_NAME_EXIT = "beeline.system.exit";
    private final BeeLine beeLine;
    private boolean autosave = false;
    private boolean silent = false;
    private boolean color = false;
    private boolean showHeader = true;
    private int headerInterval = 100;
    private boolean fastConnect = true;
    private boolean autoCommit = false;
    private boolean verbose = false;
    private boolean force = false;
    private boolean incremental = false;
    private boolean showWarnings = false;
    private boolean showNestedErrs = false;
    private boolean showElapsedTime = true;
    private String numberFormat = "default";
    private final Terminal terminal = Terminal.setupTerminal();
    private int maxWidth = 80;
    private int maxHeight = 80;
    private int maxColumnWidth = 15;
    int timeout = -1;
    private String isolation = "TRANSACTION_REPEATABLE_READ";
    private String outputFormat = "table";
    private boolean trimScripts = true;
    private final File rcFile = new File(this.saveDir(), "beeline.properties");
    private String historyFile = new File(this.saveDir(), "history").getAbsolutePath();

    public BeeLineOpts(BeeLine beeLine, Properties props) {
        this.beeLine = beeLine;
        if (this.terminal.getTerminalWidth() > 0) {
            this.maxWidth = this.terminal.getTerminalWidth();
        }
        if (this.terminal.getTerminalHeight() > 0) {
            this.maxHeight = this.terminal.getTerminalHeight();
        }
        this.loadProperties(props);
    }

    public Completor[] optionCompletors() {
        return new Completor[]{this};
    }

    public String[] possibleSettingValues() {
        LinkedList<String> vals = new LinkedList<String>();
        vals.addAll(Arrays.asList("yes", "no"));
        return vals.toArray(new String[vals.size()]);
    }

    public File saveDir() {
        String dir = System.getProperty("beeline.rcfile");
        if (dir != null && dir.length() > 0) {
            return new File(dir);
        }
        File f = new File(System.getProperty("user.home"), (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "" : ".") + "beeline").getAbsoluteFile();
        try {
            f.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public int complete(String buf, int pos, List cand) {
        try {
            return new SimpleCompletor(this.propertyNames()).complete(buf, pos, cand);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.rcFile);
        this.save(out);
        ((OutputStream)out).close();
    }

    public void save(OutputStream out) throws IOException {
        try {
            Properties props = this.toProperties();
            props.remove("beeline.maxwidth");
            props.store(out, this.beeLine.getApplicationTitle());
        }
        catch (Exception e) {
            this.beeLine.handleException(e);
        }
    }

    String[] propertyNames() throws IllegalAccessException, InvocationTargetException {
        TreeSet<String> names = new TreeSet<String>();
        Method[] m = this.getClass().getDeclaredMethods();
        for (int i = 0; m != null && i < m.length; ++i) {
            if (!m[i].getName().startsWith("get") || m[i].getParameterTypes().length != 0) continue;
            String propName = m[i].getName().substring(3).toLowerCase();
            names.add(propName);
        }
        return names.toArray(new String[names.size()]);
    }

    public Properties toProperties() throws IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Properties props = new Properties();
        String[] names = this.propertyNames();
        for (int i = 0; names != null && i < names.length; ++i) {
            props.setProperty(PROPERTY_PREFIX + names[i], this.beeLine.getReflector().invoke((Object)this, "get" + names[i], new Object[0]).toString());
        }
        this.beeLine.debug("properties: " + props.toString());
        return props;
    }

    public void load() throws IOException {
        FileInputStream in = new FileInputStream(this.rcFile);
        this.load(in);
        ((InputStream)in).close();
    }

    public void load(InputStream fin) throws IOException {
        Properties p = new Properties();
        p.load(fin);
        this.loadProperties(p);
    }

    public void loadProperties(Properties props) {
        for (Object element : props.keySet()) {
            String key = element.toString();
            if (key.equals(PROPERTY_NAME_EXIT) || !key.startsWith(PROPERTY_PREFIX)) continue;
            this.set(key.substring(PROPERTY_PREFIX.length()), props.getProperty(key));
        }
    }

    public void set(String key, String value) {
        this.set(key, value, false);
    }

    public boolean set(String key, String value, boolean quiet) {
        try {
            this.beeLine.getReflector().invoke((Object)this, "set" + key, new Object[]{value});
            return true;
        }
        catch (Exception e) {
            if (!quiet) {
                this.beeLine.error(this.beeLine.loc("error-setting", new Object[]{key, e}));
            }
            return false;
        }
    }

    public void setFastConnect(boolean fastConnect) {
        this.fastConnect = fastConnect;
    }

    public boolean getFastConnect() {
        return this.fastConnect;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public boolean getShowWarnings() {
        return this.showWarnings;
    }

    public void setShowNestedErrs(boolean showNestedErrs) {
        this.showNestedErrs = showNestedErrs;
    }

    public boolean getShowNestedErrs() {
        return this.showNestedErrs;
    }

    public void setShowElapsedTime(boolean showElapsedTime) {
        this.showElapsedTime = showElapsedTime;
    }

    public boolean getShowElapsedTime() {
        return this.showElapsedTime;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxColumnWidth(int maxColumnWidth) {
        this.maxColumnWidth = maxColumnWidth;
    }

    public int getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setIsolation(String isolation) {
        this.isolation = isolation;
    }

    public String getIsolation() {
        return this.isolation;
    }

    public void setHistoryFile(String historyFile) {
        this.historyFile = historyFile;
    }

    public String getHistoryFile() {
        return this.historyFile;
    }

    public void setColor(boolean color) {
        this.color = color;
    }

    public boolean getColor() {
        return this.color;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public void setHeaderInterval(int headerInterval) {
        this.headerInterval = headerInterval;
    }

    public int getHeaderInterval() {
        return this.headerInterval;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setAutosave(boolean autosave) {
        this.autosave = autosave;
    }

    public boolean getAutosave() {
        return this.autosave;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setTrimScripts(boolean trimScripts) {
        this.trimScripts = trimScripts;
    }

    public boolean getTrimScripts() {
        return this.trimScripts;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public File getPropertiesFile() {
        return this.rcFile;
    }
}

