/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ant;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class QTestGenTask
extends Task {
    private List<String> templatePaths = new ArrayList<String>();
    private String hiveRootDirectory;
    private String outputDirectory;
    private String queryDirectory;
    private String queryFile;
    private String excludeQueryFile;
    private String queryFileRegex;
    private String resultsDirectory;
    private String logDirectory;
    private String template;
    private String className;
    private String logFile;
    private String clusterMode;
    private String runDisabled;
    private String hadoopVersion;

    public void setHadoopVersion(String ver) {
        this.hadoopVersion = ver;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public void setRunDisabled(String runDisabled) {
        this.runDisabled = runDisabled;
    }

    public String getRunDisabled() {
        return this.runDisabled;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplatePath(String templatePath) throws Exception {
        this.templatePaths.clear();
        for (String relativePath : templatePath.split(",")) {
            this.templatePaths.add(this.project.resolveFile(relativePath).getCanonicalPath());
        }
        System.out.println("Template Path:" + this.getTemplatePath());
    }

    public String getTemplatePath() {
        return StringUtils.join(this.templatePaths, (String)",");
    }

    public void setHiveRootDirectory(File hiveRootDirectory) {
        try {
            this.hiveRootDirectory = hiveRootDirectory.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public String getHiveRootDirectory() {
        return this.hiveRootDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        try {
            this.outputDirectory = outputDirectory.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setResultsDirectory(String resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public String getResultsDirectory() {
        return this.resultsDirectory;
    }

    public void setQueryDirectory(String queryDirectory) {
        this.queryDirectory = queryDirectory;
    }

    public String getQueryDirectory() {
        return this.queryDirectory;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setExcludeQueryFile(String excludeQueryFile) {
        this.excludeQueryFile = excludeQueryFile;
    }

    public String getExcludeQueryFile() {
        return this.excludeQueryFile;
    }

    public void setQueryFileRegex(String queryFileRegex) {
        this.queryFileRegex = queryFileRegex;
    }

    public String getQueryFileRegex() {
        return this.queryFileRegex;
    }

    public void execute() throws BuildException {
        if (this.getTemplatePath().equals("")) {
            throw new BuildException("No templatePath attribute specified");
        }
        if (this.template == null) {
            throw new BuildException("No template attribute specified");
        }
        if (this.outputDirectory == null) {
            throw new BuildException("No outputDirectory specified");
        }
        if (this.queryDirectory == null && this.queryFile == null) {
            throw new BuildException("No queryDirectory or queryFile specified");
        }
        if (this.logDirectory == null) {
            throw new BuildException("No logDirectory specified");
        }
        if (this.resultsDirectory == null) {
            throw new BuildException("No resultsDirectory specified");
        }
        if (this.className == null) {
            throw new BuildException("No className specified");
        }
        ArrayList<File> qFiles = new ArrayList<File>();
        File hiveRootDir = null;
        File queryDir = null;
        File outDir = null;
        File resultsDir = null;
        File logDir = null;
        try {
            if (this.queryDirectory != null) {
                queryDir = new File(this.queryDirectory);
            }
            if (this.queryFile != null && !this.queryFile.equals("")) {
                for (String qFile : this.queryFile.split(",")) {
                    if (null != queryDir) {
                        qFiles.add(new File(queryDir, qFile));
                        continue;
                    }
                    qFiles.add(new File(qFile));
                }
            } else if (this.queryFileRegex != null && !this.queryFileRegex.equals("")) {
                qFiles.addAll(Arrays.asList(queryDir.listFiles(new QFileRegexFilter(this.queryFileRegex))));
            } else if (this.runDisabled != null && this.runDisabled.equals("true")) {
                qFiles.addAll(Arrays.asList(queryDir.listFiles(new DisabledQFileFilter())));
            } else {
                qFiles.addAll(Arrays.asList(queryDir.listFiles(new QFileFilter())));
            }
            if (this.excludeQueryFile != null && !this.excludeQueryFile.equals("")) {
                for (String qFile : this.excludeQueryFile.split(",")) {
                    if (null != queryDir) {
                        qFiles.remove(new File(queryDir, qFile));
                        continue;
                    }
                    qFiles.remove(new File(qFile));
                }
            }
            Collections.sort(qFiles);
            hiveRootDir = new File(this.hiveRootDirectory);
            if (!hiveRootDir.exists()) {
                throw new BuildException("Hive Root Directory " + hiveRootDir.getCanonicalPath() + " does not exist");
            }
            outDir = new File(this.outputDirectory);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if (!(logDir = new File(this.logDirectory)).exists()) {
                throw new BuildException("Log Directory " + logDir.getCanonicalPath() + " does not exist");
            }
            resultsDir = new File(this.resultsDirectory);
            if (!resultsDir.exists()) {
                throw new BuildException("Results Directory " + resultsDir.getCanonicalPath() + " does not exist");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.setProperty("file.resource.loader.path", (Object)this.getTemplatePath());
            if (this.logFile != null) {
                File lf = new File(this.logFile);
                if (lf.exists() && !lf.delete()) {
                    throw new Exception("Could not delete log file " + lf.getCanonicalPath());
                }
                ve.setProperty("runtime.log", (Object)this.logFile);
            }
            ve.init();
            Template t = ve.getTemplate(this.template);
            if (this.clusterMode == null) {
                this.clusterMode = new String("");
            }
            if (this.hadoopVersion == null) {
                this.hadoopVersion = "";
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("className", (Object)this.className);
            ctx.put("qfiles", qFiles);
            ctx.put("hiveRootDir", (Object)hiveRootDir);
            ctx.put("queryDir", (Object)queryDir);
            ctx.put("resultsDir", (Object)resultsDir);
            ctx.put("logDir", (Object)logDir);
            ctx.put("clusterMode", (Object)this.clusterMode);
            ctx.put("hadoopVersion", (Object)this.hadoopVersion);
            File outFile = new File(outDir, this.className + ".java");
            FileWriter writer = new FileWriter(outFile);
            t.merge((Context)ctx, (Writer)writer);
            writer.close();
            System.out.println("Generated " + outFile.getCanonicalPath() + " from template " + this.template);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            throw new BuildException("Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'", e.getWrappedThrowable());
        }
        catch (ParseErrorException e) {
            throw new BuildException("Velocity syntax error", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new BuildException("Resource not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("Generation failed", (Throwable)e);
        }
    }

    public class QFileRegexFilter
    extends QFileFilter {
        Pattern filterPattern;

        public QFileRegexFilter(String filter) {
            this.filterPattern = Pattern.compile(filter);
        }

        @Override
        public boolean accept(File filePath) {
            if (!super.accept(filePath)) {
                return false;
            }
            String testName = StringUtils.chomp((String)filePath.getName(), (String)".q");
            return this.filterPattern.matcher(testName).matches();
        }
    }

    public class DisabledQFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File fpath) {
            return !fpath.isDirectory() && fpath.getName().endsWith(".q.disabled");
        }
    }

    public class QFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File fpath) {
            return !fpath.isDirectory() && fpath.getName().endsWith(".q");
        }
    }
}

