/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ant;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class QTestGenTask
extends Task {
    private static final Splitter TEST_SPLITTER = Splitter.onPattern((String)"[, ]").trimResults().omitEmptyStrings();
    private List<String> templatePaths = new ArrayList<String>();
    private String hiveRootDirectory;
    private String outputDirectory;
    private String queryDirectory;
    private String queryFile;
    private String includeQueryFile;
    private String excludeQueryFile;
    private String queryFileRegex;
    private String resultsDirectory;
    private String logDirectory;
    private String template;
    private String className;
    private String logFile;
    private String clusterMode;
    private String hiveConfDir;
    private String runDisabled;
    private String hadoopVersion;
    private String initScript;
    private String cleanupScript;

    public void setHadoopVersion(String ver) {
        this.hadoopVersion = ver;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public void setRunDisabled(String runDisabled) {
        this.runDisabled = runDisabled;
    }

    public String getRunDisabled() {
        return this.runDisabled;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public void setInitScript(String initScript) {
        this.initScript = initScript;
    }

    public String getCleanupScript() {
        return this.cleanupScript;
    }

    public void setCleanupScript(String cleanupScript) {
        this.cleanupScript = cleanupScript;
    }

    public void setHiveRootDirectory(File hiveRootDirectory) {
        try {
            this.hiveRootDirectory = hiveRootDirectory.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public String getHiveRootDirectory() {
        return this.hiveRootDirectory;
    }

    public void setTemplatePath(String templatePath) throws Exception {
        this.templatePaths.clear();
        for (String relativePath : TEST_SPLITTER.split((CharSequence)templatePath)) {
            this.templatePaths.add(this.project.resolveFile(relativePath).getCanonicalPath());
        }
        System.out.println("Template Path:" + this.getTemplatePath());
    }

    public String getTemplatePath() {
        return StringUtils.join(this.templatePaths, (String)",");
    }

    public void setOutputDirectory(File outputDirectory) {
        try {
            this.outputDirectory = outputDirectory.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setResultsDirectory(String resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public String getResultsDirectory() {
        return this.resultsDirectory;
    }

    public void setQueryDirectory(String queryDirectory) {
        this.queryDirectory = queryDirectory;
    }

    public String getQueryDirectory() {
        return this.queryDirectory;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public String getIncludeQueryFile() {
        return this.includeQueryFile;
    }

    public void setIncludeQueryFile(String includeQueryFile) {
        this.includeQueryFile = includeQueryFile;
    }

    public void setExcludeQueryFile(String excludeQueryFile) {
        this.excludeQueryFile = excludeQueryFile;
    }

    public String getExcludeQueryFile() {
        return this.excludeQueryFile;
    }

    public void setQueryFileRegex(String queryFileRegex) {
        this.queryFileRegex = queryFileRegex;
    }

    public String getQueryFileRegex() {
        return this.queryFileRegex;
    }

    private String createAlternativeFile(File file) throws Exception {
        String fileNameExtension;
        String fileParentDir = file.getParent();
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        String fileNameWithoutExtension = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
        String string = fileNameExtension = dotIndex == -1 ? "" : fileName.substring(dotIndex);
        if (fileNameWithoutExtension.length() < 3) {
            fileNameWithoutExtension = fileNameWithoutExtension + "_tmp";
        }
        File alternativeFile = File.createTempFile(fileNameWithoutExtension, fileNameExtension, new File(fileParentDir));
        return alternativeFile.getCanonicalPath();
    }

    public void execute() throws BuildException {
        ArrayList qFiles;
        if (this.getTemplatePath().equals("")) {
            throw new BuildException("No templatePath attribute specified");
        }
        if (this.template == null) {
            throw new BuildException("No template attribute specified");
        }
        if (this.outputDirectory == null) {
            throw new BuildException("No outputDirectory specified");
        }
        if (this.queryDirectory == null && this.queryFile == null) {
            throw new BuildException("No queryDirectory or queryFile specified");
        }
        if (this.logDirectory == null) {
            throw new BuildException("No logDirectory specified");
        }
        if (this.className == null) {
            throw new BuildException("No className specified");
        }
        HashSet includeOnly = null;
        if (this.includeQueryFile != null && !this.includeQueryFile.isEmpty()) {
            includeOnly = Sets.newHashSet((Iterable)TEST_SPLITTER.split((CharSequence)this.includeQueryFile));
        }
        HashMap<String, String> qFilesMap = new HashMap<String, String>();
        File hiveRootDir = null;
        File queryDir = null;
        File outDir = null;
        File resultsDir = null;
        File logDir = null;
        try {
            System.out.println("Starting Generation of: " + this.className);
            System.out.println("Include Files: " + this.includeQueryFile);
            System.out.println("Excluded Files: " + this.excludeQueryFile);
            System.out.println("Query Files: " + this.queryFile);
            System.out.println("Query Files Regex: " + this.queryFileRegex);
            queryDir = new File(this.queryDirectory);
            HashSet<File> testFiles = new HashSet<File>();
            if (this.queryFile != null && !this.queryFile.equals("")) {
                for (Object qFile : TEST_SPLITTER.split((CharSequence)this.queryFile)) {
                    if (null != queryDir) {
                        testFiles.add(new File(queryDir, (String)qFile));
                        continue;
                    }
                    testFiles.add(new File((String)qFile));
                }
            } else if (this.queryFileRegex != null && !this.queryFileRegex.equals("")) {
                for (String regex : TEST_SPLITTER.split((CharSequence)this.queryFileRegex)) {
                    testFiles.addAll(Arrays.asList(queryDir.listFiles(new QFileRegexFilter(regex))));
                }
            } else if (this.runDisabled != null && this.runDisabled.equals("true")) {
                testFiles.addAll(Arrays.asList(queryDir.listFiles(new DisabledQFileFilter(includeOnly))));
            } else {
                testFiles.addAll(Arrays.asList(queryDir.listFiles(new QFileFilter(includeOnly))));
            }
            if (this.excludeQueryFile != null && !this.excludeQueryFile.equals("")) {
                for (Object qFile : TEST_SPLITTER.split((CharSequence)this.excludeQueryFile)) {
                    if (null != queryDir) {
                        testFiles.remove(new File(queryDir, (String)qFile));
                        continue;
                    }
                    testFiles.remove(new File((String)qFile));
                }
            }
            if (!(hiveRootDir = new File(this.hiveRootDirectory)).exists()) {
                throw new BuildException("Hive Root Directory " + hiveRootDir.getCanonicalPath() + " does not exist");
            }
            qFiles = new ArrayList(testFiles);
            Collections.sort(qFiles);
            for (Object qFile : qFiles) {
                qFilesMap.put(((File)qFile).getName(), this.relativePath(hiveRootDir, (File)qFile));
            }
            outDir = new File(this.outputDirectory);
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if (!(logDir = new File(this.logDirectory)).exists()) {
                throw new BuildException("Log Directory " + logDir.getCanonicalPath() + " does not exist");
            }
            if (this.resultsDirectory != null && !(resultsDir = new File(this.resultsDirectory)).exists()) {
                throw new BuildException("Results Directory " + resultsDir.getCanonicalPath() + " does not exist");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.setProperty("file.resource.loader.path", (Object)this.getTemplatePath());
            if (this.logFile != null) {
                File lf = new File(this.logFile);
                if (lf.exists()) {
                    System.out.println("Log file already exists: " + lf.getCanonicalPath());
                    if (!lf.delete()) {
                        System.out.println("Could not delete log file " + lf.getCanonicalPath());
                        this.logFile = this.createAlternativeFile(lf);
                    }
                }
                ve.setProperty("runtime.log", (Object)this.logFile);
            }
            ve.init();
            Template t = ve.getTemplate(this.template);
            if (this.clusterMode == null) {
                this.clusterMode = "";
            }
            if (this.hadoopVersion == null) {
                this.hadoopVersion = "";
            }
            File qFileNames = new File(this.outputDirectory, this.className + "QFileNames.txt");
            String qFileNamesFile = qFileNames.toURI().getPath();
            if (qFileNames.exists()) {
                System.out.println("Query file names containing file already exists: " + qFileNamesFile);
                if (!qFileNames.delete()) {
                    System.out.println("Could not delete query file names containing file " + qFileNames.getCanonicalPath());
                    qFileNamesFile = this.createAlternativeFile(qFileNames);
                } else if (!qFileNames.createNewFile()) {
                    System.out.println("Could not create query file names containing file " + qFileNamesFile);
                    qFileNamesFile = this.createAlternativeFile(qFileNames);
                }
            }
            FileWriter fw = new FileWriter(qFileNames.getCanonicalFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (File qFile : qFiles) {
                bw.write(qFile.getName());
                bw.newLine();
            }
            bw.close();
            System.out.println("hiveRootDir = " + hiveRootDir);
            VelocityContext ctx = new VelocityContext();
            ctx.put("className", (Object)this.className);
            ctx.put("hiveRootDir", (Object)QTestGenTask.escapePath(hiveRootDir.getCanonicalPath()));
            System.out.println("hiveRootDir = " + hiveRootDir);
            System.out.println("queryDir = " + queryDir);
            String strQueryDir = this.relativePath(hiveRootDir, queryDir);
            System.out.println("queryDir = " + strQueryDir);
            ctx.put("queryDir", (Object)strQueryDir);
            ctx.put("qfiles", qFiles);
            ctx.put("qFileNamesFile", (Object)qFileNamesFile);
            ctx.put("qfilesMap", qFilesMap);
            if (resultsDir != null) {
                ctx.put("resultsDir", (Object)this.relativePath(hiveRootDir, resultsDir));
            }
            ctx.put("logDir", (Object)this.relativePath(hiveRootDir, logDir));
            ctx.put("clusterMode", (Object)this.clusterMode);
            if (this.hiveConfDir == null || this.hiveConfDir.isEmpty()) {
                ctx.put("hiveConfDir", (Object)"");
            } else {
                System.out.println("hiveConfDir = " + this.hiveConfDir);
                this.hiveConfDir = this.relativePath(hiveRootDir, new File(this.hiveConfDir));
                System.out.println("hiveConfDir = " + this.hiveConfDir);
                if (!new File(hiveRootDir, this.hiveConfDir).isDirectory()) {
                    throw new BuildException("hiveConfDir is not dir " + new File(hiveRootDir, this.hiveConfDir));
                }
                ctx.put("hiveConfDir", (Object)this.hiveConfDir);
            }
            ctx.put("hadoopVersion", (Object)this.hadoopVersion);
            ctx.put("initScript", (Object)this.initScript);
            ctx.put("cleanupScript", (Object)this.cleanupScript);
            File outFile = new File(outDir, this.className + ".java");
            FileWriter writer = new FileWriter(outFile);
            t.merge((Context)ctx, (Writer)writer);
            writer.close();
            System.out.println("Generated " + outFile.getCanonicalPath() + " from template " + this.template);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (MethodInvocationException e) {
            throw new BuildException("Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'", e.getWrappedThrowable());
        }
        catch (ParseErrorException e) {
            throw new BuildException("Velocity syntax error", (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            throw new BuildException("Resource not found", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Generation failed", (Throwable)e);
        }
    }

    private String relativePath(File hiveRootDir, File file) {
        return QTestGenTask.escapePath(hiveRootDir.toURI().relativize(file.toURI()).getPath());
    }

    private static String escapePath(String path) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return path.replace("\\", "\\\\");
        }
        return path;
    }

    public class QFileRegexFilter
    implements FileFilter {
        Pattern filterPattern;

        public QFileRegexFilter(String filter) {
            this.filterPattern = Pattern.compile(filter);
        }

        @Override
        public boolean accept(File filePath) {
            if (filePath.isDirectory() || !filePath.getName().endsWith(".q")) {
                return false;
            }
            String testName = StringUtils.chomp((String)filePath.getName(), (String)".q");
            return this.filterPattern.matcher(testName).matches();
        }
    }

    public class DisabledQFileFilter
    extends IncludeFilter {
        public DisabledQFileFilter(Set<String> includeOnly) {
            super(includeOnly);
        }

        @Override
        public boolean accept(File fpath) {
            if (!super.accept(fpath)) {
                return false;
            }
            return !fpath.isDirectory() && fpath.getName().endsWith(".q.disabled");
        }
    }

    public class QFileFilter
    extends IncludeFilter {
        public QFileFilter(Set<String> includeOnly) {
            super(includeOnly);
        }

        @Override
        public boolean accept(File fpath) {
            if (!super.accept(fpath)) {
                return false;
            }
            return !fpath.isDirectory() && fpath.getName().endsWith(".q");
        }
    }

    public class IncludeFilter
    implements FileFilter {
        Set<String> includeOnly;

        public IncludeFilter(Set<String> includeOnly) {
            this.includeOnly = includeOnly;
        }

        @Override
        public boolean accept(File fpath) {
            return this.includeOnly == null || this.includeOnly.contains(fpath.getName());
        }
    }
}

