/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.Utils;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowSerializer;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;

public class DefaultAccumuloRowIdFactory
implements AccumuloRowIdFactory {
    protected AccumuloSerDeParameters accumuloSerDeParams;
    protected LazySerDeParameters serdeParams;
    protected Properties properties;
    protected HiveAccumuloRowIdColumnMapping rowIdMapping;
    protected AccumuloRowSerializer serializer;

    @Override
    public void init(AccumuloSerDeParameters accumuloSerDeParams, Properties properties) throws SerDeException {
        this.accumuloSerDeParams = accumuloSerDeParams;
        this.serdeParams = accumuloSerDeParams.getSerDeParameters();
        this.properties = properties;
        this.serializer = new AccumuloRowSerializer(accumuloSerDeParams.getRowIdOffset(), this.serdeParams, accumuloSerDeParams.getColumnMappings(), accumuloSerDeParams.getTableVisibilityLabel(), this);
        this.rowIdMapping = accumuloSerDeParams.getRowIdColumnMapping();
    }

    @Override
    public void addDependencyJars(Configuration conf) throws IOException {
        Utils.addDependencyJars(conf, this.getClass());
    }

    @Override
    public ObjectInspector createRowIdObjectInspector(TypeInfo type) throws SerDeException {
        return LazyFactory.createLazyObjectInspector((TypeInfo)type, (byte[])this.serdeParams.getSeparators(), (int)1, (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
    }

    @Override
    public LazyObjectBase createRowId(ObjectInspector inspector) throws SerDeException {
        return LazyFactory.createLazyObject((ObjectInspector)inspector, (inspector.getTypeName() != TypeInfoFactory.stringTypeInfo.getTypeName() && ColumnEncoding.BINARY == this.rowIdMapping.getEncoding() ? 1 : 0) != 0);
    }

    @Override
    public byte[] serializeRowId(Object object, StructField field, ByteStream.Output output) throws IOException {
        return this.serializer.serializeRowId(object, field, this.rowIdMapping);
    }
}

