/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;

public class DoubleCompare
implements PrimitiveComparison {
    private BigDecimal constant;

    @Override
    public void init(byte[] constant) {
        this.constant = this.serialize(constant);
    }

    @Override
    public BigDecimal serialize(byte[] value) {
        try {
            return new BigDecimal(ByteBuffer.wrap(value).asDoubleBuffer().get());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString() + " occurred trying to build double value. " + "Make sure the value type for the byte[] is double.");
        }
    }

    @Override
    public boolean isEqual(byte[] value) {
        return this.serialize(value).compareTo(this.constant) == 0;
    }

    @Override
    public boolean isNotEqual(byte[] value) {
        return this.serialize(value).compareTo(this.constant) != 0;
    }

    @Override
    public boolean greaterThanOrEqual(byte[] value) {
        return this.serialize(value).compareTo(this.constant) >= 0;
    }

    @Override
    public boolean greaterThan(byte[] value) {
        return this.serialize(value).compareTo(this.constant) > 0;
    }

    @Override
    public boolean lessThanOrEqual(byte[] value) {
        return this.serialize(value).compareTo(this.constant) <= 0;
    }

    @Override
    public boolean lessThan(byte[] value) {
        return this.serialize(value).compareTo(this.constant) < 0;
    }

    @Override
    public boolean like(byte[] value) {
        throw new UnsupportedOperationException("Like not supported for " + this.getClass().getName());
    }
}

