/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.accumulo.serde.DefaultAccumuloRowIdFactory;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class DelimitedAccumuloRowIdFactory
extends DefaultAccumuloRowIdFactory {
    private static final Logger log = Logger.getLogger(DelimitedAccumuloRowIdFactory.class);
    public static final String ACCUMULO_COMPOSITE_DELIMITER = "accumulo.composite.delimiter";
    private byte separator;

    public void init(AccumuloSerDeParameters accumuloSerDeParams, Properties properties) throws SerDeException {
        super.init(accumuloSerDeParams, properties);
        String delimiter = properties.getProperty(ACCUMULO_COMPOSITE_DELIMITER);
        if (null == delimiter || delimiter.isEmpty()) {
            throw new SerDeException("Did not find expected delimiter in configuration: accumulo.composite.delimiter");
        }
        if (delimiter.length() != 1) {
            log.warn((Object)"Configured delimiter is longer than one character, only using first character");
        }
        this.separator = (byte)delimiter.charAt(0);
        log.info((Object)("Initialized DelimitedAccumuloRowIdFactory with separator of '" + this.separator + "'"));
    }

    public ObjectInspector createRowIdObjectInspector(TypeInfo type) throws SerDeException {
        return LazyFactory.createLazyObjectInspector((TypeInfo)type, (byte[])new byte[]{this.separator}, (int)0, (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
    }

    public LazyObjectBase createRowId(ObjectInspector inspector) throws SerDeException {
        LazyObject lazyObj = LazyFactory.createLazyObject((ObjectInspector)inspector, (ColumnEncoding.BINARY == this.rowIdMapping.getEncoding() ? 1 : 0) != 0);
        log.info((Object)("Created " + lazyObj.getClass() + " for rowId with inspector " + inspector.getClass()));
        return lazyObj;
    }

    public byte[] serializeRowId(Object object, StructField field, ByteStream.Output output) throws IOException {
        ObjectInspector inspector = field.getFieldObjectInspector();
        if (inspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new IllegalStateException("invalid type value " + inspector.getTypeName());
        }
        output.reset();
        StructObjectInspector structOI = (StructObjectInspector)inspector;
        List elements = structOI.getStructFieldsDataAsList(object);
        List fields = structOI.getAllStructFieldRefs();
        for (int i = 0; i < elements.size(); ++i) {
            Object o = elements.get(i);
            StructField structField = (StructField)fields.get(i);
            if (output.getLength() > 0) {
                output.write((int)this.separator);
            }
            this.serializer.writeWithLevel(structField.getFieldObjectInspector(), o, output, (ColumnMapping)this.rowIdMapping, 1);
        }
        return output.toByteArray();
    }
}

