/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHiveAccumuloHelper {
    private HiveAccumuloHelper helper;

    @Before
    public void setup() {
        this.helper = new HiveAccumuloHelper();
    }

    @Test
    public void testTokenMerge() throws Exception {
        Text service = new Text("service");
        Token token = (Token)Mockito.mock(Token.class);
        JobConf jobConf = new JobConf();
        Mockito.when((Object)token.getService()).thenReturn((Object)service);
        this.helper.mergeTokenIntoJobConf(jobConf, token);
        Collection tokens = jobConf.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)service, (Object)((Token)tokens.iterator().next()).getService());
    }

    @Test
    public void testTokenToConfFromUser() throws Exception {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        JobConf jobConf = new JobConf();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Text service = new Text("service");
        Token token = (Token)Mockito.mock(Token.class);
        tokens.add(token);
        Mockito.when((Object)ugi.getTokens()).thenReturn(tokens);
        Mockito.when((Object)token.getKind()).thenReturn((Object)HiveAccumuloHelper.ACCUMULO_SERVICE);
        Mockito.when((Object)token.getService()).thenReturn((Object)service);
        this.helper.addTokenFromUserToJobConf(ugi, jobConf);
        Collection credTokens = jobConf.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)credTokens.size());
        Assert.assertEquals((Object)service, (Object)((Token)credTokens.iterator().next()).getService());
    }
}

