/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import org.apache.hadoop.hive.accumulo.predicate.compare.Equal;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.GreaterThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThan;
import org.apache.hadoop.hive.accumulo.predicate.compare.LessThanOrEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.Like;
import org.apache.hadoop.hive.accumulo.predicate.compare.NotEqual;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;
import org.apache.hadoop.hive.accumulo.predicate.compare.StringCompare;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStringCompare {
    private StringCompare strCompare;

    @Before
    public void setup() {
        this.strCompare = new StringCompare();
        this.strCompare.init("aaa".getBytes());
    }

    @Test
    public void equal() {
        Equal equalObj = new Equal((PrimitiveComparison)this.strCompare);
        byte[] val = "aaa".getBytes();
        Assert.assertTrue((boolean)equalObj.accept(val));
    }

    @Test
    public void notEqual() {
        NotEqual notEqualObj = new NotEqual((PrimitiveComparison)this.strCompare);
        byte[] val = "aab".getBytes();
        Assert.assertTrue((boolean)notEqualObj.accept(val));
        val = "aaa".getBytes();
        Assert.assertFalse((boolean)notEqualObj.accept(val));
    }

    @Test
    public void greaterThan() {
        GreaterThan greaterThanObj = new GreaterThan((PrimitiveComparison)this.strCompare);
        byte[] val = "aab".getBytes();
        Assert.assertTrue((boolean)greaterThanObj.accept(val));
        val = "aa".getBytes();
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
        val = "aaa".getBytes();
        Assert.assertFalse((boolean)greaterThanObj.accept(val));
    }

    @Test
    public void greaterThanOrEqual() {
        GreaterThanOrEqual greaterThanOrEqualObj = new GreaterThanOrEqual((PrimitiveComparison)this.strCompare);
        byte[] val = "aab".getBytes();
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
        val = "aa".getBytes();
        Assert.assertFalse((boolean)greaterThanOrEqualObj.accept(val));
        val = "aaa".getBytes();
        Assert.assertTrue((boolean)greaterThanOrEqualObj.accept(val));
    }

    @Test
    public void lessThan() {
        LessThan lessThanObj = new LessThan((PrimitiveComparison)this.strCompare);
        byte[] val = "aab".getBytes();
        Assert.assertFalse((boolean)lessThanObj.accept(val));
        val = "aa".getBytes();
        Assert.assertTrue((boolean)lessThanObj.accept(val));
        val = "aaa".getBytes();
        Assert.assertFalse((boolean)lessThanObj.accept(val));
    }

    @Test
    public void lessThanOrEqual() {
        LessThanOrEqual lessThanOrEqualObj = new LessThanOrEqual((PrimitiveComparison)this.strCompare);
        byte[] val = "aab".getBytes();
        Assert.assertFalse((boolean)lessThanOrEqualObj.accept(val));
        val = "aa".getBytes();
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
        val = "aaa".getBytes();
        Assert.assertTrue((boolean)lessThanOrEqualObj.accept(val));
    }

    @Test
    public void like() {
        Like likeObj = new Like((PrimitiveComparison)this.strCompare);
        String condition = "%a";
        Assert.assertTrue((boolean)likeObj.accept(condition.getBytes()));
        condition = "%a%";
        Assert.assertTrue((boolean)likeObj.accept(condition.getBytes()));
        condition = "a%";
        Assert.assertTrue((boolean)likeObj.accept(condition.getBytes()));
        condition = "a%aa";
        Assert.assertFalse((boolean)likeObj.accept(condition.getBytes()));
        condition = "b%";
        Assert.assertFalse((boolean)likeObj.accept(condition.getBytes()));
        condition = "%ab%";
        Assert.assertFalse((boolean)likeObj.accept(condition.getBytes()));
        condition = "%ba";
        Assert.assertFalse((boolean)likeObj.accept(condition.getBytes()));
    }
}

