/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.Utils;
import org.apache.hadoop.hive.accumulo.serde.AccumuloCompositeRowId;
import org.apache.hadoop.hive.accumulo.serde.DefaultAccumuloRowIdFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.log4j.Logger;

public class CompositeAccumuloRowIdFactory<T extends AccumuloCompositeRowId>
extends DefaultAccumuloRowIdFactory {
    public static final Logger log = Logger.getLogger(CompositeAccumuloRowIdFactory.class);
    private final Class<T> keyClass;
    private final Constructor<T> constructor;

    public CompositeAccumuloRowIdFactory(Class<T> keyClass) throws SecurityException, NoSuchMethodException {
        this.keyClass = keyClass;
        this.constructor = keyClass.getDeclaredConstructor(LazySimpleStructObjectInspector.class, Properties.class, Configuration.class);
    }

    @Override
    public void addDependencyJars(Configuration jobConf) throws IOException {
        Utils.addDependencyJars(jobConf, this.keyClass);
    }

    public T createRowId(ObjectInspector inspector) throws SerDeException {
        try {
            return (T)((Object)((AccumuloCompositeRowId)((Object)this.constructor.newInstance(inspector, this.properties, this.accumuloSerDeParams.getConf()))));
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }
}

