/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableInputFormat;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.lazy.LazyDouble;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyFloat;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveChar;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveVarchar;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestHiveAccumuloTypes {
    @Rule
    public TestName test = new TestName();

    @Test
    public void testBinaryTypes() throws Exception {
        String tableName = this.test.getMethodName();
        String user = "root";
        String pass = "";
        MockInstance mockInstance = new MockInstance(this.test.getMethodName());
        Connector conn = mockInstance.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableInputFormat inputformat = new HiveAccumuloTableInputFormat();
        JobConf conf = new JobConf();
        conf.set("accumulo.table.name", tableName);
        conf.set("accumulo.mock.instance", "true");
        conf.set("accumulo.instance.name", this.test.getMethodName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.set("accumulo.zookeepers", "localhost:2181");
        conf.set("accumulo.columns.mapping", ":rowID,cf:string,cf:boolean,cf:tinyint,cf:smallint,cf:int,cf:bigint,cf:float,cf:double,cf:decimal,cf:date,cf:timestamp,cf:char,cf:varchar");
        conf.set("columns", "string,string,boolean,tinyint,smallint,int,bigint,float,double,decimal,date,timestamp,char(4),varchar(7)");
        conf.set("columns.types", "string,string,boolean,tinyint,smallint,int,bigint,float,double,decimal,date,timestamp,char(4),varchar(7)");
        conf.set("accumulo.default.storage", "binary");
        conn.tableOperations().create(tableName);
        BatchWriterConfig writerConf = new BatchWriterConfig();
        BatchWriter writer = conn.createBatchWriter(tableName, writerConf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        String cf = "cf";
        byte[] cfBytes = cf.getBytes();
        Mutation m = new Mutation((CharSequence)"row1");
        String stringValue = "string";
        JavaStringObjectInspector stringOI = (JavaStringObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)stringOI.create(stringValue), (PrimitiveObjectInspector)stringOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "string".getBytes(), baos.toByteArray());
        boolean booleanValue = true;
        baos.reset();
        JavaBooleanObjectInspector booleanOI = (JavaBooleanObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)booleanOI.create(booleanValue), (PrimitiveObjectInspector)booleanOI);
        m.put(cfBytes, "boolean".getBytes(), baos.toByteArray());
        byte tinyintValue = -127;
        baos.reset();
        JavaByteObjectInspector byteOI = (JavaByteObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)tinyintValue, (PrimitiveObjectInspector)byteOI);
        m.put(cfBytes, "tinyint".getBytes(), baos.toByteArray());
        short smallintValue = Short.MAX_VALUE;
        baos.reset();
        JavaShortObjectInspector shortOI = (JavaShortObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)smallintValue, (PrimitiveObjectInspector)shortOI);
        m.put(cfBytes, "smallint".getBytes(), baos.toByteArray());
        int intValue = Integer.MAX_VALUE;
        baos.reset();
        JavaIntObjectInspector intOI = (JavaIntObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)intValue, (PrimitiveObjectInspector)intOI);
        m.put(cfBytes, "int".getBytes(), baos.toByteArray());
        long bigintValue = Long.MAX_VALUE;
        baos.reset();
        JavaLongObjectInspector longOI = (JavaLongObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)bigintValue, (PrimitiveObjectInspector)longOI);
        m.put(cfBytes, "bigint".getBytes(), baos.toByteArray());
        float floatValue = Float.MAX_VALUE;
        baos.reset();
        JavaFloatObjectInspector floatOI = (JavaFloatObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)Float.valueOf(floatValue), (PrimitiveObjectInspector)floatOI);
        m.put(cfBytes, "float".getBytes(), baos.toByteArray());
        double doubleValue = Double.MAX_VALUE;
        baos.reset();
        JavaDoubleObjectInspector doubleOI = (JavaDoubleObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        LazyUtils.writePrimitive((OutputStream)baos, (Object)doubleValue, (PrimitiveObjectInspector)doubleOI);
        m.put(cfBytes, "double".getBytes(), baos.toByteArray());
        baos.reset();
        HiveDecimal decimalValue = HiveDecimal.create((long)65536L);
        HiveDecimalWritable decimalWritable = new HiveDecimalWritable(decimalValue);
        decimalWritable.write((DataOutput)out);
        m.put(cfBytes, "decimal".getBytes(), baos.toByteArray());
        baos.reset();
        Date now = new Date(System.currentTimeMillis());
        DateWritable dateWritable = new DateWritable(now);
        Date dateValue = dateWritable.get();
        dateWritable.write((DataOutput)out);
        m.put(cfBytes, "date".getBytes(), baos.toByteArray());
        baos.reset();
        Timestamp timestampValue = new Timestamp(now.getTime());
        ByteStream.Output output = new ByteStream.Output();
        TimestampWritable timestampWritable = new TimestampWritable(new Timestamp(now.getTime()));
        timestampWritable.write((OutputStream)output);
        output.close();
        m.put(cfBytes, "timestamp".getBytes(), output.toByteArray());
        baos.reset();
        HiveChar charValue = new HiveChar("char", 4);
        JavaHiveCharObjectInspector charOI = (JavaHiveCharObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new CharTypeInfo(4));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)charOI.create(charValue), (PrimitiveObjectInspector)charOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "char".getBytes(), baos.toByteArray());
        baos.reset();
        HiveVarchar varcharValue = new HiveVarchar("varchar", 7);
        JavaHiveVarcharObjectInspector varcharOI = (JavaHiveVarcharObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(7));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)varcharOI.create(varcharValue), (PrimitiveObjectInspector)varcharOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "varchar".getBytes(), baos.toByteArray());
        writer.addMutation(m);
        writer.close();
        for (Map.Entry e : conn.createScanner(tableName, new Authorizations())) {
            System.out.println(e);
        }
        FileInputFormat.addInputPath((JobConf)conf, (Path)new Path("unused"));
        InputSplit[] splits = inputformat.getSplits(conf, 0);
        Assert.assertEquals((long)splits.length, (long)1L);
        RecordReader reader = inputformat.getRecordReader(splits[0], conf, null);
        Text key = (Text)reader.createKey();
        AccumuloHiveRow value = (AccumuloHiveRow)reader.createValue();
        reader.next((Object)key, (Object)value);
        Assert.assertEquals((long)13L, (long)value.getTuples().size());
        ByteArrayRef byteRef = new ByteArrayRef();
        Text cfText = new Text(cf);
        Text cqHolder = new Text();
        cqHolder.set("string");
        byte[] valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyStringObjectInspector lazyStringOI = LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector((boolean)false, (byte)0);
        LazyString lazyString = (LazyString)LazyFactory.createLazyObject((ObjectInspector)lazyStringOI);
        lazyString.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)stringValue, (Object)((Text)lazyString.getWritableObject()).toString());
        cqHolder.set("boolean");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyBooleanObjectInspector lazyBooleanOI = (LazyBooleanObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        LazyBoolean lazyBoolean = (LazyBoolean)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyBooleanOI);
        lazyBoolean.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)booleanValue, (Object)((BooleanWritable)lazyBoolean.getWritableObject()).get());
        cqHolder.set("tinyint");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyByteObjectInspector lazyByteOI = (LazyByteObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint"));
        LazyByte lazyByte = (LazyByte)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyByteOI);
        lazyByte.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)tinyintValue, (long)((ByteWritable)lazyByte.getWritableObject()).get());
        cqHolder.set("smallint");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyShortObjectInspector lazyShortOI = (LazyShortObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"));
        LazyShort lazyShort = (LazyShort)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyShortOI);
        lazyShort.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)smallintValue, (long)((ShortWritable)lazyShort.getWritableObject()).get());
        cqHolder.set("int");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyIntObjectInspector lazyIntOI = (LazyIntObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        LazyInteger lazyInt = (LazyInteger)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyIntOI);
        lazyInt.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)intValue, (long)((IntWritable)lazyInt.getWritableObject()).get());
        cqHolder.set("bigint");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyLongObjectInspector lazyLongOI = (LazyLongObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        LazyLong lazyLong = (LazyLong)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyLongOI);
        lazyLong.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)bigintValue, (long)((LongWritable)lazyLong.getWritableObject()).get());
        cqHolder.set("float");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyFloatObjectInspector lazyFloatOI = (LazyFloatObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        LazyFloat lazyFloat = (LazyFloat)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyFloatOI);
        lazyFloat.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((float)floatValue, (float)((FloatWritable)lazyFloat.getWritableObject()).get(), (float)0.0f);
        cqHolder.set("double");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyDoubleObjectInspector lazyDoubleOI = (LazyDoubleObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        LazyDouble lazyDouble = (LazyDouble)LazyFactory.createLazyPrimitiveBinaryClass((PrimitiveObjectInspector)lazyDoubleOI);
        lazyDouble.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((double)doubleValue, (double)((DoubleWritable)lazyDouble.getWritableObject()).get(), (double)0.0);
        cqHolder.set("decimal");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(valueBytes);
        DataInputStream in = new DataInputStream(bais);
        decimalWritable.readFields((DataInput)in);
        Assert.assertEquals((Object)decimalValue, (Object)decimalWritable.getHiveDecimal());
        cqHolder.set("date");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        bais = new ByteArrayInputStream(valueBytes);
        in = new DataInputStream(bais);
        dateWritable.readFields((DataInput)in);
        Assert.assertEquals((Object)dateValue, (Object)dateWritable.get());
        cqHolder.set("timestamp");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        bais = new ByteArrayInputStream(valueBytes);
        in = new DataInputStream(bais);
        timestampWritable.readFields((DataInput)in);
        Assert.assertEquals((Object)timestampValue, (Object)timestampWritable.getTimestamp());
        cqHolder.set("char");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyHiveCharObjectInspector lazyCharOI = (LazyHiveCharObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)new CharTypeInfo(4));
        LazyHiveChar lazyChar = (LazyHiveChar)LazyFactory.createLazyObject((ObjectInspector)lazyCharOI);
        lazyChar.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)charValue, (Object)((HiveCharWritable)lazyChar.getWritableObject()).getHiveChar());
        cqHolder.set("varchar");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyHiveVarcharObjectInspector lazyVarcharOI = (LazyHiveVarcharObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(7));
        LazyHiveVarchar lazyVarchar = (LazyHiveVarchar)LazyFactory.createLazyObject((ObjectInspector)lazyVarcharOI);
        lazyVarchar.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)varcharValue.toString(), (Object)((HiveVarcharWritable)lazyVarchar.getWritableObject()).getHiveVarchar().toString());
    }

    @Test
    public void testUtf8Types() throws Exception {
        String tableName = this.test.getMethodName();
        String user = "root";
        String pass = "";
        MockInstance mockInstance = new MockInstance(this.test.getMethodName());
        Connector conn = mockInstance.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableInputFormat inputformat = new HiveAccumuloTableInputFormat();
        JobConf conf = new JobConf();
        conf.set("accumulo.table.name", tableName);
        conf.set("accumulo.mock.instance", "true");
        conf.set("accumulo.instance.name", this.test.getMethodName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.set("accumulo.zookeepers", "localhost:2181");
        conf.set("accumulo.columns.mapping", ":rowID,cf:string,cf:boolean,cf:tinyint,cf:smallint,cf:int,cf:bigint,cf:float,cf:double,cf:decimal,cf:date,cf:timestamp,cf:char,cf:varchar");
        conf.set("columns", "string,string,boolean,tinyint,smallint,int,bigint,float,double,decimal,date,timestamp,char(4),varchar(7)");
        conf.set("columns.types", "string,string,boolean,tinyint,smallint,int,bigint,float,double,decimal,date,timestamp,char(4),varchar(7)");
        conn.tableOperations().create(tableName);
        BatchWriterConfig writerConf = new BatchWriterConfig();
        BatchWriter writer = conn.createBatchWriter(tableName, writerConf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String cf = "cf";
        byte[] cfBytes = cf.getBytes();
        ByteArrayRef byteRef = new ByteArrayRef();
        Mutation m = new Mutation((CharSequence)"row1");
        String stringValue = "string";
        baos.reset();
        JavaStringObjectInspector stringOI = (JavaStringObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)stringOI.create(stringValue), (PrimitiveObjectInspector)stringOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "string".getBytes(), baos.toByteArray());
        boolean booleanValue = true;
        baos.reset();
        JavaBooleanObjectInspector booleanOI = (JavaBooleanObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)booleanOI.create(booleanValue), (PrimitiveObjectInspector)booleanOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "boolean".getBytes(), baos.toByteArray());
        byte tinyintValue = -127;
        baos.reset();
        JavaByteObjectInspector byteOI = (JavaByteObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)tinyintValue, (PrimitiveObjectInspector)byteOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "tinyint".getBytes(), baos.toByteArray());
        short smallintValue = Short.MAX_VALUE;
        baos.reset();
        JavaShortObjectInspector shortOI = (JavaShortObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)smallintValue, (PrimitiveObjectInspector)shortOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "smallint".getBytes(), baos.toByteArray());
        int intValue = Integer.MAX_VALUE;
        baos.reset();
        JavaIntObjectInspector intOI = (JavaIntObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)intValue, (PrimitiveObjectInspector)intOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "int".getBytes(), baos.toByteArray());
        long bigintValue = Long.MAX_VALUE;
        baos.reset();
        JavaLongObjectInspector longOI = (JavaLongObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)bigintValue, (PrimitiveObjectInspector)longOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "bigint".getBytes(), baos.toByteArray());
        float floatValue = Float.MAX_VALUE;
        baos.reset();
        JavaFloatObjectInspector floatOI = (JavaFloatObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)Float.valueOf(floatValue), (PrimitiveObjectInspector)floatOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "float".getBytes(), baos.toByteArray());
        double doubleValue = Double.MAX_VALUE;
        baos.reset();
        JavaDoubleObjectInspector doubleOI = (JavaDoubleObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)doubleValue, (PrimitiveObjectInspector)doubleOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "double".getBytes(), baos.toByteArray());
        HiveDecimal decimalValue = HiveDecimal.create((String)"1.23");
        baos.reset();
        JavaHiveDecimalObjectInspector decimalOI = (JavaHiveDecimalObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(5, 2));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)decimalOI.create(decimalValue), (PrimitiveObjectInspector)decimalOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "decimal".getBytes(), baos.toByteArray());
        Date now = new Date(System.currentTimeMillis());
        DateWritable dateWritable = new DateWritable(now);
        Date dateValue = dateWritable.get();
        baos.reset();
        JavaDateObjectInspector dateOI = (JavaDateObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"date"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)dateOI.create(dateValue), (PrimitiveObjectInspector)dateOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "date".getBytes(), baos.toByteArray());
        Timestamp timestampValue = new Timestamp(now.getTime());
        baos.reset();
        JavaTimestampObjectInspector timestampOI = (JavaTimestampObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp"));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)timestampOI.create(timestampValue), (PrimitiveObjectInspector)timestampOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "timestamp".getBytes(), baos.toByteArray());
        baos.reset();
        HiveChar charValue = new HiveChar("char", 4);
        JavaHiveCharObjectInspector charOI = (JavaHiveCharObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new CharTypeInfo(4));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)charOI.create(charValue), (PrimitiveObjectInspector)charOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "char".getBytes(), baos.toByteArray());
        baos.reset();
        HiveVarchar varcharValue = new HiveVarchar("varchar", 7);
        JavaHiveVarcharObjectInspector varcharOI = (JavaHiveVarcharObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(7));
        LazyUtils.writePrimitiveUTF8((OutputStream)baos, (Object)varcharOI.create(varcharValue), (PrimitiveObjectInspector)varcharOI, (boolean)false, (byte)0, null);
        m.put(cfBytes, "varchar".getBytes(), baos.toByteArray());
        writer.addMutation(m);
        writer.close();
        for (Map.Entry e : conn.createScanner(tableName, new Authorizations())) {
            System.out.println(e);
        }
        FileInputFormat.addInputPath((JobConf)conf, (Path)new Path("unused"));
        InputSplit[] splits = inputformat.getSplits(conf, 0);
        Assert.assertEquals((long)splits.length, (long)1L);
        RecordReader reader = inputformat.getRecordReader(splits[0], conf, null);
        Text key = (Text)reader.createKey();
        AccumuloHiveRow value = (AccumuloHiveRow)reader.createValue();
        reader.next((Object)key, (Object)value);
        Assert.assertEquals((long)13L, (long)value.getTuples().size());
        Text cfText = new Text(cf);
        Text cqHolder = new Text();
        cqHolder.set("string");
        byte[] valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyStringObjectInspector lazyStringOI = LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector((boolean)false, (byte)0);
        LazyString lazyString = (LazyString)LazyFactory.createLazyObject((ObjectInspector)lazyStringOI);
        lazyString.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)new Text(stringValue), (Object)lazyString.getWritableObject());
        cqHolder.set("boolean");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyBooleanObjectInspector lazyBooleanOI = (LazyBooleanObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        LazyBoolean lazyBoolean = (LazyBoolean)LazyFactory.createLazyObject((ObjectInspector)lazyBooleanOI);
        lazyBoolean.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)booleanValue, (Object)((BooleanWritable)lazyBoolean.getWritableObject()).get());
        cqHolder.set("tinyint");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyByteObjectInspector lazyByteOI = (LazyByteObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint"));
        LazyByte lazyByte = (LazyByte)LazyFactory.createLazyObject((ObjectInspector)lazyByteOI);
        lazyByte.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)tinyintValue, (long)((ByteWritable)lazyByte.getWritableObject()).get());
        cqHolder.set("smallint");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyShortObjectInspector lazyShortOI = (LazyShortObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"));
        LazyShort lazyShort = (LazyShort)LazyFactory.createLazyObject((ObjectInspector)lazyShortOI);
        lazyShort.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)smallintValue, (long)((ShortWritable)lazyShort.getWritableObject()).get());
        cqHolder.set("int");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyIntObjectInspector lazyIntOI = (LazyIntObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        LazyInteger lazyInt = (LazyInteger)LazyFactory.createLazyObject((ObjectInspector)lazyIntOI);
        lazyInt.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)intValue, (long)((IntWritable)lazyInt.getWritableObject()).get());
        cqHolder.set("bigint");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyLongObjectInspector lazyLongOI = (LazyLongObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        LazyLong lazyLong = (LazyLong)LazyFactory.createLazyObject((ObjectInspector)lazyLongOI);
        lazyLong.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((long)bigintValue, (long)((LongWritable)lazyLong.getWritableObject()).get());
        cqHolder.set("float");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyFloatObjectInspector lazyFloatOI = (LazyFloatObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        LazyFloat lazyFloat = (LazyFloat)LazyFactory.createLazyObject((ObjectInspector)lazyFloatOI);
        lazyFloat.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((float)floatValue, (float)((FloatWritable)lazyFloat.getWritableObject()).get(), (float)0.0f);
        cqHolder.set("double");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyDoubleObjectInspector lazyDoubleOI = (LazyDoubleObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        LazyDouble lazyDouble = (LazyDouble)LazyFactory.createLazyObject((ObjectInspector)lazyDoubleOI);
        lazyDouble.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((double)doubleValue, (double)((DoubleWritable)lazyDouble.getWritableObject()).get(), (double)0.0);
        cqHolder.set("decimal");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyHiveDecimalObjectInspector lazyDecimalOI = (LazyHiveDecimalObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(5, 2));
        LazyHiveDecimal lazyDecimal = (LazyHiveDecimal)LazyFactory.createLazyObject((ObjectInspector)lazyDecimalOI);
        lazyDecimal.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)decimalValue, (Object)lazyDecimal.getWritableObject().getHiveDecimal());
        cqHolder.set("date");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyDateObjectInspector lazyDateOI = (LazyDateObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"date"));
        LazyDate lazyDate = (LazyDate)LazyFactory.createLazyObject((ObjectInspector)lazyDateOI);
        lazyDate.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)dateValue, (Object)((DateWritable)lazyDate.getWritableObject()).get());
        cqHolder.set("timestamp");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyTimestampObjectInspector lazyTimestampOI = (LazyTimestampObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp"));
        LazyTimestamp lazyTimestamp = (LazyTimestamp)LazyFactory.createLazyObject((ObjectInspector)lazyTimestampOI);
        lazyTimestamp.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)timestampValue, (Object)lazyTimestamp.getWritableObject().getTimestamp());
        cqHolder.set("char");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyHiveCharObjectInspector lazyCharOI = (LazyHiveCharObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)new CharTypeInfo(4));
        LazyHiveChar lazyChar = (LazyHiveChar)LazyFactory.createLazyObject((ObjectInspector)lazyCharOI);
        lazyChar.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)charValue, (Object)((HiveCharWritable)lazyChar.getWritableObject()).getHiveChar());
        cqHolder.set("varchar");
        valueBytes = value.getValue(cfText, cqHolder);
        Assert.assertNotNull((Object)valueBytes);
        byteRef.setData(valueBytes);
        LazyHiveVarcharObjectInspector lazyVarcharOI = (LazyHiveVarcharObjectInspector)LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(7));
        LazyHiveVarchar lazyVarchar = (LazyHiveVarchar)LazyFactory.createLazyObject((ObjectInspector)lazyVarcharOI);
        lazyVarchar.init(byteRef, 0, valueBytes.length);
        Assert.assertEquals((Object)varcharValue.toString(), (Object)((HiveVarcharWritable)lazyVarchar.getWritableObject()).getHiveVarchar().toString());
    }
}

