/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapred.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapred.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.mapred.RangeInputSplit;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloRecordReader;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloSplit;
import org.apache.hadoop.hive.accumulo.predicate.AccumuloPredicateHandler;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAccumuloTableInputFormat
implements InputFormat<Text, AccumuloHiveRow> {
    private static final Logger log = LoggerFactory.getLogger(HiveAccumuloTableInputFormat.class);
    protected AccumuloRowInputFormat accumuloInputFormat = new AccumuloRowInputFormat();
    protected AccumuloPredicateHandler predicateHandler = AccumuloPredicateHandler.getInstance();

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        ColumnMapper columnMapper;
        AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)jobConf);
        Instance instance = accumuloParams.getInstance();
        try {
            columnMapper = this.getColumnMapper((Configuration)jobConf);
        }
        catch (TooManyAccumuloColumnsException e) {
            throw new IOException((Throwable)((Object)e));
        }
        JobContext context = ShimLoader.getHadoopShims().newJobContext(Job.getInstance((Configuration)jobConf));
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)context);
        try {
            Connector connector = accumuloParams.getConnector(instance);
            List<ColumnMapping> columnMappings = columnMapper.getColumnMappings();
            List<IteratorSetting> iterators = this.predicateHandler.getIterators((Configuration)jobConf, columnMapper);
            List<Range> ranges = this.predicateHandler.getRanges((Configuration)jobConf, columnMapper);
            if (null != ranges && ranges.isEmpty()) {
                return new InputSplit[0];
            }
            this.configure(jobConf, instance, connector, accumuloParams, columnMapper, iterators, ranges);
            int numColumns = columnMappings.size();
            List readColIds = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
            if (numColumns < readColIds.size()) {
                throw new IOException("Number of column mappings (" + numColumns + ")" + " numbers less than the hive table columns. (" + readColIds.size() + ")");
            }
            InputSplit[] splits = this.accumuloInputFormat.getSplits(jobConf, numSplits);
            InputSplit[] hiveSplits = new HiveAccumuloSplit[splits.length];
            for (int i = 0; i < splits.length; ++i) {
                RangeInputSplit ris = (RangeInputSplit)splits[i];
                hiveSplits[i] = new HiveAccumuloSplit(ris, tablePaths[0]);
            }
            return hiveSplits;
        }
        catch (AccumuloException e) {
            log.error("Could not configure AccumuloInputFormat", (Throwable)e);
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        catch (AccumuloSecurityException e) {
            log.error("Could not configure AccumuloInputFormat", (Throwable)e);
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        catch (SerDeException e) {
            log.error("Could not configure AccumuloInputFormat", (Throwable)e);
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    public RecordReader<Text, AccumuloHiveRow> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        ColumnMapper columnMapper;
        try {
            columnMapper = this.getColumnMapper((Configuration)jobConf);
        }
        catch (TooManyAccumuloColumnsException e) {
            throw new IOException((Throwable)((Object)e));
        }
        try {
            List<IteratorSetting> iterators = this.predicateHandler.getIterators((Configuration)jobConf, columnMapper);
            HiveAccumuloSplit hiveSplit = (HiveAccumuloSplit)inputSplit;
            RangeInputSplit rangeSplit = hiveSplit.getSplit();
            log.info("Split: " + rangeSplit);
            if (null == rangeSplit.getIterators() || rangeSplit.getIterators().isEmpty() && !iterators.isEmpty()) {
                log.debug("Re-setting iterators on InputSplit due to Accumulo bug.");
                rangeSplit.setIterators(iterators);
            }
            if (null == this.getTableName(rangeSplit)) {
                AccumuloConnectionParameters accumuloParams = new AccumuloConnectionParameters((Configuration)jobConf);
                log.debug("Re-setting table name on InputSplit due to Accumulo bug.");
                this.setTableName(rangeSplit, accumuloParams.getAccumuloTableName());
            }
            RecordReader recordReader = this.accumuloInputFormat.getRecordReader((InputSplit)rangeSplit, jobConf, reporter);
            return new HiveAccumuloRecordReader((RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>>)recordReader, iterators.size());
        }
        catch (SerDeException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    protected ColumnMapper getColumnMapper(Configuration conf) throws IOException, TooManyAccumuloColumnsException {
        String defaultStorageType = conf.get("accumulo.default.storage");
        String[] columnNamesArr = conf.getStrings("columns");
        if (null == columnNamesArr) {
            throw new IOException("Hive column names must be provided to InputFormat in the Configuration");
        }
        List<String> columnNames = Arrays.asList(columnNamesArr);
        String serializedTypes = conf.get("columns.types");
        if (null == serializedTypes) {
            throw new IOException("Hive column types must be provided to InputFormat in the Configuration");
        }
        ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)serializedTypes);
        return new ColumnMapper(conf.get("accumulo.columns.mapping"), defaultStorageType, columnNames, columnTypes);
    }

    protected void configure(JobConf conf, Instance instance, Connector connector, AccumuloConnectionParameters accumuloParams, ColumnMapper columnMapper, List<IteratorSetting> iterators, Collection<Range> ranges) throws AccumuloSecurityException, AccumuloException, SerDeException {
        HashSet<Pair<Text, Text>> pairs;
        if (instance instanceof MockInstance) {
            this.setMockInstance(conf, instance.getInstanceName());
        } else {
            this.setZooKeeperInstance(conf, instance.getInstanceName(), instance.getZooKeepers());
        }
        this.setConnectorInfo(conf, accumuloParams.getAccumuloUserName(), (AuthenticationToken)new PasswordToken((CharSequence)accumuloParams.getAccumuloPassword()));
        this.setInputTableName(conf, accumuloParams.getAccumuloTableName());
        Authorizations auths = AccumuloSerDeParameters.getAuthorizationsFromConf((Configuration)conf);
        if (null == auths) {
            auths = connector.securityOperations().getUserAuthorizations(accumuloParams.getAccumuloUserName());
        }
        this.setScanAuthorizations(conf, auths);
        this.addIterators(conf, iterators);
        if (null != ranges) {
            log.info("Setting ranges: " + ranges);
            this.setRanges(conf, ranges);
        }
        if (null != (pairs = this.getPairCollection(columnMapper.getColumnMappings())) && !pairs.isEmpty()) {
            this.fetchColumns(conf, pairs);
        }
    }

    protected void setMockInstance(JobConf conf, String instanceName) {
        try {
            AccumuloInputFormat.setMockInstance((JobConf)conf, (String)instanceName);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring exception setting mock instance of " + instanceName, (Throwable)e);
        }
    }

    protected void setZooKeeperInstance(JobConf conf, String instanceName, String zkHosts) {
        try {
            AccumuloInputFormat.setZooKeeperInstance((JobConf)conf, (String)instanceName, (String)zkHosts);
        }
        catch (IllegalStateException ise) {
            log.debug("Ignoring exception setting ZooKeeper instance of " + instanceName + " at " + zkHosts, (Throwable)ise);
        }
    }

    protected void setConnectorInfo(JobConf conf, String user, AuthenticationToken token) throws AccumuloSecurityException {
        try {
            AccumuloInputFormat.setConnectorInfo((JobConf)conf, (String)user, (AuthenticationToken)token);
        }
        catch (IllegalStateException e) {
            log.debug("Ignoring exception setting Accumulo Connector instance for user " + user, (Throwable)e);
        }
    }

    protected void setInputTableName(JobConf conf, String tableName) {
        AccumuloInputFormat.setInputTableName((JobConf)conf, (String)tableName);
    }

    protected void setScanAuthorizations(JobConf conf, Authorizations auths) {
        AccumuloInputFormat.setScanAuthorizations((JobConf)conf, (Authorizations)auths);
    }

    protected void addIterators(JobConf conf, List<IteratorSetting> iterators) {
        for (IteratorSetting is : iterators) {
            AccumuloInputFormat.addIterator((JobConf)conf, (IteratorSetting)is);
        }
    }

    protected void setRanges(JobConf conf, Collection<Range> ranges) {
        AccumuloInputFormat.setRanges((JobConf)conf, ranges);
    }

    protected void fetchColumns(JobConf conf, Set<Pair<Text, Text>> cfCqPairs) {
        AccumuloInputFormat.fetchColumns((JobConf)conf, cfCqPairs);
    }

    protected HashSet<Pair<Text, Text>> getPairCollection(List<ColumnMapping> columnMappings) {
        HashSet<Pair<Text, Text>> pairs = new HashSet<Pair<Text, Text>>();
        for (ColumnMapping columnMapping : columnMappings) {
            if (columnMapping instanceof HiveAccumuloColumnMapping) {
                HiveAccumuloColumnMapping accumuloColumnMapping = (HiveAccumuloColumnMapping)columnMapping;
                Text cf = new Text(accumuloColumnMapping.getColumnFamily());
                Text cq = null;
                if (null != accumuloColumnMapping.getColumnQualifier()) {
                    cq = new Text(accumuloColumnMapping.getColumnQualifier());
                }
                pairs.add((Pair<Text, Text>)new Pair((Object)cf, (Object)cq));
                continue;
            }
            if (!(columnMapping instanceof HiveAccumuloMapColumnMapping)) continue;
            HiveAccumuloMapColumnMapping mapMapping = (HiveAccumuloMapColumnMapping)columnMapping;
            pairs.add((Pair<Text, Text>)new Pair((Object)new Text(mapMapping.getColumnFamily()), null));
        }
        log.info("Computed columns to fetch (" + pairs + ") from " + columnMappings);
        return pairs;
    }

    protected String getTableName(RangeInputSplit split) throws IOException {
        Method getTable;
        Method getTableName = null;
        try {
            getTableName = RangeInputSplit.class.getMethod("getTableName", new Class[0]);
        }
        catch (SecurityException e) {
            log.debug("Could not get getTableName method from RangeInputSplit", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.debug("Could not get getTableName method from RangeInputSplit", (Throwable)e);
        }
        if (null != getTableName) {
            try {
                return (String)getTableName.invoke((Object)split, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                log.debug("Could not invoke getTableName method from RangeInputSplit", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.debug("Could not invoke getTableName method from RangeInputSplit", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.debug("Could not invoke getTableName method from RangeInputSplit", (Throwable)e);
            }
        }
        try {
            getTable = RangeInputSplit.class.getMethod("getTable", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IOException("Could not get table name from RangeInputSplit", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Could not get table name from RangeInputSplit", e);
        }
        try {
            return (String)getTable.invoke((Object)split, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Could not get table name from RangeInputSplit", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Could not get table name from RangeInputSplit", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Could not get table name from RangeInputSplit", e);
        }
    }

    protected void setTableName(RangeInputSplit split, String tableName) throws IOException {
        Method setTable;
        Method setTableName = null;
        try {
            setTableName = RangeInputSplit.class.getMethod("setTableName", String.class);
        }
        catch (SecurityException e) {
            log.debug("Could not get getTableName method from RangeInputSplit", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.debug("Could not get getTableName method from RangeInputSplit", (Throwable)e);
        }
        if (null != setTableName) {
            try {
                setTableName.invoke((Object)split, tableName);
                return;
            }
            catch (IllegalArgumentException e) {
                log.debug("Could not invoke getTableName method from RangeInputSplit", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.debug("Could not invoke getTableName method from RangeInputSplit", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.debug("Could not invoke getTableName method from RangeInputSplit", (Throwable)e);
            }
        }
        try {
            setTable = RangeInputSplit.class.getMethod("setTable", String.class);
        }
        catch (SecurityException e) {
            throw new IOException("Could not set table name from RangeInputSplit", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Could not set table name from RangeInputSplit", e);
        }
        try {
            setTable.invoke((Object)split, tableName);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Could not set table name from RangeInputSplit", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Could not set table name from RangeInputSplit", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Could not set table name from RangeInputSplit", e);
        }
    }
}

