/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.LazyAccumuloMap;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class LazyAccumuloRow
extends LazyStruct {
    private static final Logger log = Logger.getLogger(LazyAccumuloRow.class);
    private AccumuloHiveRow row;
    private List<ColumnMapping> columnMappings;
    private ArrayList<Object> cachedList = new ArrayList();
    private AccumuloRowIdFactory rowIdFactory;

    public LazyAccumuloRow(LazySimpleStructObjectInspector inspector) {
        super(inspector);
    }

    public void init(AccumuloHiveRow hiveRow, List<ColumnMapping> columnMappings, AccumuloRowIdFactory rowIdFactory) {
        this.row = hiveRow;
        this.columnMappings = columnMappings;
        this.rowIdFactory = rowIdFactory;
        this.setParsed(false);
    }

    private void parse() {
        if (this.getFields() == null) {
            this.initLazyFields(((LazySimpleStructObjectInspector)this.oi).getAllStructFieldRefs());
        }
        if (!this.getParsed()) {
            Arrays.fill(this.getFieldInited(), false);
            this.setParsed(true);
        }
    }

    public Object getField(int id) {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.uncheckedGetField(id);
    }

    private Object uncheckedGetField(int id) {
        if (!this.getFieldInited()[id]) {
            ColumnMapping columnMapping = this.columnMappings.get(id);
            if (columnMapping instanceof HiveAccumuloMapColumnMapping) {
                HiveAccumuloMapColumnMapping mapColumnMapping = (HiveAccumuloMapColumnMapping)columnMapping;
                LazyAccumuloMap map = (LazyAccumuloMap)this.getFields()[id];
                map.init(this.row, mapColumnMapping);
            } else {
                ByteArrayRef ref;
                if (columnMapping instanceof HiveAccumuloRowIdColumnMapping) {
                    ref = new ByteArrayRef();
                    ref.setData(this.row.getRowId().getBytes());
                } else if (columnMapping instanceof HiveAccumuloColumnMapping) {
                    HiveAccumuloColumnMapping accumuloColumnMapping = (HiveAccumuloColumnMapping)columnMapping;
                    byte[] val = this.row.getValue(new Text(accumuloColumnMapping.getColumnFamily()), new Text(accumuloColumnMapping.getColumnQualifier()));
                    if (val == null) {
                        return null;
                    }
                    ref = new ByteArrayRef();
                    ref.setData(val);
                } else {
                    log.error((Object)("Could not process ColumnMapping of type " + columnMapping.getClass() + " at offset " + id + " in column mapping: " + columnMapping.getMappingSpec()));
                    throw new IllegalArgumentException("Cannot process ColumnMapping of type " + columnMapping.getClass());
                }
                this.getFields()[id].init(ref, 0, ref.getData().length);
            }
            this.getFieldInited()[id] = true;
        }
        return this.getFields()[id].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.getParsed()) {
            this.parse();
        }
        this.cachedList.clear();
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    protected LazyObjectBase createLazyField(int fieldID, StructField fieldRef) throws SerDeException {
        ColumnMapping columnMapping = this.columnMappings.get(fieldID);
        if (columnMapping instanceof HiveAccumuloRowIdColumnMapping) {
            return this.rowIdFactory.createRowId(fieldRef.getFieldObjectInspector());
        }
        if (columnMapping instanceof HiveAccumuloMapColumnMapping) {
            return new LazyAccumuloMap((LazyMapObjectInspector)fieldRef.getFieldObjectInspector());
        }
        return LazyFactory.createLazyObject((ObjectInspector)fieldRef.getFieldObjectInspector(), (ColumnEncoding.BINARY == columnMapping.getEncoding() ? 1 : 0) != 0);
    }
}

