/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.hadoop.conf.Configuration;

public class AccumuloConnectionParameters {
    public static final String USER_NAME = "accumulo.user.name";
    public static final String USER_PASS = "accumulo.user.pass";
    public static final String ZOOKEEPERS = "accumulo.zookeepers";
    public static final String INSTANCE_NAME = "accumulo.instance.name";
    public static final String TABLE_NAME = "accumulo.table.name";
    public static final String USE_MOCK_INSTANCE = "accumulo.mock.instance";
    protected Configuration conf;
    protected boolean useMockInstance = false;

    public AccumuloConnectionParameters(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getAccumuloUserName() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(USER_NAME);
    }

    public String getAccumuloPassword() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(USER_PASS);
    }

    public String getAccumuloInstanceName() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(INSTANCE_NAME);
    }

    public String getZooKeepers() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(ZOOKEEPERS);
    }

    public String getAccumuloTableName() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.get(TABLE_NAME);
    }

    public boolean useMockInstance() {
        Preconditions.checkNotNull((Object)this.conf);
        return this.conf.getBoolean(USE_MOCK_INSTANCE, false);
    }

    public Instance getInstance() {
        String instanceName = this.getAccumuloInstanceName();
        if (null == instanceName) {
            throw new IllegalArgumentException("Accumulo instance name must be provided in hiveconf using accumulo.instance.name");
        }
        if (this.useMockInstance()) {
            return new MockInstance(instanceName);
        }
        String zookeepers = this.getZooKeepers();
        if (null == zookeepers) {
            throw new IllegalArgumentException("ZooKeeper quorum string must be provided in hiveconf using accumulo.zookeepers");
        }
        return new ZooKeeperInstance(instanceName, zookeepers);
    }

    public Connector getConnector() throws AccumuloException, AccumuloSecurityException {
        Instance inst = this.getInstance();
        return this.getConnector(inst);
    }

    public Connector getConnector(Instance inst) throws AccumuloException, AccumuloSecurityException {
        String username = this.getAccumuloUserName();
        String password = this.getAccumuloPassword();
        if (null == username) {
            throw new IllegalArgumentException("Accumulo user name must be provided in hiveconf using accumulo.user.name");
        }
        if (null == password) {
            throw new IllegalArgumentException("Accumulo password must be provided in hiveconf using accumulo.user.pass");
        }
        return inst.getConnector(username, (AuthenticationToken)new PasswordToken((CharSequence)password));
    }
}

