/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.mr.HiveAccumuloTableOutputFormat;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowSerializer;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public class TestHiveAccumuloTableOutputFormat {
    protected JobConf conf;
    protected String user = "root";
    protected String password = "password";
    protected String instanceName = "instance";
    protected String zookeepers = "host1:2181,host2:2181,host3:2181";
    protected String outputTable = "output";
    @Rule
    public TestName test = new TestName();

    @Before
    public void setup() throws IOException {
        this.conf = new JobConf();
        this.conf.set("accumulo.user.name", this.user);
        this.conf.set("accumulo.user.pass", this.password);
        this.conf.set("accumulo.instance.name", this.instanceName);
        this.conf.set("accumulo.zookeepers", this.zookeepers);
        this.conf.set("accumulo.table.name", this.outputTable);
    }

    @Test
    public void testBasicConfiguration() throws IOException, AccumuloSecurityException {
        HiveAccumuloTableOutputFormat outputFormat = (HiveAccumuloTableOutputFormat)Mockito.mock(HiveAccumuloTableOutputFormat.class);
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).configureAccumuloOutputFormat(this.conf);
        outputFormat.configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setAccumuloConnectorInfo(this.conf, this.user, (AuthenticationToken)new PasswordToken((CharSequence)this.password));
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setAccumuloZooKeeperInstance(this.conf, this.instanceName, this.zookeepers);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setDefaultAccumuloTableName(this.conf, this.outputTable);
    }

    @Test
    public void testMockInstance() throws IOException, AccumuloSecurityException {
        HiveAccumuloTableOutputFormat outputFormat = (HiveAccumuloTableOutputFormat)Mockito.mock(HiveAccumuloTableOutputFormat.class);
        this.conf.setBoolean("accumulo.mock.instance", true);
        this.conf.unset("accumulo.zookeepers");
        ((HiveAccumuloTableOutputFormat)Mockito.doCallRealMethod().when((Object)outputFormat)).configureAccumuloOutputFormat(this.conf);
        outputFormat.configureAccumuloOutputFormat(this.conf);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setAccumuloConnectorInfo(this.conf, this.user, (AuthenticationToken)new PasswordToken((CharSequence)this.password));
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setAccumuloMockInstance(this.conf, this.instanceName);
        ((HiveAccumuloTableOutputFormat)Mockito.verify((Object)outputFormat)).setDefaultAccumuloTableName(this.conf, this.outputTable);
    }

    @Test
    public void testWriteToMockInstance() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1", "col2");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq1,cf:cq2");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySimpleSerDe.SerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, accumuloSerDeParams.getRowIdFactory());
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(Arrays.asList("row", "cq1", "cq2"), Arrays.asList(stringTypeInfo, stringTypeInfo, stringTypeInfo), (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row value1 value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, new Authorizations()).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }

    @Test
    public void testWriteToMockInstanceWithVisibility() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        Authorizations auths = new Authorizations(new String[]{"foo"});
        conn.securityOperations().changeUserAuthorizations("root", auths);
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1", "col2");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq1,cf:cq2");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySimpleSerDe.SerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), new ColumnVisibility("foo"), accumuloSerDeParams.getRowIdFactory());
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(Arrays.asList("row", "cq1", "cq2"), Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo), (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row value1 value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, auths).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"foo", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"foo", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }

    @Test
    public void testWriteMap() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:*");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySimpleSerDe.SerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, accumuloSerDeParams.getRowIdFactory());
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazyStringObjectInspector stringOI = (LazyStringObjectInspector)LazyFactory.createLazyObjectInspector((TypeInfo)stringTypeInfo, (byte[])new byte[]{0}, (int)0, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyMapObjectInspector mapOI = LazyObjectInspectorFactory.getLazySimpleMapObjectInspector((ObjectInspector)stringOI, (ObjectInspector)stringOI, (byte)44, (byte)58, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazySimpleStructObjectInspector structOI = LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(Arrays.asList("row", "data"), Arrays.asList(stringOI, mapOI), (byte)32, (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row cq1:value1,cq2:value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, new Authorizations()).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, (Object)k.getColumnVisibilityParsed());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, (Object)k.getColumnVisibilityParsed());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }

    @Test
    public void testBinarySerializationOnStringFallsBackToUtf8() throws Exception {
        MockInstance inst = new MockInstance(this.test.getMethodName());
        Connector conn = inst.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        HiveAccumuloTableOutputFormat outputFormat = new HiveAccumuloTableOutputFormat();
        String table = this.test.getMethodName();
        conn.tableOperations().create(table);
        JobConf conf = new JobConf();
        conf.set("accumulo.instance.name", inst.getInstanceName());
        conf.set("accumulo.user.name", "root");
        conf.set("accumulo.user.pass", "");
        conf.setBoolean("accumulo.mock.instance", true);
        conf.set("accumulo.table.name", this.test.getMethodName());
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        outputFormat.checkOutputSpecs((FileSystem)local, conf);
        RecordWriter recordWriter = outputFormat.getRecordWriter((FileSystem)local, conf, null, null);
        List<String> names = Arrays.asList("row", "col1", "col2");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo);
        Properties tableProperties = new Properties();
        tableProperties.setProperty("accumulo.columns.mapping", ":rowID,cf:cq1,cf:cq2");
        tableProperties.setProperty("field.delim", " ");
        tableProperties.setProperty("columns", Joiner.on((char)',').join(names));
        tableProperties.setProperty("columns.types", Joiner.on((char)',').join(types));
        tableProperties.setProperty("accumulo.default.storage", ColumnEncoding.BINARY.getName());
        AccumuloSerDeParameters accumuloSerDeParams = new AccumuloSerDeParameters(new Configuration(), tableProperties, AccumuloSerDe.class.getSimpleName());
        LazySimpleSerDe.SerDeParameters serDeParams = accumuloSerDeParams.getSerDeParameters();
        AccumuloRowSerializer serializer = new AccumuloRowSerializer(0, serDeParams, accumuloSerDeParams.getColumnMappings(), AccumuloSerDeParameters.DEFAULT_VISIBILITY_LABEL, accumuloSerDeParams.getRowIdFactory());
        PrimitiveTypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
        LazySimpleStructObjectInspector structOI = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(Arrays.asList("row", "cq1", "cq2"), Arrays.asList(stringTypeInfo, stringTypeInfo, stringTypeInfo), (byte[])serDeParams.getSeparators(), (Text)serDeParams.getNullSequence(), (boolean)serDeParams.isLastColumnTakesRest(), (boolean)serDeParams.isEscaped(), (byte)serDeParams.getEscapeChar());
        LazyStruct struct = (LazyStruct)LazyFactory.createLazyObject((ObjectInspector)structOI);
        ByteArrayRef bytes = new ByteArrayRef();
        bytes.setData("row value1 value2".getBytes());
        struct.init(bytes, 0, bytes.getData().length);
        Mutation m = serializer.serialize((Object)struct, (ObjectInspector)structOI);
        recordWriter.write((Object)new Text(table), (Object)m);
        recordWriter.close(null);
        Iterator iter = conn.createScanner(table, new Authorizations()).iterator();
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        Map.Entry entry = (Map.Entry)iter.next();
        Key k = (Key)entry.getKey();
        Value v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq1", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value1", (Object)new String(v.get()));
        Assert.assertTrue((String)"Iterator did not have an element as expected", (boolean)iter.hasNext());
        entry = (Map.Entry)iter.next();
        k = (Key)entry.getKey();
        v = (Value)entry.getValue();
        Assert.assertEquals((Object)"row", (Object)k.getRow().toString());
        Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
        Assert.assertEquals((Object)"cq2", (Object)k.getColumnQualifier().toString());
        Assert.assertEquals((Object)"", (Object)k.getColumnVisibility().toString());
        Assert.assertEquals((Object)"value2", (Object)new String(v.get()));
        Assert.assertFalse((String)"Iterator unexpectedly had more data", (boolean)iter.hasNext());
    }
}

