/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.serde.AccumuloCompositeRowId;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.log4j.Logger;

public class FirstCharAccumuloCompositeRowId
extends AccumuloCompositeRowId {
    private static final Logger log = Logger.getLogger(FirstCharAccumuloCompositeRowId.class);
    private Properties tbl;
    private Configuration conf;
    private byte[] bytes;
    private int start;
    private int length;
    private String bytesAsString;

    public FirstCharAccumuloCompositeRowId(LazySimpleStructObjectInspector oi, Properties tbl, Configuration conf) {
        super(oi);
        this.tbl = tbl;
        this.conf = conf;
    }

    public void init(ByteArrayRef bytes, int start, int length) {
        this.bytes = bytes.getData();
        this.start = start;
        this.length = length;
    }

    public Object getField(int fieldID) {
        if (this.bytesAsString == null) {
            this.bytesAsString = new String(this.bytes, this.start, this.length);
        }
        log.info((Object)("Data: " + this.bytesAsString + ", " + Arrays.toString(this.bytes)));
        char separator = (char)(((LazySimpleStructObjectInspector)this.oi).getSeparator() + 1);
        log.info((Object)("Separator: " + String.format("%04x", separator)));
        Object[] fieldBytes = StringUtils.split((String)this.bytesAsString, (char)separator);
        log.info((Object)("Fields: " + Arrays.toString(fieldBytes)));
        return this.toLazyObject(fieldID, new byte[]{(byte)((String)fieldBytes[fieldID]).charAt(0)});
    }
}

