/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloRowIdColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloCompositeRowId;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.CompositeAccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.DefaultAccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.TooManyAccumuloColumnsException;
import org.apache.hadoop.hive.accumulo.serde.TooManyHiveColumnsException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;

public class AccumuloSerDeParameters
extends AccumuloConnectionParameters {
    private static final Logger log = Logger.getLogger(AccumuloSerDeParameters.class);
    public static final String COLUMN_MAPPINGS = "accumulo.columns.mapping";
    public static final String ITERATOR_PUSHDOWN_KEY = "accumulo.iterator.pushdown";
    public static final boolean ITERATOR_PUSHDOWN_DEFAULT = true;
    public static final String DEFAULT_STORAGE_TYPE = "accumulo.default.storage";
    public static final String VISIBILITY_LABEL_KEY = "accumulo.visibility.label";
    public static final ColumnVisibility DEFAULT_VISIBILITY_LABEL = new ColumnVisibility();
    public static final String AUTHORIZATIONS_KEY = "accumulo.authorizations";
    public static final String COMPOSITE_ROWID_FACTORY = "accumulo.composite.rowid.factory";
    public static final String COMPOSITE_ROWID_CLASS = "accumulo.composite.rowid";
    protected final ColumnMapper columnMapper;
    private Properties tableProperties;
    private String serdeName;
    private LazySimpleSerDe.SerDeParameters lazySerDeParameters;
    private AccumuloRowIdFactory rowIdFactory;

    public AccumuloSerDeParameters(Configuration conf, Properties tableProperties, String serdeName) throws SerDeException {
        super(conf);
        this.tableProperties = tableProperties;
        this.serdeName = serdeName;
        this.lazySerDeParameters = LazySimpleSerDe.initSerdeParams((Configuration)conf, (Properties)tableProperties, (String)serdeName);
        String defaultStorage = tableProperties.getProperty(DEFAULT_STORAGE_TYPE);
        this.columnMapper = new ColumnMapper(this.getColumnMappingValue(), defaultStorage, this.lazySerDeParameters.getColumnNames(), this.lazySerDeParameters.getColumnTypes());
        log.info((Object)("Constructed column mapping " + this.columnMapper));
        if (null == this.getColumnTypeValue()) {
            tableProperties.setProperty("columns.types", this.columnMapper.getTypesString());
        }
        if (this.columnMapper.size() < this.lazySerDeParameters.getColumnNames().size()) {
            throw new TooManyHiveColumnsException("You have more accumulo.columns.mapping fields than hive columns");
        }
        if (this.columnMapper.size() > this.lazySerDeParameters.getColumnNames().size()) {
            throw new TooManyAccumuloColumnsException("You have more hive columns than fields mapped with accumulo.columns.mapping");
        }
        this.rowIdFactory = this.initRowIdFactory(conf, tableProperties);
    }

    protected AccumuloRowIdFactory initRowIdFactory(Configuration conf, Properties tbl) throws SerDeException {
        try {
            AccumuloRowIdFactory keyFactory = this.createRowIdFactory(conf, tbl);
            if (keyFactory != null) {
                keyFactory.init(this, tbl);
            }
            return keyFactory;
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    protected AccumuloRowIdFactory createRowIdFactory(Configuration job, Properties tbl) throws Exception {
        String factoryClassName = tbl.getProperty(COMPOSITE_ROWID_FACTORY);
        if (factoryClassName != null) {
            log.info((Object)("Loading CompositeRowIdFactory class " + factoryClassName));
            Class<?> factoryClazz = Class.forName(factoryClassName);
            return (AccumuloRowIdFactory)ReflectionUtils.newInstance(factoryClazz, (Configuration)job);
        }
        String keyClassName = tbl.getProperty(COMPOSITE_ROWID_CLASS);
        if (keyClassName != null) {
            log.info((Object)("Loading CompositeRowId class " + keyClassName));
            Class<?> keyClass = Class.forName(keyClassName);
            Class<AccumuloCompositeRowId> compositeRowIdClass = keyClass.asSubclass(AccumuloCompositeRowId.class);
            return new CompositeAccumuloRowIdFactory<AccumuloCompositeRowId>(compositeRowIdClass);
        }
        return new DefaultAccumuloRowIdFactory();
    }

    public LazySimpleSerDe.SerDeParameters getSerDeParameters() {
        return this.lazySerDeParameters;
    }

    public Properties getTableProperties() {
        return this.tableProperties;
    }

    public String getColumnTypeValue() {
        return this.tableProperties.getProperty("columns.types");
    }

    public String getSerDeName() {
        return this.serdeName;
    }

    public String getColumnMappingValue() {
        return this.tableProperties.getProperty(COLUMN_MAPPINGS);
    }

    public HiveAccumuloRowIdColumnMapping getRowIdColumnMapping() {
        return this.columnMapper.getRowIdMapping();
    }

    public boolean getIteratorPushdown() {
        return this.conf.getBoolean(ITERATOR_PUSHDOWN_KEY, true);
    }

    public List<String> getHiveColumnNames() {
        return Collections.unmodifiableList(this.lazySerDeParameters.getColumnNames());
    }

    public List<TypeInfo> getHiveColumnTypes() {
        return Collections.unmodifiableList(this.lazySerDeParameters.getColumnTypes());
    }

    public ColumnMapper getColumnMapper() {
        return this.columnMapper;
    }

    public int getRowIdOffset() {
        return this.columnMapper.getRowIdOffset();
    }

    public List<ColumnMapping> getColumnMappings() {
        return this.columnMapper.getColumnMappings();
    }

    public AccumuloRowIdFactory getRowIdFactory() {
        return this.rowIdFactory;
    }

    public String getRowIdHiveColumnName() {
        int rowIdOffset = this.columnMapper.getRowIdOffset();
        if (-1 == rowIdOffset) {
            return null;
        }
        List hiveColumnNames = this.lazySerDeParameters.getColumnNames();
        if (0 > rowIdOffset || hiveColumnNames.size() <= rowIdOffset) {
            throw new IllegalStateException("Tried to find rowID offset at position " + rowIdOffset + " from Hive columns " + hiveColumnNames);
        }
        return (String)hiveColumnNames.get(rowIdOffset);
    }

    public ColumnMapping getColumnMappingForHiveColumn(String hiveColumn) {
        List hiveColumnNames = this.lazySerDeParameters.getColumnNames();
        for (int offset = 0; offset < hiveColumnNames.size() && offset < this.columnMapper.size(); ++offset) {
            String hiveColumnName = (String)hiveColumnNames.get(offset);
            if (!hiveColumn.equals(hiveColumnName)) continue;
            return this.columnMapper.get(offset);
        }
        throw new NoSuchElementException("Could not find column mapping for Hive column " + hiveColumn);
    }

    public TypeInfo getTypeForHiveColumn(String hiveColumn) {
        List hiveColumnNames = this.lazySerDeParameters.getColumnNames();
        List hiveColumnTypes = this.lazySerDeParameters.getColumnTypes();
        for (int i = 0; i < hiveColumnNames.size() && i < hiveColumnTypes.size(); ++i) {
            String columnName = (String)hiveColumnNames.get(i);
            if (!hiveColumn.equals(columnName)) continue;
            return (TypeInfo)hiveColumnTypes.get(i);
        }
        throw new NoSuchElementException("Could not find Hive column type for " + hiveColumn);
    }

    public ColumnVisibility getTableVisibilityLabel() {
        String visibilityLabel = this.tableProperties.getProperty(VISIBILITY_LABEL_KEY, null);
        if (null == visibilityLabel || visibilityLabel.isEmpty()) {
            return DEFAULT_VISIBILITY_LABEL;
        }
        return new ColumnVisibility(visibilityLabel);
    }

    public Authorizations getAuthorizations() {
        String authorizationStr = this.tableProperties.getProperty(AUTHORIZATIONS_KEY, null);
        return AccumuloSerDeParameters.getAuthorizationsFromValue(authorizationStr);
    }

    protected static Authorizations getAuthorizationsFromValue(String authorizationStr) {
        if (null == authorizationStr) {
            return null;
        }
        return new Authorizations(new String[]{authorizationStr});
    }

    public static Authorizations getAuthorizationsFromConf(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        String authorizationStr = conf.get(AUTHORIZATIONS_KEY, null);
        return AccumuloSerDeParameters.getAuthorizationsFromValue(authorizationStr);
    }
}

