/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Charsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class LazyAccumuloMap
extends LazyMap {
    protected AccumuloHiveRow sourceRow;
    protected HiveAccumuloMapColumnMapping columnMapping;

    public LazyAccumuloMap(LazyMapObjectInspector oi) {
        super(oi);
    }

    public void init(AccumuloHiveRow row, HiveAccumuloMapColumnMapping columnMapping) {
        this.sourceRow = row;
        this.columnMapping = columnMapping;
        this.setParsed(false);
    }

    protected void parse() {
        if (null == this.cachedMap) {
            this.cachedMap = new LinkedHashMap();
        } else {
            this.cachedMap.clear();
        }
        LazyMapObjectInspector lazyMoi = (LazyMapObjectInspector)this.getInspector();
        Text cf = new Text(this.columnMapping.getColumnFamily());
        for (AccumuloHiveRow.ColumnTuple tuple : this.sourceRow.getTuples()) {
            String cq = tuple.getCq().toString();
            if (!cf.equals((Object)tuple.getCf()) || !cq.startsWith(this.columnMapping.getColumnQualifierPrefix())) continue;
            cq = cq.substring(this.columnMapping.getColumnQualifierPrefix().length());
            LazyPrimitive key = LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)((PrimitiveObjectInspector)lazyMoi.getMapKeyObjectInspector()), (ColumnEncoding.BINARY == this.columnMapping.getKeyEncoding() ? 1 : 0) != 0);
            ByteArrayRef keyRef = new ByteArrayRef();
            keyRef.setData(cq.getBytes(Charsets.UTF_8));
            key.init(keyRef, 0, keyRef.getData().length);
            LazyObject value = LazyFactory.createLazyObject((ObjectInspector)lazyMoi.getMapValueObjectInspector(), (ColumnEncoding.BINARY == this.columnMapping.getValueEncoding() ? 1 : 0) != 0);
            ByteArrayRef valueRef = new ByteArrayRef();
            valueRef.setData(tuple.getValue());
            value.init(valueRef, 0, valueRef.getData().length);
            this.cachedMap.put(key, value);
        }
        this.setParsed(true);
    }

    public Object getMapValueElement(Object key) {
        if (!this.getParsed()) {
            this.parse();
        }
        for (Map.Entry entry : this.cachedMap.entrySet()) {
            LazyPrimitive lazyKey = (LazyPrimitive)entry.getKey();
            Writable keyI = lazyKey.getWritableObject();
            if (keyI == null || !keyI.equals(key)) continue;
            LazyObject v = (LazyObject)entry.getValue();
            return v == null ? v : v.getObject();
        }
        return null;
    }

    public Map<Object, Object> getMap() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap;
    }

    public int getMapSize() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap.size();
    }
}

