/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.accumulo.AccumuloHiveRow;
import org.apache.hadoop.hive.accumulo.LazyAccumuloRow;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapper;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDe;
import org.apache.hadoop.hive.accumulo.serde.AccumuloSerDeParameters;
import org.apache.hadoop.hive.accumulo.serde.DefaultAccumuloRowIdFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazydio.LazyDioInteger;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyAccumuloRow {
    @Test
    public void testExpectedDeserializationOfColumns() throws Exception {
        List<String> columns = Arrays.asList("row", "given_name", "surname", "age", "weight", "height");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.intTypeInfo);
        LazySimpleStructObjectInspector objectInspector = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(columns, types, (byte[])LazySimpleSerDe.DefaultSeparators, (Text)new Text("\\N"), (boolean)false, (boolean)false, (byte)92);
        DefaultAccumuloRowIdFactory rowIdFactory = new DefaultAccumuloRowIdFactory();
        Properties props = new Properties();
        props.setProperty("accumulo.columns.mapping", ":rowid,personal:given_name,personal:surname,personal:age,personal:weight,personal:height");
        props.setProperty("columns", Joiner.on((char)',').join(columns));
        props.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters params = new AccumuloSerDeParameters(new Configuration(), props, AccumuloSerDe.class.getName());
        rowIdFactory.init(params, props);
        LazyAccumuloRow lazyRow = new LazyAccumuloRow(objectInspector);
        AccumuloHiveRow hiveRow = new AccumuloHiveRow("1");
        hiveRow.add("personal", "given_name", "Bob".getBytes());
        hiveRow.add("personal", "surname", "Stevens".getBytes());
        hiveRow.add("personal", "age", "30".getBytes());
        hiveRow.add("personal", "weight", "200".getBytes());
        hiveRow.add("personal", "height", "72".getBytes());
        ColumnMapper columnMapper = params.getColumnMapper();
        lazyRow.init(hiveRow, columnMapper.getColumnMappings(), (AccumuloRowIdFactory)rowIdFactory);
        Object o = lazyRow.getField(0);
        Assert.assertEquals(LazyString.class, o.getClass());
        Assert.assertEquals((Object)"1", (Object)((LazyString)o).toString());
        o = lazyRow.getField(1);
        Assert.assertEquals(LazyString.class, o.getClass());
        Assert.assertEquals((Object)"Bob", (Object)((LazyString)o).toString());
        o = lazyRow.getField(2);
        Assert.assertEquals(LazyString.class, o.getClass());
        Assert.assertEquals((Object)"Stevens", (Object)((LazyString)o).toString());
        o = lazyRow.getField(3);
        Assert.assertEquals(LazyInteger.class, o.getClass());
        Assert.assertEquals((Object)"30", (Object)((LazyInteger)o).toString());
        o = lazyRow.getField(4);
        Assert.assertEquals(LazyInteger.class, o.getClass());
        Assert.assertEquals((Object)"200", (Object)((LazyInteger)o).toString());
        o = lazyRow.getField(5);
        Assert.assertEquals(LazyInteger.class, o.getClass());
        Assert.assertEquals((Object)"72", (Object)((LazyInteger)o).toString());
    }

    @Test
    public void testDeserializationOfBinaryEncoding() throws Exception {
        List<String> columns = Arrays.asList("row", "given_name", "surname", "age", "weight", "height");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.stringTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.intTypeInfo);
        LazySimpleStructObjectInspector objectInspector = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(columns, types, (byte[])LazySimpleSerDe.DefaultSeparators, (Text)new Text("\\N"), (boolean)false, (boolean)false, (byte)92);
        DefaultAccumuloRowIdFactory rowIdFactory = new DefaultAccumuloRowIdFactory();
        Properties props = new Properties();
        props.setProperty("accumulo.columns.mapping", ":rowid#s,personal:given_name#s,personal:surname#s,personal:age,personal:weight,personal:height");
        props.setProperty("columns", Joiner.on((char)',').join(columns));
        props.setProperty("columns.types", Joiner.on((char)',').join(types));
        props.setProperty("accumulo.default.storage", ColumnEncoding.BINARY.getName());
        AccumuloSerDeParameters params = new AccumuloSerDeParameters(new Configuration(), props, AccumuloSerDe.class.getName());
        rowIdFactory.init(params, props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        LazyAccumuloRow lazyRow = new LazyAccumuloRow(objectInspector);
        AccumuloHiveRow hiveRow = new AccumuloHiveRow("1");
        hiveRow.add("personal", "given_name", "Bob".getBytes());
        hiveRow.add("personal", "surname", "Stevens".getBytes());
        out.writeInt(30);
        hiveRow.add("personal", "age", baos.toByteArray());
        baos.reset();
        out.writeInt(200);
        hiveRow.add("personal", "weight", baos.toByteArray());
        baos.reset();
        out.writeInt(72);
        hiveRow.add("personal", "height", baos.toByteArray());
        ColumnMapper columnMapper = params.getColumnMapper();
        lazyRow.init(hiveRow, columnMapper.getColumnMappings(), (AccumuloRowIdFactory)rowIdFactory);
        Object o = lazyRow.getField(0);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(LazyString.class, o.getClass());
        Assert.assertEquals((Object)"1", (Object)((LazyString)o).toString());
        o = lazyRow.getField(1);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(LazyString.class, o.getClass());
        Assert.assertEquals((Object)"Bob", (Object)((LazyString)o).toString());
        o = lazyRow.getField(2);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(LazyString.class, o.getClass());
        Assert.assertEquals((Object)"Stevens", (Object)((LazyString)o).toString());
        o = lazyRow.getField(3);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(LazyDioInteger.class, o.getClass());
        Assert.assertEquals((Object)"30", (Object)((LazyDioInteger)o).toString());
        o = lazyRow.getField(4);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(LazyDioInteger.class, o.getClass());
        Assert.assertEquals((Object)"200", (Object)((LazyDioInteger)o).toString());
        o = lazyRow.getField(5);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(LazyDioInteger.class, o.getClass());
        Assert.assertEquals((Object)"72", (Object)((LazyDioInteger)o).toString());
    }

    @Test
    public void testNullInit() throws SerDeException {
        List<String> columns = Arrays.asList("row", "1", "2", "3");
        List<TypeInfo> types = Arrays.asList(TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        LazySimpleStructObjectInspector objectInspector = (LazySimpleStructObjectInspector)LazyFactory.createLazyStructInspector(columns, types, (byte[])LazySimpleSerDe.DefaultSeparators, (Text)new Text("\\N"), (boolean)false, (boolean)false, (byte)92);
        DefaultAccumuloRowIdFactory rowIdFactory = new DefaultAccumuloRowIdFactory();
        Properties props = new Properties();
        props.setProperty("accumulo.columns.mapping", ":rowid,cf:cq1,cf:cq2,cf:cq3");
        props.setProperty("columns", Joiner.on((char)',').join(columns));
        props.setProperty("columns.types", Joiner.on((char)',').join(types));
        AccumuloSerDeParameters params = new AccumuloSerDeParameters(new Configuration(), props, AccumuloSerDe.class.getName());
        rowIdFactory.init(params, props);
        ColumnMapper columnMapper = params.getColumnMapper();
        LazyAccumuloRow lazyRow = new LazyAccumuloRow(objectInspector);
        AccumuloHiveRow hiveRow = new AccumuloHiveRow("1");
        hiveRow.add("cf", "cq1", "foo".getBytes());
        hiveRow.add("cf", "cq3", "bar".getBytes());
        lazyRow.init(hiveRow, columnMapper.getColumnMappings(), (AccumuloRowIdFactory)rowIdFactory);
        Assert.assertEquals((Object)"{'row':'1','1':'foo','2':null,'3':'bar'}".replace('\'', '\"'), (Object)SerDeUtils.getJSONString((Object)lazyRow, (ObjectInspector)objectInspector));
        Assert.assertEquals((Object)"{'row':'1','1':'foo','2':null,'3':'bar'}".replace('\'', '\"'), (Object)SerDeUtils.getJSONString((Object)lazyRow, (ObjectInspector)objectInspector));
    }
}

