/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import com.google.common.base.Joiner;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestThriftServerCmdLine {
    public static final Log LOG = LogFactory.getLog(TestThriftServerCmdLine.class);
    private final ThriftServerRunner.ImplType implType;
    private boolean specifyFramed;
    private boolean specifyBindIP;
    private boolean specifyCompact;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Thread cmdLineThread;
    private volatile Exception cmdLineException;
    private Exception clientSideException;
    private ThriftServer thriftServer;
    private int port;
    private static volatile boolean tableCreated = false;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (ThriftServerRunner.ImplType implType : ThriftServerRunner.ImplType.values()) {
            for (boolean specifyFramed : new boolean[]{false, true}) {
                for (boolean specifyBindIP : new boolean[]{false, true}) {
                    if (specifyBindIP && !implType.canSpecifyBindIP) continue;
                    for (boolean specifyCompact : new boolean[]{false, true}) {
                        parameters.add(new Object[]{implType, specifyFramed, specifyBindIP, specifyCompact});
                    }
                }
            }
        }
        return parameters;
    }

    public TestThriftServerCmdLine(ThriftServerRunner.ImplType implType, boolean specifyFramed, boolean specifyBindIP, boolean specifyCompact) {
        this.implType = implType;
        this.specifyFramed = specifyFramed;
        this.specifyBindIP = specifyBindIP;
        this.specifyCompact = specifyCompact;
        LOG.debug((Object)this.getParametersString());
    }

    private String getParametersString() {
        return "implType=" + this.implType + ", " + "specifyFramed=" + this.specifyFramed + ", " + "specifyBindIP=" + this.specifyBindIP + ", " + "specifyCompact=" + this.specifyCompact;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TEST_UTIL.startMiniCluster();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    private void startCmdLineThread(final String[] args) {
        LOG.info((Object)("Starting HBase Thrift server with command line: " + Joiner.on((String)" ").join((Object[])args)));
        this.cmdLineException = null;
        this.cmdLineThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestThriftServerCmdLine.this.thriftServer.doMain(args);
                }
                catch (Exception e) {
                    TestThriftServerCmdLine.this.cmdLineException = e;
                }
            }
        });
        this.cmdLineThread.setName(ThriftServer.class.getSimpleName() + "-cmdline");
        this.cmdLineThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testRunThriftServer() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (this.implType != null) {
            String serverTypeOption = this.implType.toString();
            Assert.assertTrue((boolean)serverTypeOption.startsWith("-"));
            args.add(serverTypeOption);
        }
        this.port = HBaseTestingUtility.randomFreePort();
        args.add("-port");
        args.add(String.valueOf(this.port));
        if (this.specifyFramed) {
            args.add("-framed");
        }
        if (this.specifyBindIP) {
            args.add("-bind");
            args.add(InetAddress.getLocalHost().getHostName());
        }
        if (this.specifyCompact) {
            args.add("-compact");
        }
        args.add("start");
        this.thriftServer = new ThriftServer(TEST_UTIL.getConfiguration());
        this.startCmdLineThread(args.toArray(new String[args.size()]));
        for (int i = 0; i < 100 && (this.thriftServer.serverRunner == null || this.thriftServer.serverRunner.tserver == null); ++i) {
            Thread.sleep(100L);
        }
        Class expectedClass = this.implType != null ? this.implType.serverClass : TBoundedThreadPoolServer.class;
        Assert.assertEquals((Object)expectedClass, this.thriftServer.serverRunner.tserver.getClass());
        try {
            this.talkToThriftServer();
        }
        catch (Exception ex) {
            this.clientSideException = ex;
        }
        finally {
            this.stopCmdLineThread();
        }
        if (this.clientSideException != null) {
            LOG.error((Object)("Thrift client threw an exception. Parameters:" + this.getParametersString()), (Throwable)this.clientSideException);
            throw new Exception(this.clientSideException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void talkToThriftServer() throws Exception {
        TSocket sock;
        TSocket transport = sock = new TSocket(InetAddress.getLocalHost().getHostName(), this.port);
        if (this.specifyFramed || this.implType.isAlwaysFramed) {
            transport = new TFramedTransport((TTransport)transport);
        }
        sock.open();
        try {
            Object prot = this.specifyCompact ? new TCompactProtocol((TTransport)transport) : new TBinaryProtocol((TTransport)transport);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
        finally {
            sock.close();
        }
    }

    private void stopCmdLineThread() throws Exception {
        LOG.debug((Object)("Stopping " + this.implType.simpleClassName() + " Thrift server"));
        this.thriftServer.stop();
        this.cmdLineThread.join();
        if (this.cmdLineException != null) {
            LOG.error((Object)"Command-line invocation of HBase Thrift server threw an exception", (Throwable)this.cmdLineException);
            throw new Exception(this.cmdLineException);
        }
    }
}

