/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestShell {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final ScriptingContainer jruby = new ScriptingContainer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        SecureTestUtil.enableSecurity((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster();
        ArrayList<String> loadPaths = new ArrayList<String>();
        loadPaths.add("src/main/ruby");
        loadPaths.add("src/test/ruby");
        jruby.getProvider().setLoadPaths(loadPaths);
        jruby.put("$TEST_CLUSTER", (Object)TEST_UTIL);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRunShellTests() throws IOException {
        jruby.runScriptlet(PathType.ABSOLUTE, "src/test/ruby/tests_runner.rb");
    }
}

