/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class BoundedConcurrentLinkedQueue<T>
extends ConcurrentLinkedQueue<T> {
    private static final long serialVersionUID = 1L;
    private final AtomicLong size = new AtomicLong(0L);
    private final long maxSize;

    public BoundedConcurrentLinkedQueue() {
        this(Long.MAX_VALUE);
    }

    public BoundedConcurrentLinkedQueue(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        long nextSize;
        long currentSize;
        do {
            if ((nextSize = (currentSize = this.size.get()) + (long)c.size()) <= this.maxSize) continue;
            return false;
        } while (!this.size.compareAndSet(currentSize, nextSize));
        return super.addAll(c);
    }

    @Override
    public void clear() {
        long removed = 0L;
        while (super.poll() != null) {
            ++removed;
        }
        this.size.addAndGet(-removed);
    }

    @Override
    public boolean offer(T e) {
        long currentSize;
        do {
            if ((currentSize = this.size.get()) < this.maxSize) continue;
            return false;
        } while (!this.size.compareAndSet(currentSize, currentSize + 1L));
        return super.offer(e);
    }

    @Override
    public T poll() {
        Object result = super.poll();
        if (result != null) {
            this.size.decrementAndGet();
        }
        return (T)result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result) {
            this.size.decrementAndGet();
        }
        return result;
    }

    @Override
    public int size() {
        return (int)this.size.get();
    }

    public void drainTo(Collection<T> list) {
        Object element;
        long removed = 0L;
        while ((element = super.poll()) != null) {
            list.add(element);
            ++removed;
        }
        this.size.addAndGet(-removed);
    }

    public long remainingCapacity() {
        return this.maxSize - this.size.get();
    }
}

