/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Import {
    private static final Log LOG = LogFactory.getLog(Import.class);
    static final String NAME = "import";
    public static final String CF_RENAME_PROP = "HBASE_IMPORTER_RENAME_CFS";
    public static final String BULK_OUTPUT_CONF_KEY = "import.bulk.output";
    public static final String FILTER_CLASS_CONF_KEY = "import.filter.class";
    public static final String FILTER_ARGS_CONF_KEY = "import.filter.args";
    public static final String TABLE_NAME = "import.table.name";
    public static final String WAL_DURABILITY = "import.wal.durability";

    public static Filter instantiateFilter(Configuration conf) {
        Class filterClass = conf.getClass(FILTER_CLASS_CONF_KEY, null, Filter.class);
        if (filterClass == null) {
            LOG.debug((Object)"No configured filter class, accepting all keyvalues.");
            return null;
        }
        LOG.debug((Object)("Attempting to create filter:" + filterClass));
        String[] filterArgs = conf.getStrings(FILTER_ARGS_CONF_KEY);
        ArrayList<byte[]> quotedArgs = Import.toQuotedByteArrays(filterArgs);
        try {
            Method m = filterClass.getMethod("createFilterFromArguments", ArrayList.class);
            return (Filter)m.invoke(null, quotedArgs);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Couldn't instantiate filter!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static ArrayList<byte[]> toQuotedByteArrays(String ... stringArgs) {
        ArrayList<byte[]> quotedArgs = new ArrayList<byte[]>();
        for (String stringArg : stringArgs) {
            quotedArgs.add(Bytes.toBytes((String)("'" + stringArg + "'")));
        }
        return quotedArgs;
    }

    public static Cell filterKv(Filter filter, Cell kv) throws IOException {
        if (filter != null) {
            Filter.ReturnCode code = filter.filterKeyValue(kv);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Filter returned:" + code + " for the key value:" + kv));
            }
            if (!code.equals((Object)Filter.ReturnCode.INCLUDE) && !code.equals((Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL)) {
                return null;
            }
        }
        return kv;
    }

    private static Cell convertKv(Cell kv, Map<byte[], byte[]> cfRenameMap) {
        byte[] newCfName;
        if (cfRenameMap != null && (newCfName = cfRenameMap.get(CellUtil.cloneFamily((Cell)kv))) != null) {
            kv = new KeyValue(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength(), newCfName, 0, newCfName.length, kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType((byte)kv.getTypeByte()), kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        }
        return kv;
    }

    private static Map<byte[], byte[]> createCfRenameMap(Configuration conf) {
        TreeMap<byte[], byte[]> cfRenameMap = null;
        String allMappingsPropVal = conf.get(CF_RENAME_PROP);
        if (allMappingsPropVal != null) {
            String[] allMappings;
            for (String mapping : allMappings = allMappingsPropVal.split(",")) {
                String[] srcAndDest;
                if (cfRenameMap == null) {
                    cfRenameMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
                }
                if ((srcAndDest = mapping.split(":")).length != 2) continue;
                cfRenameMap.put(srcAndDest[0].getBytes(), srcAndDest[1].getBytes());
            }
        }
        return cfRenameMap;
    }

    public static void configureCfRenaming(Configuration conf, Map<String, String> renameMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : renameMap.entrySet()) {
            String sourceCf = entry.getKey();
            String destCf = entry.getValue();
            if (sourceCf.contains(":") || sourceCf.contains(",") || destCf.contains(":") || destCf.contains(",")) {
                throw new IllegalArgumentException("Illegal character in CF names: " + sourceCf + ", " + destCf);
            }
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(sourceCf + ":" + destCf);
        }
        conf.set(CF_RENAME_PROP, sb.toString());
    }

    public static void addFilterAndArguments(Configuration conf, Class<? extends Filter> clazz, List<String> filterArgs) throws IOException {
        conf.set(FILTER_CLASS_CONF_KEY, clazz.getName());
        conf.setStrings(FILTER_ARGS_CONF_KEY, filterArgs.toArray(new String[filterArgs.size()]));
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        Job job;
        block40: {
            TableName tableName = TableName.valueOf((String)args[0]);
            conf.set(TABLE_NAME, tableName.getNameAsString());
            Path inputDir = new Path(args[1]);
            job = new Job(conf, "import_" + tableName);
            job.setJarByClass(Importer.class);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
            job.setInputFormatClass(SequenceFileInputFormat.class);
            String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
            try {
                Class filter = conf.getClass(FILTER_CLASS_CONF_KEY, null, Filter.class);
                if (filter != null) {
                    TableMapReduceUtil.addDependencyJars(conf, filter);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (hfileOutPath != null) {
                job.setMapperClass(KeyValueImporter.class);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = conn.getTable(tableName);
                     RegionLocator regionLocator = conn.getRegionLocator(tableName);){
                    job.setReducerClass(KeyValueSortReducer.class);
                    Path outputDir = new Path(hfileOutPath);
                    FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
                    job.setMapOutputKeyClass(ImmutableBytesWritable.class);
                    job.setMapOutputValueClass(KeyValue.class);
                    HFileOutputFormat2.configureIncrementalLoad(job, table.getTableDescriptor(), regionLocator);
                    TableMapReduceUtil.addDependencyJars(job.getConfiguration(), Preconditions.class);
                    break block40;
                }
            }
            job.setMapperClass(Importer.class);
            TableMapReduceUtil.initTableReducerJob(tableName.getNameAsString(), null, job);
            job.setNumReduceTasks(0);
        }
        return job;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Import [options] <tablename> <inputdir>");
        System.err.println("By default Import will load data directly into HBase. To instead generate");
        System.err.println("HFiles of data to prepare for a bulk data load, pass the option:");
        System.err.println("  -Dimport.bulk.output=/path/for/output");
        System.err.println(" To apply a generic org.apache.hadoop.hbase.filter.Filter to the input, use");
        System.err.println("  -Dimport.filter.class=<name of filter class>");
        System.err.println("  -Dimport.filter.args=<comma separated list of args for filter");
        System.err.println(" NOTE: The filter will be applied BEFORE doing key renames via the HBASE_IMPORTER_RENAME_CFS property. Futher, filters will only use the Filter#filterRowKey(byte[] buffer, int offset, int length) method to identify  whether the current row needs to be ignored completely for processing and  Filter#filterKeyValue(KeyValue) method to determine if the KeyValue should be added; Filter.ReturnCode#INCLUDE and #INCLUDE_AND_NEXT_COL will be considered as including the KeyValue.");
        System.err.println("For performance consider the following options:\n  -Dmapreduce.map.speculative=false\n  -Dmapreduce.reduce.speculative=false\n  -Dimport.wal.durability=<Used while writing data to hbase. Allowed values are the supported durability values like SKIP_WAL/ASYNC_WAL/SYNC_WAL/...>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushRegionsIfNecessary(Configuration conf) throws IOException, InterruptedException {
        String tableName = conf.get(TABLE_NAME);
        HBaseAdmin hAdmin = null;
        String durability = conf.get(WAL_DURABILITY);
        if (conf.get(BULK_OUTPUT_CONF_KEY) == null && durability != null && Durability.SKIP_WAL.name().equalsIgnoreCase(durability)) {
            try {
                hAdmin = new HBaseAdmin(conf);
                hAdmin.flush(tableName);
            }
            finally {
                if (hAdmin != null) {
                    hAdmin.close();
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Job job;
        boolean isJobSuccessful;
        String inputVersionString;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Import.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        if ((inputVersionString = System.getProperty("hbase.import.version")) != null) {
            conf.set("hbase.import.version", inputVersionString);
        }
        if (isJobSuccessful = (job = Import.createSubmittableJob(conf, otherArgs)).waitForCompletion(true)) {
            Import.flushRegionsIfNecessary(conf);
        }
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class Importer
    extends TableMapper<ImmutableBytesWritable, Mutation> {
        private Map<byte[], byte[]> cfRenameMap;
        private List<UUID> clusterIds;
        private Filter filter;
        private Durability durability;
        private byte[] tableUuid;

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                this.writeResult(row, value, context);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void writeResult(ImmutableBytesWritable key, Result result, Mapper.Context context) throws IOException, InterruptedException {
            Put put = null;
            Delete delete = null;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Considering the row." + Bytes.toString((byte[])key.get(), (int)key.getOffset(), (int)key.getLength())));
            }
            if (this.filter == null || !this.filter.filterRowKey(key.get(), key.getOffset(), key.getLength())) {
                this.processKV(key, result, context, put, delete);
            }
        }

        protected void processKV(ImmutableBytesWritable key, Result result, Mapper.Context context, Put put, Delete delete) throws IOException, InterruptedException {
            for (Cell kv : result.rawCells()) {
                if ((kv = Import.filterKv(this.filter, kv)) == null) continue;
                if (CellUtil.isDeleteFamily((Cell)(kv = Import.convertKv(kv, this.cfRenameMap)))) {
                    Delete deleteFamily = new Delete(key.get());
                    deleteFamily.addDeleteMarker(kv);
                    if (this.durability != null) {
                        deleteFamily.setDurability(this.durability);
                    }
                    deleteFamily.setClusterIds(this.clusterIds);
                    context.write((Object)key, (Object)deleteFamily);
                    continue;
                }
                if (CellUtil.isDelete((Cell)kv)) {
                    if (delete == null) {
                        delete = new Delete(key.get());
                    }
                    delete.addDeleteMarker(kv);
                    continue;
                }
                if (put == null) {
                    put = new Put(key.get());
                }
                this.addPutToKv(put, kv);
            }
            if (put != null) {
                if (this.durability != null) {
                    put.setDurability(this.durability);
                }
                put.setClusterIds(this.clusterIds);
                put.setAttribute("MAPR_UUID", this.tableUuid);
                context.write((Object)key, (Object)put);
            }
            if (delete != null) {
                if (this.durability != null) {
                    delete.setDurability(this.durability);
                }
                delete.setClusterIds(this.clusterIds);
                delete.setAttribute("MAPR_UUID", this.tableUuid);
                context.write((Object)key, (Object)delete);
            }
        }

        protected void addPutToKv(Put put, Cell kv) throws IOException {
            put.add(kv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            String srcTableName = conf.get("SrcTableName");
            this.cfRenameMap = Import.createCfRenameMap(conf);
            this.filter = Import.instantiateFilter(conf);
            String durabilityStr = conf.get(Import.WAL_DURABILITY);
            if (durabilityStr != null) {
                this.durability = Durability.valueOf((String)durabilityStr.toUpperCase());
            }
            if (srcTableName != null) {
                try {
                    HTable table = new HTable(conf, srcTableName);
                    HTableDescriptor htd = table.getTableDescriptor();
                    this.tableUuid = htd.getValue(Bytes.toBytes((String)"MAPR_UUID"));
                }
                catch (IOException e) {
                    LOG.error((Object)"Problem setting up task", (Throwable)e);
                }
            }
            Throwable ex = null;
            try (ZooKeeperWatcher zkw = null;){
                zkw = new ZooKeeperWatcher(conf, context.getTaskAttemptID().toString(), null);
                this.clusterIds = Collections.singletonList(ZKClusterId.getUUIDForCluster((ZooKeeperWatcher)zkw));
            }
            if (this.clusterIds == null) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class KeyValueImporter
    extends TableMapper<ImmutableBytesWritable, KeyValue> {
        private Map<byte[], byte[]> cfRenameMap;
        private Filter filter;
        private static final Log LOG = LogFactory.getLog(KeyValueImporter.class);

        public void map(ImmutableBytesWritable row, Result value, Mapper.Context context) throws IOException {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Considering the row." + Bytes.toString((byte[])row.get(), (int)row.getOffset(), (int)row.getLength())));
                }
                if (this.filter == null || !this.filter.filterRowKey(row.get(), row.getOffset(), row.getLength())) {
                    for (Cell kv : value.rawCells()) {
                        if ((kv = Import.filterKv(this.filter, kv)) == null) continue;
                        context.write((Object)row, (Object)KeyValueUtil.ensureKeyValue((Cell)Import.convertKv(kv, this.cfRenameMap)));
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setup(Mapper.Context context) {
            this.cfRenameMap = Import.createCfRenameMap(context.getConfiguration());
            this.filter = Import.instantiateFilter(context.getConfiguration());
        }
    }
}

