/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestDelayedRpc;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestDelayedRpcProtos;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSecureRPC {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;

    @BeforeClass
    public static void setUp() throws Exception {
        Properties conf = MiniKdc.createConf();
        conf.put("debug", (Object)true);
        KDC = new MiniKdc(conf, new File(TEST_UTIL.getDataTestDir("kdc").toUri().getPath()));
        KDC.start();
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setKeytabFileForTesting(KEYTAB_FILE.getAbsolutePath());
        HBaseKerberosUtils.setPrincipalForTesting(PRINCIPAL + "@" + KDC.getRealm());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (KDC != null) {
            KDC.stop();
        }
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testRpc() throws Exception {
        this.testRpcCallWithEnabledKerberosSaslAuth(RpcClientImpl.class);
    }

    @Test
    public void testAsyncRpc() throws Exception {
        this.testRpcCallWithEnabledKerberosSaslAuth(AsyncRpcClient.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRpcCallWithEnabledKerberosSaslAuth(Class<? extends RpcClient> rpcImplClass) throws Exception {
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Configuration cnf = new Configuration();
        cnf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)cnf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi, (Object)ugi2);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        conf.set("hbase.rpc.client.impl", rpcImplClass.getName());
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestDelayedService", (SecurityInfo)securityInfoMock);
        boolean delayReturnValue = false;
        InetSocketAddress isa = new InetSocketAddress(HOST, 0);
        TestDelayedRpc.TestDelayedImplementation instance = new TestDelayedRpc.TestDelayedImplementation(delayReturnValue);
        BlockingService service = TestDelayedRpcProtos.TestDelayedService.newReflectiveBlockingService(instance);
        RpcServer rpcServer = new RpcServer(null, "testSecuredDelayedRpc", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(service, null)}), isa, conf, (RpcScheduler)new FifoRpcScheduler(conf, 1));
        rpcServer.start();
        RpcClient rpcClient = RpcClientFactory.createClient((Configuration)conf, (String)HConstants.DEFAULT_CLUSTER_ID.toString());
        try {
            BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)rpcServer.getListenerAddress().getHostName(), (int)rpcServer.getListenerAddress().getPort(), (long)System.currentTimeMillis()), User.getCurrent(), 5000);
            TestDelayedRpcProtos.TestDelayedService.BlockingInterface stub = TestDelayedRpcProtos.TestDelayedService.newBlockingStub(channel);
            ArrayList<Integer> results = new ArrayList<Integer>();
            TestDelayedRpc.TestThread th1 = new TestDelayedRpc.TestThread(stub, true, results);
            th1.start();
            th1.join();
            Assert.assertEquals((long)-559038737L, (long)((Integer)results.get(0)).intValue());
        }
        finally {
            rpcClient.close();
            rpcServer.stop();
        }
    }

    static {
        HOST = "localhost";
    }
}

