/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMasterPriorityRpc {
    private HMaster master = null;
    private PriorityFunction priority = null;
    private final Set<String> ADMIN_METHODS = Sets.newHashSet((Object[])new String[]{"GetLastFlushedSequenceId", "RegionServerReport", "RegionServerStartup", "ReportRSFatalError", "ReportRegionStateTransition"});
    private final Set<String> NORMAL_METHODS = Sets.newHashSet((Object[])new String[]{"CreateTable", "DeleteTable", "ModifyColumn", "OfflineRegion", "Shutdown"});

    @Before
    public void setup() {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.testing.nocluster", true);
        CoordinatedStateManager cp = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)conf);
        this.master = HMaster.constructMaster(HMaster.class, (Configuration)conf, (CoordinatedStateManager)cp);
        this.priority = this.master.getMasterRpcServices().getPriority();
    }

    private void assertPriority(String methodName, int expectedPriority) {
        Assert.assertEquals((String)(methodName + " had unexpected priority"), (long)expectedPriority, (long)this.priority.getPriority(RPCProtos.RequestHeader.newBuilder().setMethodName(methodName).build(), null));
    }

    @Test
    public void testNullMessage() {
        this.assertPriority("doesnotexist", 0);
    }

    @Test
    public void testAdminPriorityMethods() {
        for (String methodName : this.ADMIN_METHODS) {
            this.assertPriority(methodName, 100);
        }
    }

    @Test
    public void testSomeNormalMethods() {
        for (String methodName : this.NORMAL_METHODS) {
            this.assertPriority(methodName, 0);
        }
    }
}

