/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce.mapr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class UnionMapper
extends TableMapper<Text, IntWritable> {
    static Log LOG = LogFactory.getLog(UnionMapper.class);
    byte[] sales;
    String storeSales;
    Integer sSales;
    String onlineSales;
    Integer oSales;
    Text mapperKey;
    IntWritable mapperValue;

    public void map(ImmutableBytesWritable rowKey, Result columns, Mapper.Context context) {
        TableSplit currentSplit = (TableSplit)context.getInputSplit();
        byte[] tableName = currentSplit.getTableName();
        String strTableName = Bytes.toStringBinary((byte[])tableName);
        LOG.info((Object)("Enter Mapper table(" + strTableName + ") record(" + Bytes.toStringBinary((byte[])rowKey.get()) + ")\n UnionJob.MapRTName1(" + String.valueOf("/tmp/tmr1") + ")" + ", UnionJob.MapRTName2(" + String.valueOf("/tmp/tmr2") + ")" + "\n UnionJob.HBaseTName1(" + String.valueOf("hmr1") + ")" + ", UnionJob.HBaseTName2(" + String.valueOf("hmr2") + ")"));
        try {
            if (strTableName.equals("/tmp/tmr1") || strTableName.equals("hmr1")) {
                String date = new String(rowKey.get()).split("#")[0];
                this.sales = columns.getValue(Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"sSales"));
                this.storeSales = new String(this.sales);
                this.sSales = new Integer(this.storeSales);
                this.mapperKey = new Text("s#" + date);
                this.mapperValue = new IntWritable(this.sSales.intValue());
                LOG.info((Object)("Process Mapper table " + tableName + " record(" + this.mapperKey + ", " + this.mapperValue.toString() + ")"));
                context.write((Object)this.mapperKey, (Object)this.mapperValue);
            } else if (strTableName.equals("/tmp/tmr2") || strTableName.equals("hmr2")) {
                String date = new String(rowKey.get());
                this.sales = columns.getValue(Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"oSales"));
                this.onlineSales = new String(this.sales);
                Integer oSales = new Integer(this.onlineSales);
                this.mapperKey = new Text("o#" + date);
                this.mapperValue = new IntWritable(oSales.intValue());
                LOG.info((Object)("Process Mapper table " + tableName + " record(" + this.mapperKey + ", " + this.mapperValue.toString() + ")"));
                context.write((Object)this.mapperKey, (Object)this.mapperValue);
            } else {
                LOG.info((Object)(strTableName + "does not much any table."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

