/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFuzzyRowFilterEndToEnd {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestFuzzyRowFilterEndToEnd.class);
    private static int firstPartCardinality = 50;
    private static int secondPartCardinality = 40;
    private static int colQualifiersTotal = 50;
    private static int totalFuzzyKeys = secondPartCardinality / 2;
    private static String table = "TestFuzzyRowFilterEndToEnd";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.caching", 1000);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setLong("hbase.hregion.max.filesize", 0x280000000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEndToEnd() throws Exception {
        String cf = "f";
        HTable ht = TEST_UTIL.createTable(TableName.valueOf((String)table), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        for (int i1 = 0; i1 < firstPartCardinality; ++i1) {
            if (i1 % 1000 == 0) {
                LOG.info((Object)("put " + i1));
            }
            for (int i2 = 0; i2 < secondPartCardinality; ++i2) {
                byte[] rk = new byte[10];
                ByteBuffer buf = ByteBuffer.wrap(rk);
                buf.clear();
                buf.putShort((short)2);
                buf.putInt(i1);
                buf.putInt(i2);
                for (int c = 0; c < colQualifiersTotal; ++c) {
                    byte[] cq = new byte[4];
                    Bytes.putBytes((byte[])cq, (int)0, (byte[])Bytes.toBytes((int)c), (int)0, (int)4);
                    Put p = new Put(rk);
                    p.setDurability(Durability.SKIP_WAL);
                    p.add(cf.getBytes(), cq, Bytes.toBytes((int)c));
                    ht.put(p);
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest(ht);
    }

    private void runTest(HTable hTable) throws IOException {
        byte[] mask = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (int i = 0; i < totalFuzzyKeys; ++i) {
            byte[] fuzzyKey = new byte[10];
            ByteBuffer buf = ByteBuffer.wrap(fuzzyKey);
            buf.clear();
            buf.putShort((short)2);
            for (int j = 0; j < 4; ++j) {
                buf.put((byte)63);
            }
            buf.putInt(i);
            Pair pair = new Pair((Object)fuzzyKey, (Object)mask);
            list.add(pair);
        }
        int expectedSize = firstPartCardinality * totalFuzzyKeys * colQualifiersTotal;
        FuzzyRowFilter fuzzyRowFilter0 = new FuzzyRowFilter(list);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter(list);
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter0);
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter1);
    }

    private void runScanner(HTable hTable, int expectedSize, Filter filter) throws IOException {
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        scan.setFilter(filter);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table.getBytes());
        HRegion first = regions.get(0);
        first.getScanner(scan);
        RegionScanner scanner = first.getScanner(scan);
        ArrayList results = new ArrayList();
        long timeBeforeScan = System.currentTimeMillis();
        int found = 0;
        while (scanner.next(results)) {
            found += results.size();
            results.clear();
        }
        long scanTime = System.currentTimeMillis() - timeBeforeScan;
        scanner.close();
        LOG.info((Object)("\nscan time = " + scanTime + "ms"));
        LOG.info((Object)("found " + (found += results.size()) + " results\n"));
        Assert.assertEquals((long)expectedSize, (long)found);
    }

    @Test
    public void testFilterList() throws Exception {
        String cf = "f";
        String table = "TestFuzzyRowFiltersInFilterList";
        HTable ht = TEST_UTIL.createTable(TableName.valueOf((String)table), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        for (int i1 = 0; i1 < 5; ++i1) {
            for (int i2 = 0; i2 < 5; ++i2) {
                byte[] rk = new byte[10];
                ByteBuffer buf = ByteBuffer.wrap(rk);
                buf.clear();
                buf.putShort((short)2);
                buf.putInt(i1);
                buf.putInt(i2);
                for (int c = 0; c < 5; ++c) {
                    byte[] cq = new byte[4];
                    Bytes.putBytes((byte[])cq, (int)0, (byte[])Bytes.toBytes((int)c), (int)0, (int)4);
                    Put p = new Put(rk);
                    p.setDurability(Durability.SKIP_WAL);
                    p.add(cf.getBytes(), cq, Bytes.toBytes((int)c));
                    ht.put(p);
                    LOG.info((Object)("Inserting: rk: " + Bytes.toStringBinary((byte[])rk) + " cq: " + Bytes.toStringBinary((byte[])cq)));
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest(ht, 5);
    }

    private void runTest(HTable hTable, int expectedSize) throws IOException {
        byte[] fuzzyKey1 = new byte[10];
        ByteBuffer buf = ByteBuffer.wrap(fuzzyKey1);
        buf.clear();
        buf.putShort((short)2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        buf.putInt(1);
        byte[] mask1 = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        byte[] fuzzyKey2 = new byte[10];
        buf = ByteBuffer.wrap(fuzzyKey2);
        buf.clear();
        buf.putShort((short)2);
        buf.putInt(2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        byte[] mask2 = new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1};
        Pair pair1 = new Pair((Object)fuzzyKey1, (Object)mask1);
        Pair pair2 = new Pair((Object)fuzzyKey2, (Object)mask2);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter((List)Lists.newArrayList((Object[])new Pair[]{pair1}));
        FuzzyRowFilter fuzzyRowFilter2 = new FuzzyRowFilter((List)Lists.newArrayList((Object[])new Pair[]{pair2}));
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter1, (Filter)fuzzyRowFilter2);
    }

    private void runScanner(HTable hTable, int expectedSize, Filter filter1, Filter filter2) throws IOException {
        Result result;
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter2});
        scan.setFilter((Filter)filterList);
        ResultScanner scanner = hTable.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        long timeBeforeScan = System.currentTimeMillis();
        while ((result = scanner.next()) != null) {
            for (Cell kv : result.listCells()) {
                LOG.info((Object)("Got rk: " + Bytes.toStringBinary((byte[])CellUtil.cloneRow((Cell)kv)) + " cq: " + Bytes.toStringBinary((byte[])CellUtil.cloneQualifier((Cell)kv))));
                results.add(kv);
            }
        }
        long scanTime = System.currentTimeMillis() - timeBeforeScan;
        scanner.close();
        LOG.info((Object)("scan time = " + scanTime + "ms"));
        LOG.info((Object)("found " + results.size() + " results"));
        Assert.assertEquals((long)expectedSize, (long)results.size());
    }
}

