/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCreateTableHandler {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestCreateTableHandler.class);
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static boolean throwException = false;

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        throwException = false;
    }

    @Test(timeout=300000L)
    public void testCreateTableCalledTwiceAndFirstOneInProgress() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableCalledTwiceAndFirstOneInProgress");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        HRegionInfo[] hRegionInfos = new HRegionInfo[]{new HRegionInfo(desc.getTableName(), null, null)};
        CustomCreateTableHandler handler = new CustomCreateTableHandler((Server)m, m.getMasterFileSystem(), desc, cluster.getConfiguration(), hRegionInfos, (MasterServices)m);
        handler.prepare();
        throwException = true;
        handler.process();
        throwException = false;
        CustomCreateTableHandler handler1 = new CustomCreateTableHandler((Server)m, m.getMasterFileSystem(), desc, cluster.getConfiguration(), hRegionInfos, (MasterServices)m);
        handler1.prepare();
        handler1.process();
        for (int i = 0; i < 100; ++i) {
            if (TEST_UTIL.getHBaseAdmin().isTableAvailable(tableName)) continue;
            Thread.sleep(200L);
        }
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseAdmin().isTableEnabled(tableName));
    }

    @Test(timeout=300000L)
    public void testCreateTableWithSplitRegion() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithSplitRegion");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        byte[] splitPoint = Bytes.toBytes((String)"split-point");
        long ts = System.currentTimeMillis();
        HRegionInfo d1 = new HRegionInfo(desc.getTableName(), null, splitPoint, false, ts);
        HRegionInfo d2 = new HRegionInfo(desc.getTableName(), splitPoint, null, false, ts + 1L);
        HRegionInfo parent = new HRegionInfo(desc.getTableName(), null, null, true, ts + 2L);
        parent.setOffline(true);
        Path tempdir = m.getMasterFileSystem().getTempDir();
        FileSystem fs = m.getMasterFileSystem().getFileSystem();
        Path tempTableDir = FSUtils.getTableDir((Path)tempdir, (TableName)desc.getTableName());
        fs.delete(tempTableDir, true);
        HRegionInfo[] hRegionInfos = new HRegionInfo[]{d1, d2, parent};
        CreateTableHandler handler = new CreateTableHandler((Server)m, m.getMasterFileSystem(), desc, cluster.getConfiguration(), hRegionInfos, (MasterServices)m);
        handler.prepare();
        handler.process();
        for (int i = 0; i < 100; ++i) {
            if (TEST_UTIL.getHBaseAdmin().isTableAvailable(tableName)) continue;
            Thread.sleep(300L);
        }
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseAdmin().isTableEnabled(tableName));
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseAdmin().isTableAvailable(tableName));
        Assert.assertTrue((boolean)TEST_UTIL.getHBaseAdmin().isTableAvailable(tableName, (byte[][])new byte[][]{splitPoint}));
        RegionStates regionStates = m.getAssignmentManager().getRegionStates();
        Assert.assertTrue((String)"Parent should be in SPLIT state", (boolean)regionStates.isRegionInState(parent, new RegionState.State[]{RegionState.State.SPLIT}));
    }

    @Test(timeout=60000L)
    public void testMasterRestartAfterEnablingNodeIsCreated() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testMasterRestartAfterEnablingNodeIsCreated");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        HRegionInfo[] hRegionInfos = new HRegionInfo[]{new HRegionInfo(desc.getTableName(), null, null)};
        CustomCreateTableHandler handler = new CustomCreateTableHandler((Server)m, m.getMasterFileSystem(), desc, cluster.getConfiguration(), hRegionInfos, (MasterServices)m);
        handler.prepare();
        throwException = true;
        handler.process();
        this.abortAndStartNewMaster(cluster);
        Assert.assertTrue((cluster.getLiveMasterThreads().size() == 1 ? 1 : 0) != 0);
    }

    private void abortAndStartNewMaster(MiniHBaseCluster cluster) throws IOException {
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        LOG.info((Object)"Starting new master");
        cluster.startMaster();
        LOG.info((Object)"Waiting for master to become active.");
        cluster.waitForActiveAndReadyMaster();
    }

    private static class CustomCreateTableHandler
    extends CreateTableHandler {
        public CustomCreateTableHandler(Server server, MasterFileSystem fileSystemManager, HTableDescriptor hTableDescriptor, Configuration conf, HRegionInfo[] newRegions, MasterServices masterServices) {
            super(server, fileSystemManager, hTableDescriptor, conf, newRegions, masterServices);
        }

        protected List<HRegionInfo> handleCreateHdfsRegions(Path tableRootDir, TableName tableName) throws IOException {
            if (throwException) {
                throw new IOException("Test throws exceptions.");
            }
            return super.handleCreateHdfsRegions(tableRootDir, tableName);
        }
    }
}

