/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotFileCache {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFileCache.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static long sequenceId = 0L;
    private static FileSystem fs;
    private static Path rootDir;

    @BeforeClass
    public static void startCluster() throws Exception {
        UTIL.startMiniDFSCluster(1);
        fs = UTIL.getDFSCluster().getFileSystem();
        rootDir = UTIL.getDefaultRootDirPath();
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        UTIL.shutdownMiniDFSCluster();
    }

    @After
    public void cleanupFiles() throws Exception {
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        fs.delete(snapshotDir, true);
    }

    @Test(timeout=10000000L)
    public void testLoadAndDelete() throws IOException {
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1a", false, true);
        this.createAndTestSnapshotV1(cache, "snapshot1b", true, true);
        this.createAndTestSnapshotV2(cache, "snapshot2a", false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2b", true, true);
    }

    @Test
    public void testJustFindLogsDirectory() throws Exception {
        long period = Long.MAX_VALUE;
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFileCache.SnapshotFileInspector(){

            public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
                return SnapshotReferenceUtil.getHLogNames((FileSystem)fs, (Path)snapshotDir);
            }
        });
        HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.newBuilder().setName("snapshot").build();
        Path snapshot = SnapshotDescriptionUtils.getCompletedSnapshotDir((HBaseProtos.SnapshotDescription)desc, (Path)rootDir);
        SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)desc, (Path)snapshot, (FileSystem)fs);
        Path file1 = new Path(new Path(new Path(snapshot, "7e91021"), "fam"), "file1");
        fs.createNewFile(file1);
        Path logs = TestSnapshotFileCache.getSnapshotHLogsDir(snapshot, "server");
        Path log = new Path(logs, "me.hbase.com%2C58939%2C1350424310315.1350424315552");
        fs.createNewFile(log);
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        Assert.assertFalse((String)("Cache found '" + file1 + "', but it shouldn't have."), (boolean)cache.contains(file1.getName()));
        Assert.assertTrue((String)("Cache didn't find:" + log), (boolean)cache.contains(log.getName()));
    }

    public static Path getSnapshotHLogsDir(Path snapshotDir, String serverName) {
        return new Path(snapshotDir, HLogUtil.getHLogDirectoryName((String)serverName));
    }

    @Test
    public void testReloadModifiedDirectory() throws IOException {
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1", false, true);
        this.createAndTestSnapshotV1(cache, "snapshot1", false, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, false);
    }

    @Test
    public void testSnapshotTempDirReload() throws IOException {
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot0v1", false, false);
        this.createAndTestSnapshotV1(cache, "snapshot0v2", false, false);
        this.createAndTestSnapshotV2(cache, "snapshot1", true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", true, false);
    }

    private void createAndTestSnapshotV1(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV1(name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit);
    }

    private void createAndTestSnapshotV2(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit);
    }

    private void createAndTestSnapshot(SnapshotFileCache cache, SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder, boolean tmp, boolean removeOnExit) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            for (Path filePath : builder.addRegion()) {
                String fileName = filePath.getName();
                if (tmp) {
                    FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
                    Assert.assertTrue((String)("Cache didn't find " + fileName), (boolean)cache.contains(fileName));
                }
                files.add(fileName);
            }
        }
        if (!tmp) {
            builder.commit();
        }
        for (String fileName : files) {
            Assert.assertTrue((String)("Cache didn't find " + fileName), (boolean)cache.contains(fileName));
        }
        FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
        if (removeOnExit) {
            LOG.debug((Object)"Deleting snapshot.");
            fs.delete(builder.getSnapshotsDir(), true);
            FSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Log)LOG);
            for (String fileName : files) {
                Assert.assertTrue((String)("Cache didn't find " + fileName), (boolean)cache.contains(fileName));
            }
            cache.triggerCacheRefreshForTesting();
            for (String fileName : files) {
                Assert.assertFalse((String)("Cache found '" + fileName + "', but it shouldn't have."), (boolean)cache.contains(fileName));
            }
        }
    }

    class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHLogNames((FileSystem)fs, (Path)snapshotDir));
            files.addAll(SnapshotReferenceUtil.getHFileNames((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (Path)snapshotDir));
            return files;
        }
    }
}

