/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.hfile.bucket.ByteBufferIOEngine;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteBufferIOEngine {
    @Test
    public void testByteBufferIOEngine() throws Exception {
        int capacity = 0x2000000;
        int testNum = 100;
        int maxBlockSize = 65536;
        ByteBufferIOEngine ioEngine = new ByteBufferIOEngine((long)capacity, false);
        int testOffsetAtStartNum = testNum / 10;
        int testOffsetAtEndNum = testNum / 10;
        for (int i = 0; i < testNum; ++i) {
            byte val = (byte)(Math.random() * 255.0);
            int blockSize = (int)(Math.random() * (double)maxBlockSize);
            if (blockSize == 0) {
                blockSize = 1;
            }
            byte[] byteArray = new byte[blockSize];
            for (int j = 0; j < byteArray.length; ++j) {
                byteArray[j] = val;
            }
            ByteBuffer srcBuffer = ByteBuffer.wrap(byteArray);
            int offset = 0;
            if (testOffsetAtStartNum > 0) {
                --testOffsetAtStartNum;
                offset = 0;
            } else if (testOffsetAtEndNum > 0) {
                --testOffsetAtEndNum;
                offset = capacity - blockSize;
            } else {
                offset = (int)(Math.random() * (double)(capacity - maxBlockSize));
            }
            ioEngine.write(srcBuffer, (long)offset);
            ByteBuffer dstBuffer = ByteBuffer.allocate(blockSize);
            ioEngine.read(dstBuffer, (long)offset);
            byte[] byteArray2 = dstBuffer.array();
            for (int j = 0; j < byteArray.length; ++j) {
                Assert.assertTrue((byteArray[j] == byteArray2[j] ? 1 : 0) != 0);
            }
        }
        assert (testOffsetAtStartNum == 0);
        assert (testOffsetAtEndNum == 0);
    }
}

