/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestPrefixTree {
    private static final String row4 = "a-b-B-2-1402397300-1402416535";
    private static final byte[] row4_bytes = Bytes.toBytes((String)"a-b-B-2-1402397300-1402416535");
    private static final String row3 = "a-b-A-1-1402397227-1402415999";
    private static final byte[] row3_bytes = Bytes.toBytes((String)"a-b-A-1-1402397227-1402415999");
    private static final String row2 = "a-b-A-1-1402329600-1402396277";
    private static final byte[] row2_bytes = Bytes.toBytes((String)"a-b-A-1-1402329600-1402396277");
    private static final String row1 = "a-b-A-1";
    private static final byte[] row1_bytes = Bytes.toBytes((String)"a-b-A-1");
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] fam = Bytes.toBytes((String)"cf_1");
    private static final byte[] qual1 = Bytes.toBytes((String)"qf_1");
    private static final byte[] qual2 = Bytes.toBytes((String)"qf_2");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        conf.setBoolean("hbase.online.schema.update.enable", true);
        conf.setInt("hbase.client.scanner.timeout.period", 600000);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBASE11728() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            CellScanner cellScanner;
            HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            colDesc.setDataBlockEncoding(DataBlockEncoding.PREFIX_TREE);
            colDesc.setTimeToLive(15552000);
            desc.addFamily(colDesc);
            hBaseAdmin.createTable(desc);
            table = new HTable(conf, tableName);
            Put put = new Put(Bytes.toBytes((String)"a-b-0-0"));
            put.add(fam, qual1, Bytes.toBytes((String)"c1-value"));
            table.put(put);
            table.flushCommits();
            put = new Put(row1_bytes);
            put.add(fam, qual1, Bytes.toBytes((String)"c1-value"));
            table.put(put);
            table.flushCommits();
            put = new Put(row2_bytes);
            put.add(fam, qual2, Bytes.toBytes((String)"c2-value"));
            table.put(put);
            table.flushCommits();
            put = new Put(row3_bytes);
            put.add(fam, qual2, Bytes.toBytes((String)"c2-value-2"));
            table.put(put);
            table.flushCommits();
            put = new Put(row4_bytes);
            put.add(fam, qual2, Bytes.toBytes((String)"c2-value-3"));
            table.put(put);
            table.flushCommits();
            hBaseAdmin.flush(tableName.getNameAsString());
            String[] rows = new String[]{row1, row2, row3};
            Scan scan = new Scan();
            scan.setStartRow(row1_bytes);
            scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
            ResultScanner scanner = table.getScanner(scan);
            Result[] next = scanner.next(10);
            Assert.assertEquals((long)3L, (long)next.length);
            int i = 0;
            for (Result res : next) {
                cellScanner = res.cellScanner();
                while (cellScanner.advance()) {
                    Assert.assertEquals((Object)rows[i], (Object)Bytes.toString((byte[])cellScanner.current().getRowArray(), (int)cellScanner.current().getRowOffset(), (int)cellScanner.current().getRowLength()));
                }
                ++i;
            }
            scanner.close();
            scan = new Scan();
            scan.addColumn(fam, qual2);
            scan.setStartRow(row1_bytes);
            scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
            scanner = table.getScanner(scan);
            next = scanner.next(10);
            Assert.assertEquals((long)2L, (long)next.length);
            i = 1;
            for (Result res : next) {
                cellScanner = res.cellScanner();
                while (cellScanner.advance()) {
                    Assert.assertEquals((Object)rows[i], (Object)Bytes.toString((byte[])cellScanner.current().getRowArray(), (int)cellScanner.current().getRowOffset(), (int)cellScanner.current().getRowLength()));
                }
                ++i;
            }
            scanner.close();
            i = 1;
            scan = new Scan();
            scan.addColumn(fam, qual2);
            scan.setStartRow(Bytes.toBytes((String)"a-b-A-1-"));
            scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
            scanner = table.getScanner(scan);
            next = scanner.next(10);
            Assert.assertEquals((long)2L, (long)next.length);
            for (Result res : next) {
                cellScanner = res.cellScanner();
                while (cellScanner.advance()) {
                    Assert.assertEquals((Object)rows[i], (Object)Bytes.toString((byte[])cellScanner.current().getRowArray(), (int)cellScanner.current().getRowOffset(), (int)cellScanner.current().getRowLength()));
                }
                ++i;
            }
            scanner.close();
            scan = new Scan();
            scan.addColumn(fam, qual2);
            scan.setStartRow(Bytes.toBytes((String)"a-b-A-1-140239"));
            scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
            scanner = table.getScanner(scan);
            next = scanner.next(10);
            Assert.assertEquals((long)1L, (long)next.length);
            scanner.close();
        }
        finally {
            table.close();
        }
    }
}

