/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAdmin1 {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HBaseAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : this.admin.listTables()) {
            TEST_UTIL.deleteTable(htd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFailedCatalogTrackerGetCleansUpProperly() throws ZooKeeperConnectionException, IOException {
        final AtomicBoolean fail = new AtomicBoolean(false);
        final AtomicReference internalCt = new AtomicReference();
        HBaseAdmin doctoredAdmin = new HBaseAdmin(this.admin.getConfiguration()){

            protected CatalogTracker startCatalogTracker(CatalogTracker ct) throws IOException, InterruptedException {
                internalCt.set(ct);
                super.startCatalogTracker(ct);
                if (fail.get()) {
                    throw new IOException("Intentional test fail", (Throwable)new KeeperException.ConnectionLossException());
                }
                return ct;
            }
        };
        try {
            CatalogTracker ct = doctoredAdmin.getCatalogTracker();
            Assert.assertFalse((boolean)ct.isStopped());
            doctoredAdmin.cleanupCatalogTracker(ct);
            Assert.assertTrue((boolean)ct.isStopped());
            fail.set(true);
            boolean expectedException = false;
            try {
                doctoredAdmin.getCatalogTracker();
            }
            catch (IOException ioe) {
                Assert.assertTrue((boolean)(ioe.getCause() instanceof KeeperException.ConnectionLossException));
                expectedException = true;
            }
            if (!expectedException) {
                Assert.fail((String)"Didn't get expected exception!");
            }
            Assert.assertTrue((String)"Internal CatalogTracker not closed down", (boolean)((CatalogTracker)internalCt.get()).isStopped());
        }
        finally {
            doctoredAdmin.close();
        }
    }

    @Test(timeout=300000L)
    public void testSplitFlushCompactUnknownTable() throws InterruptedException {
        String unknowntable = "fubar";
        IOException exception = null;
        try {
            this.admin.compact("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.flush("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.split("fubar");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDeleteEditUnknownColumnFamilyAndOrTable() throws IOException {
        String nonexistent = "nonexistent";
        HColumnDescriptor nonexistentHcd = new HColumnDescriptor("nonexistent");
        IOException exception = null;
        try {
            this.admin.addColumn("nonexistent", nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteColumn("nonexistent", "nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.disableTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.enableTable("nonexistent");
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.modifyColumn("nonexistent", nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"nonexistent"));
            this.admin.modifyTable(htd.getTableName(), htd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        String tableName = "testDeleteEditUnknownColumnFamilyAndOrTable" + System.currentTimeMillis();
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        htd.addFamily(new HColumnDescriptor("cf"));
        this.admin.createTable(htd);
        try {
            exception = null;
            try {
                this.admin.deleteColumn(htd.getTableName(), nonexistentHcd.getName());
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
            exception = null;
            try {
                this.admin.modifyColumn(htd.getTableName(), nonexistentHcd);
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
        }
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        byte[] table = Bytes.toBytes((String)"testDisableAndEnableTable");
        HTable ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        this.admin.disableTable(ht.getName());
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isDisabledTable(ht.getName()));
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(table);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isEnabledTable(ht.getName()));
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht.close();
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableTables() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        byte[] table1 = Bytes.toBytes((String)"testDisableAndEnableTable1");
        byte[] table2 = Bytes.toBytes((String)"testDisableAndEnableTable2");
        HTable ht1 = TEST_UTIL.createTable(table1, HConstants.CATALOG_FAMILY);
        HTable ht2 = TEST_UTIL.createTable(table2, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.add(HConstants.CATALOG_FAMILY, qualifier, value);
        ht1.put(put);
        ht2.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht1.get(get);
        ht2.get(get);
        this.admin.disableTables("testDisableAndEnableTable.*");
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht1.get(get);
            ht2.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTables("testDisableAndEnableTable.*");
        try {
            ht1.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        try {
            ht2.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht1.close();
        ht2.close();
    }

    @Test(timeout=300000L)
    public void testCreateTable() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(Bytes.toBytes((String)"testCreateTable"), HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getZKTable().isEnabledTable(TableName.valueOf((String)"testCreateTable")));
    }

    @Test(timeout=300000L)
    public void testTruncateTable() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)"testTruncateTable"), false);
    }

    @Test(timeout=300000L)
    public void testTruncateTablePreservingSplits() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)"testTruncateTablePreservingSplits"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        HTable table = TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY, (byte[][])splitKeys);
        try {
            TEST_UTIL.loadNumericRows(table, HConstants.CATALOG_FAMILY, 0, 10);
            Assert.assertEquals((long)10L, (long)TEST_UTIL.countRows(table));
        }
        finally {
            table.close();
        }
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        this.admin.disableTable(tableName);
        this.admin.truncateTable(tableName, preserveSplits);
        table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        try {
            Assert.assertEquals((long)0L, (long)TEST_UTIL.countRows(table));
        }
        finally {
            table.close();
        }
        if (preserveSplits) {
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        }
    }

    @Test(timeout=300000L)
    public void testGetTableDescriptor() throws IOException {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"myTestTable"));
        htd.addFamily(fam1);
        htd.addFamily(fam2);
        htd.addFamily(fam3);
        this.admin.createTable(htd);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), "myTestTable");
        HTableDescriptor confirmedHtd = table.getTableDescriptor();
        Assert.assertEquals((long)htd.compareTo(confirmedHtd), (long)0L);
        table.close();
    }

    @Test(timeout=300000L)
    public void testHColumnValidName() {
        try {
            new HColumnDescriptor("\\test\\abc");
        }
        catch (IllegalArgumentException iae) {
            boolean exceptionThrown = true;
            Assert.assertTrue((boolean)exceptionThrown);
        }
    }

    @Test(timeout=300000L)
    public void testOnlineChangeTableSchema() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"changeTableSchemaOnline");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        HTableDescriptor modifiedHtd = this.admin.getTableDescriptor(tableName);
        Assert.assertFalse((boolean)htd.equals((Object)modifiedHtd));
        Assert.assertTrue((boolean)copy.equals((Object)modifiedHtd));
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)"anyoldkey", (Object)modifiedHtd.getValue("anyoldkey"));
        int countOfFamilies = modifiedHtd.getFamilies().size();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        HColumnDescriptor hcd = (HColumnDescriptor)modifiedHtd.getFamilies().iterator().next();
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd.setMaxVersions(newMaxVersions);
        byte[] hcdName = hcd.getName();
        expectedException = false;
        try {
            this.admin.modifyColumn(tableName, hcd);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor modifiedHcd = modifiedHtd.getFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        HColumnDescriptor xtracol = new HColumnDescriptor("xtracol");
        xtracol.setValue("xtracol", "xtracol");
        expectedException = false;
        try {
            this.admin.addColumn(tableName, xtracol);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)hcd.getValue("xtracol").equals("xtracol"));
        this.admin.deleteColumn(tableName, xtracol.getName());
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd == null ? 1 : 0) != 0);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        this.admin.listTables();
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    @Test(timeout=300000L)
    public void testShouldFailOnlineSchemaUpdateIfOnlineSchemaIsNotEnabled() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"changeTableSchemaOnlineFailure");
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", false);
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertTrue((String)"Online schema update should not happen.", (boolean)expectedException);
        TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
    }

    protected void verifyRoundRobinDistribution(HTable ht, int expectedRegions) throws IOException {
        int numRS = ht.getConnection().getCurrentNrHRS();
        NavigableMap regions = ht.getRegionLocations();
        HashMap server2Regions = new HashMap();
        for (Map.Entry entry : regions.entrySet()) {
            ServerName server = (ServerName)entry.getValue();
            ArrayList regs = (ArrayList)server2Regions.get(server);
            if (regs == null) {
                regs = new ArrayList();
                server2Regions.put(server, regs);
            }
            regs.add(entry.getKey());
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        for (List regionList : server2Regions.values()) {
            Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
        }
    }

    @Test(timeout=300000L)
    public void testCreateTableNumberOfRegions() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableNumberOfRegions");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap regions = ht.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regions.size());
        ht.close();
        byte[] TABLE_2 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_2"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_2));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])new byte[][]{{42}});
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regions.size());
        ht2.close();
        byte[] TABLE_3 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_3"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_3));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, "a".getBytes(), "z".getBytes(), 3);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionLocations();
        Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regions.size());
        ht3.close();
        byte[] TABLE_4 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_4"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_4));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try {
            this.admin.createTable(desc, "a".getBytes(), "z".getBytes(), 2);
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (IllegalArgumentException eae) {
            // empty catch block
        }
        byte[] TABLE_5 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_5"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_5));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, new byte[]{1}, new byte[]{127}, 16);
        HTable ht5 = new HTable(TEST_UTIL.getConfiguration(), TABLE_5);
        regions = ht5.getRegionLocations();
        Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regions.size());
        ht5.close();
    }

    @Test(timeout=300000L)
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithRegions");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        boolean tableAvailable = this.admin.isTableAvailable(Bytes.toString((byte[])tableName), (byte[][])splitKeys);
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap regions = ht.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        Iterator hris = regions.keySet().iterator();
        HRegionInfo hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht, expectedRegions);
        ht.close();
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        byte[] TABLE_2 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_2"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_2));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht2 = new HTable(TEST_UTIL.getConfiguration(), TABLE_2);
        regions = ht2.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        hris = regions.keySet().iterator();
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        hri = (HRegionInfo)hris.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
        Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
        this.verifyRoundRobinDistribution(ht2, expectedRegions);
        ht2.close();
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        byte[] TABLE_3 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_3"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_3));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        this.admin.createTable(desc, startKey, endKey, expectedRegions);
        HTable ht3 = new HTable(TEST_UTIL.getConfiguration(), TABLE_3);
        regions = ht3.getRegionLocations();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        System.err.println("Found " + regions.size() + " regions");
        this.verifyRoundRobinDistribution(ht3, expectedRegions);
        ht3.close();
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        byte[] TABLE_4 = Bytes.add((byte[])tableName, (byte[])Bytes.toBytes((String)"_4"));
        desc = new HTableDescriptor(TableName.valueOf((byte[])TABLE_4));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        HBaseAdmin ladmin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        try {
            ladmin.createTable(desc, (byte[][])splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ladmin.close();
    }

    @Test(timeout=300000L)
    public void testTableAvailableWithRandomSplitKeys() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testTableAvailableWithRandomSplitKeys");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        byte[][] splitKeys = new byte[1][];
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}};
        this.admin.createTable(desc);
        boolean tableAvailable = this.admin.isTableAvailable(Bytes.toString((byte[])tableName), (byte[][])splitKeys);
        Assert.assertFalse((String)"Table should be created with 1 row in META", (boolean)tableAvailable);
    }

    @Test(timeout=300000L)
    public void testCreateTableWithOnlyEmptyStartRow() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithOnlyEmptyStartRow");
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testCreateTableWithEmptyRowInTheSplitKeys");
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            this.LOG.info((Object)"Expected ", (Throwable)e);
        }
    }

    @Test(timeout=120000L)
    public void testTableExist() throws IOException {
        byte[] table = Bytes.toBytes((String)"testTableExist");
        boolean exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test(timeout=300000L)
    public void testForceSplit() throws Exception {
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf")};
        int[] rowCounts = new int[]{6000};
        int numVersions = HColumnDescriptor.DEFAULT_VERSIONS;
        int blockSize = 256;
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        byte[] splitKey = Bytes.toBytes((int)3500);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize);
    }

    @Test(timeout=300000L)
    public void testEnableTableRetainAssignment() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testEnableTableAssignment");
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable(desc, (byte[][])splitKeys);
        HTable ht = new HTable(TEST_UTIL.getConfiguration(), tableName);
        NavigableMap regions = ht.getRegionLocations();
        ht.close();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        this.admin.disableTable(tableName);
        this.admin.enableTable(tableName);
        NavigableMap regions2 = ht.getRegionLocations();
        Assert.assertEquals((long)regions.size(), (long)regions2.size());
        for (Map.Entry entry : regions.entrySet()) {
            Assert.assertEquals(regions2.get(entry.getKey()), entry.getValue());
        }
    }

    @Test(timeout=300000L)
    public void testForceSplitMultiFamily() throws Exception {
        int numVersions = HColumnDescriptor.DEFAULT_VERSIONS;
        int blockSize = 256;
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2")};
        int[] rowCounts = new int[]{6000, 1};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{1, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{6000, 300};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
        rowCounts = new int[]{300, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize);
    }

    void splitTest(byte[] splitPoint, byte[][] familyNames, int[] rowCounts, int numVersions, int blockSize) throws Exception {
        TableName tableName = TableName.valueOf((String)"testForceSplit");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCounts.length; ++i) {
            sb.append("_").append(Integer.toString(rowCounts[i]));
        }
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
        final HTable table = TEST_UTIL.createTable(tableName, familyNames, numVersions, blockSize);
        int rowCount = 0;
        byte[] q = new byte[]{};
        for (int index = 0; index < familyNames.length; ++index) {
            ArrayList<Put> puts = new ArrayList<Put>(rowCounts[index]);
            for (int i = 0; i < rowCounts[index]; ++i) {
                byte[] k = Bytes.toBytes((int)i);
                Put put = new Put(k);
                put.add(familyNames[index], q, k);
                puts.add(put);
            }
            table.put(puts);
            if (rowCount >= rowCounts[index]) continue;
            rowCount = rowCounts[index];
        }
        NavigableMap m = table.getRegionLocations();
        this.LOG.info((Object)("Initial regions (" + m.size() + "): " + m));
        Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        int rows = 0;
        for (Result result : scanner) {
            ++rows;
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        scan = new Scan();
        scanner = table.getScanner(scan);
        scanner.next();
        this.admin.split(tableName.getName(), splitPoint);
        final AtomicInteger count = new AtomicInteger(0);
        Thread t = new Thread("CheckForSplit"){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    try {
                        2.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    NavigableMap regions = null;
                    try {
                        regions = table.getRegionLocations();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (regions == null) continue;
                    count.set(regions.size());
                    if (count.get() >= 2) {
                        TestAdmin1.this.LOG.info((Object)("Found: " + regions));
                        break;
                    }
                    TestAdmin1.this.LOG.debug((Object)"Cycle waiting on split");
                }
                TestAdmin1.this.LOG.debug((Object)("CheckForSplit thread exited, current region count: " + count.get()));
            }
        };
        t.setPriority(3);
        t.start();
        t.join();
        rows = 1;
        for (Result result : scanner) {
            if (++rows <= rowCount) continue;
            scanner.close();
            Assert.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
        }
        scanner.close();
        Assert.assertEquals((long)rowCount, (long)rows);
        NavigableMap regions = null;
        try {
            regions = table.getRegionLocations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)2L, (long)regions.size());
        Set hRegionInfos = regions.keySet();
        HRegionInfo[] r = hRegionInfos.toArray(new HRegionInfo[hRegionInfos.size()]);
        if (splitPoint != null) {
            Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])r[0].getEndKey()));
            Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])r[1].getStartKey()));
            this.LOG.debug((Object)("Properly split on " + Bytes.toString((byte[])splitPoint)));
        } else if (familyNames.length > 1) {
            int splitKey = Bytes.toInt((byte[])r[0].getEndKey());
            int deltaForLargestFamily = Math.abs(rowCount / 2 - splitKey);
            this.LOG.debug((Object)("SplitKey=" + splitKey + "&deltaForLargestFamily=" + deltaForLargestFamily + ", r=" + r[0]));
            for (int index = 0; index < familyNames.length; ++index) {
                int delta = Math.abs(rowCounts[index] / 2 - splitKey);
                if (delta >= deltaForLargestFamily) continue;
                Assert.assertTrue((String)("Delta " + delta + " for family " + index + " should be at least deltaForLargestFamily " + deltaForLargestFamily), (boolean)false);
            }
        }
        TEST_UTIL.deleteTable(tableName);
        table.close();
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public void testEmptyHTableDescriptor() throws IOException {
        this.admin.createTable(new HTableDescriptor());
    }

    @Test(expected=IllegalArgumentException.class, timeout=300000L)
    public void testInvalidHColumnDescriptor() throws IOException {
        new HColumnDescriptor("/cfamily/name");
    }

    @Test(timeout=300000L)
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        TableName tableName = TableName.valueOf((String)"testMasterAdmin");
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!ZKTableReadOnly.isEnabledTable((ZooKeeperWatcher)zkw, (TableName)TableName.valueOf((String)"testMasterAdmin"))) {
            Thread.sleep(10L);
        }
        this.admin.disableTable(tableName);
        try {
            new HTable(TEST_UTIL.getConfiguration(), tableName);
        }
        catch (DoNotRetryIOException e) {
            // empty catch block
        }
        this.admin.addColumn(tableName, new HColumnDescriptor("col2"));
        this.admin.enableTable(tableName);
        try {
            this.admin.deleteColumn(tableName, Bytes.toBytes((String)"col2"));
        }
        catch (TableNotDisabledException e) {
            this.LOG.info((Object)e);
        }
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    static class DoneListener
    implements EventHandler.EventHandlerListener {
        private final AtomicBoolean done;

        DoneListener(AtomicBoolean done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess(EventHandler event) {
            this.done.set(true);
            AtomicBoolean atomicBoolean = this.done;
            synchronized (atomicBoolean) {
                this.done.notifyAll();
            }
        }

        public void beforeProcess(EventHandler event) {
        }
    }
}

